/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.StringTokenizer;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.AbstractLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.FuzzyPointLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

class SwissprotFeatureTableParser {
    private SeqIOListener listener;
    private String featureSource;
    private boolean inFeature = false;
    private Feature.Template featureTemplate;
    private StringBuffer descBuf = new StringBuffer();

    SwissprotFeatureTableParser(SeqIOListener listener, String source) {
        this.listener = listener;
        this.featureSource = source;
    }

    public void startFeature(String type) throws BioException {
        this.featureTemplate = new Feature.Template();
        this.featureTemplate.source = this.featureSource;
        this.featureTemplate.type = type;
        this.descBuf.setLength(0);
        this.inFeature = true;
    }

    public void featureData(String line) throws BioException {
        boolean newFeature = false;
        if (line.charAt(5) != ' ') {
            StringTokenizer tokens = new StringTokenizer(line);
            this.featureTemplate.location = this.getLocation(tokens);
            line = line.length() >= 20 ? line.substring(20) : "";
            newFeature = true;
        }
        if (newFeature) {
            this.descBuf.setLength(0);
        }
        this.descBuf.append(" " + line.trim());
        boolean bl = false;
    }

    public void endFeature() throws BioException {
        if (this.descBuf.length() > 0) {
            this.featureTemplate.annotation = new SimpleAnnotation();
            try {
                this.featureTemplate.annotation.setProperty("swissprot.featureattribute", this.descBuf.substring(0));
            }
            catch (ChangeVetoException ex) {
                throw new BioException(ex, "Couldn't alter annotation");
            }
        } else {
            this.featureTemplate.annotation = Annotation.EMPTY_ANNOTATION;
        }
        this.listener.startFeature(this.featureTemplate);
        this.listener.endFeature();
        this.inFeature = false;
    }

    public boolean inFeature() {
        return this.inFeature;
    }

    private Location getLocation(StringTokenizer theTokens) throws BioException {
        Index startIndex = this.getIndex(theTokens);
        Index endIndex = this.getIndex(theTokens);
        AbstractLocation theLocation = startIndex.isFuzzy() || endIndex.isFuzzy() ? (startIndex.equals(endIndex) ? new FuzzyPointLocation(startIndex.getMinValue(), startIndex.getMaxValue(), FuzzyPointLocation.RESOLVE_AVERAGE) : new FuzzyLocation(startIndex.getMinValue(), endIndex.getMaxValue(), startIndex.getMaxValue(), endIndex.getMinValue(), startIndex.isFuzzy(), endIndex.isFuzzy(), FuzzyLocation.RESOLVE_INNER)) : (startIndex.equals(endIndex) ? new PointLocation(startIndex.getMinValue()) : new RangeLocation(startIndex.getMinValue(), endIndex.getMinValue()));
        return theLocation;
    }

    private Index getIndex(StringTokenizer theTokens) throws BioException {
        boolean isFuzzy;
        int maxValue;
        int minValue;
        String returnIndex = theTokens.nextToken();
        if (returnIndex.indexOf(60) != -1) {
            returnIndex = returnIndex.substring(1);
            minValue = Integer.MIN_VALUE;
            maxValue = Integer.parseInt(returnIndex);
            isFuzzy = true;
        } else if (returnIndex.indexOf(62) != -1) {
            returnIndex = returnIndex.substring(1);
            maxValue = Integer.MAX_VALUE;
            minValue = Integer.parseInt(returnIndex);
            isFuzzy = true;
        } else if (returnIndex.indexOf(63) != -1) {
            if (returnIndex.length() == 1) {
                minValue = Integer.MIN_VALUE;
                maxValue = Integer.MAX_VALUE;
                isFuzzy = true;
            } else {
                returnIndex = returnIndex.substring(1);
                maxValue = minValue = Integer.parseInt(returnIndex);
                isFuzzy = true;
            }
        } else {
            maxValue = minValue = Integer.parseInt(returnIndex);
            isFuzzy = false;
        }
        return new Index(minValue, maxValue, isFuzzy);
    }

    private class Index {
        protected int mMinValue;
        protected int mMaxValue;
        protected boolean isFuzzy;

        public Index(int theMinValue, int theMaxValue, boolean theFuzzyness) {
            this.mMinValue = theMinValue;
            this.mMaxValue = theMaxValue;
            this.isFuzzy = theFuzzyness;
        }

        public int getMaxValue() {
            return this.mMaxValue;
        }

        public int getMinValue() {
            return this.mMinValue;
        }

        public boolean isFuzzy() {
            return this.isFuzzy;
        }

        public boolean equals(Index theIndex) {
            boolean returnValue = false;
            if (this.mMinValue == theIndex.getMinValue() && this.mMaxValue == theIndex.getMaxValue() && this.isFuzzy == theIndex.isFuzzy()) {
                returnValue = true;
            }
            return returnValue;
        }
    }
}

