/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.BioException;
import org.biojava.bio.program.xff.XFFFeatureSetHandler;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.ragbag.RagbagFileParser;
import org.biojava.bio.seq.ragbag.RagbagFileParserFactory;
import org.biojava.bio.seq.ragbag.RagbagGAMEParser;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class RagbagXFFParser
implements RagbagFileParser {
    public static final RagbagFileParserFactory FACTORY = new RagbagFileParserFactory(){

        public RagbagFileParser getParser(File inputFile) {
            return new RagbagGAMEParser(inputFile);
        }
    };
    public static final String EXTENSION = "xff";
    private SequenceBuilder builder;
    private File inputFile;

    public RagbagXFFParser(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setListener(SequenceBuilder builder) {
        this.builder = builder;
    }

    public void parse() throws BioException {
        final XFFFeatureSetHandler xffhandler = new XFFFeatureSetHandler();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader parser = spf.newSAXParser().getXMLReader();
            xffhandler.setFeatureListener(this.builder);
            parser.setContentHandler(new SAX2StAXAdaptor(new StAXContentHandlerBase(){

                public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                    if (localName.equals("featureSet")) {
                        dm.delegate(xffhandler);
                    }
                }
            }));
            InputSource is = new InputSource(new FileReader(this.inputFile));
            parser.parse(is);
        }
        catch (SAXException se) {
            throw new BioException(se);
        }
        catch (IOException io) {
            throw new BioException(io);
        }
        catch (ParserConfigurationException ex) {
            throw new BioException(ex);
        }
    }
}

