/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.RadialBaseKernel;
import org.biojava.stats.svm.SMOTrainer;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMTarget;

public class ClassifierExample {
    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        f.getContentPane().setLayout(new BorderLayout());
        final PointClassifier pc = new PointClassifier();
        f.getContentPane().add("Center", pc);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        ButtonGroup bGroup = new ButtonGroup();
        final JRadioButton rbPos = new JRadioButton("postive");
        bGroup.add(rbPos);
        JRadioButton rbNeg = new JRadioButton("negative");
        bGroup.add(rbNeg);
        ActionListener addTypeAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JRadioButton rb = (JRadioButton)ae.getSource();
                pc.setAddPos(rbPos.isSelected());
            }
        };
        rbPos.addActionListener(addTypeAction);
        panel.add(rbPos);
        rbNeg.addActionListener(addTypeAction);
        panel.add(rbNeg);
        ActionListener classifyAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                pc.classify();
            }
        };
        JButton classifyB = new JButton("classify");
        classifyB.addActionListener(classifyAction);
        panel.add(classifyB);
        ActionListener clearAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                pc.clear();
            }
        };
        JButton clearB = new JButton("clear");
        clearB.addActionListener(clearAction);
        panel.add(clearB);
        rbPos.setSelected(pc.getAddPos());
        rbNeg.setSelected(!pc.getAddPos());
        JComboBox<String> kernelBox = new JComboBox<String>();
        kernelBox.addItem("polynomeal");
        kernelBox.addItem("rbf");
        kernelBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object o = e.getItem();
                    if (o.equals("polynomeal")) {
                        pc.setKernel(PointClassifier.polyKernel);
                    } else if (o.equals("rbf")) {
                        pc.setKernel(PointClassifier.rbfKernel);
                    }
                }
            }
        });
        panel.add(kernelBox);
        f.getContentPane().add("North", panel);
        f.setSize(400, 300);
        f.setVisible(true);
    }

    public static class PointClassifier
    extends JComponent {
        public static SVMKernel polyKernel;
        public static SVMKernel rbfKernel;
        public static SMOTrainer trainer;
        private SVMTarget target = new SimpleSVMTarget();
        private SVMClassifierModel model = null;
        private boolean addPos;
        private Shape posShape;
        private Shape negShape;
        private Paint svPaint;
        private Paint plainPaint;
        private Paint posPaint;
        private Paint negPaint;
        private SVMKernel kernel;

        public void setKernel(SVMKernel kernel) {
            this.firePropertyChange("kernel", this.kernel, kernel);
            this.kernel = kernel;
        }

        public SVMKernel getKernel() {
            return this.kernel;
        }

        public void setAddPos(boolean addPos) {
            this.firePropertyChange("addPos", this.addPos, addPos);
            this.addPos = addPos;
        }

        public boolean getAddPos() {
            return this.addPos;
        }

        public void setPosShape(Shape posShape) {
            this.firePropertyChange("posShape", this.posShape, posShape);
            this.posShape = posShape;
        }

        public Shape getPosShape() {
            return this.posShape;
        }

        public void setNegShape(Shape negShape) {
            this.firePropertyChange("negShape", this.negShape, negShape);
            this.negShape = negShape;
        }

        public Shape getNegShape() {
            return this.negShape;
        }

        public void clear() {
            this.target.clear();
            this.model = null;
            this.repaint();
        }

        public void classify() {
            new Thread(this){
                private final /* synthetic */ PointClassifier this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    Cursor c = this.this$0.getCursor();
                    this.this$0.setCursor(new Cursor(3));
                    System.out.println("Training");
                    PointClassifier.access$002(this.this$0, PointClassifier.trainer.trainModel(PointClassifier.access$100(this.this$0), PointClassifier.access$200(this.this$0), null));
                    System.out.println("Threshold = " + PointClassifier.access$000(this.this$0).getThreshold());
                    Iterator<E> i = PointClassifier.access$000(this.this$0).items().iterator();
                    while (i.hasNext()) {
                        E item = i.next();
                        System.out.println(item + "\t" + PointClassifier.access$100(this.this$0).getTarget(item) + "\t" + PointClassifier.access$000(this.this$0).getAlpha(item) + "\t" + PointClassifier.access$000(this.this$0).classify(item));
                    }
                    PointClassifier.access$002(this.this$0, PointClassifier.access$000(this.this$0));
                    this.this$0.setCursor(c);
                    this.this$0.repaint();
                }
            }.start();
        }

        public PointClassifier() {
            this.setCursor(new Cursor(1));
            this.addPos = true;
            this.setPosShape(new Rectangle2D.Double(-2.0, -2.0, 5.0, 5.0));
            this.setNegShape(new Ellipse2D.Double(-2.0, -2.0, 5.0, 5.0));
            this.setKernel(polyKernel);
            this.plainPaint = Color.black;
            this.svPaint = Color.green;
            this.posPaint = Color.red;
            this.negPaint = Color.blue;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ PointClassifier this$0;
                {
                    this.this$0 = this$0;
                }

                public void mouseReleased(MouseEvent me) {
                    Point p = me.getPoint();
                    if (this.this$0.getAddPos()) {
                        PointClassifier.access$100(this.this$0).addItemTarget(p, 1.0);
                    } else {
                        PointClassifier.access$100(this.this$0).addItemTarget(p, -1.0);
                    }
                    PointClassifier.access$002(this.this$0, null);
                    this.this$0.repaint();
                }
            });
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform at = new AffineTransform();
            int i = 0;
            Rectangle r = g2.getClipBounds();
            int step = 3;
            if (this.model != null) {
                Rectangle rr = new Rectangle(r.x, r.y, step, step);
                Point p = new Point(r.x, r.y);
                int x = r.x;
                while (x < r.x + r.width) {
                    p.x = x;
                    rr.x = x;
                    int y = r.y;
                    while (y < r.y + r.height) {
                        p.y = y;
                        rr.y = y;
                        double s = this.model.classify(p);
                        if (s <= -1.0) {
                            g2.setPaint(this.negPaint);
                        } else if (s >= 1.0) {
                            g2.setPaint(this.posPaint);
                        } else {
                            g2.setPaint(Color.white);
                        }
                        g2.fill(rr);
                        y += step;
                    }
                    x += step;
                }
            }
            Set supportVectors = Collections.EMPTY_SET;
            if (this.model != null) {
                supportVectors = this.model.items();
            }
            Iterator it = this.target.items().iterator();
            while (it.hasNext()) {
                Point2D p = (Point2D)it.next();
                at.setToTranslation(p.getX(), p.getY());
                Shape glyph = this.target.getTarget(p) > 0.0 ? this.getPosShape() : this.getNegShape();
                Shape s = at.createTransformedShape(glyph);
                if (supportVectors.contains(p)) {
                    g2.setPaint(this.svPaint);
                } else {
                    g2.setPaint(this.plainPaint);
                }
                g2.draw(s);
                ++i;
            }
        }

        static /* synthetic */ SVMClassifierModel access$002(PointClassifier x0, SVMClassifierModel x1) {
            x0.model = x1;
            return x0.model;
        }

        static /* synthetic */ SVMTarget access$100(PointClassifier x0) {
            return x0.target;
        }

        static /* synthetic */ SVMKernel access$200(PointClassifier x0) {
            return x0.kernel;
        }

        static /* synthetic */ SVMClassifierModel access$000(PointClassifier x0) {
            return x0.model;
        }

        static {
            trainer = new SMOTrainer();
            trainer.setC(1.0E7);
            trainer.setEpsilon(1.0E-9);
            SVMKernel k = new SVMKernel(){

                public double evaluate(Object a, Object b) {
                    Point2D pa = (Point2D)a;
                    Point2D pb = (Point2D)b;
                    double dot = pa.getX() * pb.getX() + pa.getY() * pb.getY();
                    return dot;
                }
            };
            PolynomialKernel pk = new PolynomialKernel();
            pk.setNestedKernel(k);
            pk.setOrder(2.0);
            pk.setConstant(1.0);
            pk.setMultiplier(1.0E-7);
            RadialBaseKernel rb = new RadialBaseKernel();
            rb.setNestedKernel(k);
            rb.setWidth(10000.0);
            polyKernel = pk;
            rbfKernel = rb;
        }
    }
}

