/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;

public class RandomAccessReader
extends Reader {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private RandomAccessFile raf;
    private char[] buffer;
    private byte[] bytes;
    private int bufferPos = 0;
    private int bufferEnd = 0;
    private long raPtrPos = 0L;
    private boolean atEOF = false;

    public RandomAccessReader(RandomAccessFile raf) throws IOException {
        this(raf, 8192);
    }

    public RandomAccessReader(RandomAccessFile raf, int sz) throws IOException {
        this.raf = raf;
        this.buffer = new char[sz];
        this.bytes = new byte[sz];
        this.resetBuffer();
    }

    public void close() throws IOException {
        this.raf.close();
        this.raf = null;
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public final int read() throws IOException {
        if (this.atEOF) {
            return -1;
        }
        if (this.bufferPos >= this.bufferEnd && this.fill() < 0) {
            return -1;
        }
        if (this.bufferEnd == 0) {
            return -1;
        }
        return this.buffer[this.bufferPos++];
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.atEOF) {
            return -1;
        }
        int remainder = this.bufferEnd - this.bufferPos;
        if (len <= remainder) {
            System.arraycopy(this.buffer, this.bufferPos, cbuf, off, len);
            this.bufferPos += len;
            return len;
        }
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c == -1) {
                this.atEOF = true;
                return i;
            }
            cbuf[off + i] = (char)c;
            ++i;
        }
        return len;
    }

    public long getFilePointer() throws IOException {
        return this.raPtrPos - (long)this.bufferEnd + (long)this.bufferPos;
    }

    public void seek(long pos) throws IOException {
        int p;
        if (pos < this.raf.length()) {
            this.atEOF = false;
        }
        if ((p = (int)(this.raPtrPos - pos)) >= 0 && p <= this.bufferEnd) {
            this.bufferPos = this.bufferEnd - p;
        } else {
            this.raf.seek(pos);
            this.resetBuffer();
        }
    }

    private int fill() throws IOException {
        int b;
        if (this.raf == null) {
            throw new IOException("Random access file closed");
        }
        int i = b = this.raf.read(this.bytes, 0, 8192);
        while (--i >= 0) {
            this.buffer[i] = (char)this.bytes[i];
        }
        if (b >= 0) {
            this.raPtrPos += (long)b;
            this.bufferPos = 0;
            this.bufferEnd = b;
        }
        return b;
    }

    private void resetBuffer() throws IOException {
        this.bufferPos = 0;
        this.bufferEnd = 0;
        this.raPtrPos = this.raf.getFilePointer();
    }
}

