/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import uk.ac.sanger.artemis.ChangeEvent;
import uk.ac.sanger.artemis.ChangeListener;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.LastSegmentException;
import uk.ac.sanger.artemis.OptionChangeEvent;
import uk.ac.sanger.artemis.OptionChangeListener;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selectable;
import uk.ac.sanger.artemis.io.DateStampFeature;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.OutOfDateException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.StreamFeature;
import uk.ac.sanger.artemis.plot.Codon12CorrelationAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.BasePattern;
import uk.ac.sanger.artemis.sequence.BasePatternFormatException;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerChangeEvent;
import uk.ac.sanger.artemis.sequence.MarkerChangeListener;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class Feature
implements EntryChangeListener,
Selectable,
SequenceChangeListener,
MarkerChangeListener,
OptionChangeListener {
    private Entry entry;
    private uk.ac.sanger.artemis.io.Feature embl_feature;
    private FeatureSegmentVector segments = null;
    private final Vector feature_listener_list = new Vector();
    private AminoAcidSequence amino_acids = null;
    private String bases = null;
    private int aa_count = -1;
    private int base_count = -1;
    private int[][][] codon_counts = null;
    private int[] residue_counts = null;
    private int[][] positional_base_counts = null;
    private int[] base_counts = null;
    private Location old_location = null;
    private int listen_count = 0;

    Feature(uk.ac.sanger.artemis.io.Feature embl_feature) {
        this.embl_feature = embl_feature;
        embl_feature.setUserData(this);
        this.old_location = embl_feature.getLocation();
    }

    public void entryChanged(EntryChangeEvent event) {
    }

    public void markerChanged(MarkerChangeEvent event) {
        try {
            Location old_location = this.getLocation();
            this.updateEMBLFeatureLocation();
            this.locationChanged(old_location);
        }
        catch (ReadOnlyException readOnlyException) {
            // empty catch block
        }
    }

    public void sequenceChanged(SequenceChangeEvent event) {
        try {
            if (event.getType() == 3) {
                this.reverseComplement(this.getEntry().getBases().getLength());
            } else {
                Location old_location = this.getLocation();
                Range this_feature_range = this.getMaxRawRange();
                boolean feature_changed = false;
                if (event.getPosition() >= this_feature_range.getStart() && event.getPosition() <= this_feature_range.getEnd() + 1) {
                    FeatureSegmentVector segments = this.getSegments();
                    for (int i = 0; i < segments.size(); ++i) {
                        FeatureSegment this_segment = segments.elementAt(i);
                        Range this_segment_range = this_segment.getRawRange();
                        if (event.getPosition() < this_segment_range.getStart() || event.getPosition() > this_segment_range.getEnd() + 1) continue;
                        feature_changed = true;
                    }
                }
                this.updateEMBLFeatureLocation();
                if (feature_changed) {
                    this.resetCache();
                    this.locationChanged(old_location);
                }
            }
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public void optionChanged(OptionChangeEvent event) {
        this.locationChanged(this.getLocation());
    }

    uk.ac.sanger.artemis.io.Feature getEmblFeature() {
        return this.embl_feature;
    }

    public void writeNative(Writer writer) throws IOException {
        if (this.getEmblFeature() instanceof StreamFeature) {
            ((StreamFeature)this.getEmblFeature()).writeToStream(writer);
        } else {
            EntryInformation entry_info = this.getEntry().getEntryInformation();
            EmblDocumentEntry document_entry = new EmblDocumentEntry(entry_info);
            uk.ac.sanger.artemis.io.Feature returned_feature = document_entry.forcedAdd(new EmblStreamFeature(this.getEmblFeature()));
            ((EmblStreamFeature)returned_feature).writeToStream(writer);
        }
    }

    public void writePIROfFeature(Writer writer) {
        String gene_name = this.getGeneName();
        String pir_name = gene_name == null ? (this.getLabel() == null ? this.getKey().toString() : this.getLabel()) : gene_name;
        String header_line = ">BL;" + pir_name + ", " + this.getEntry().getName() + " " + this.getWriteRange() + " MW:" + (int)this.getMolecularWeight();
        PrintWriter print_writer = new PrintWriter(writer);
        print_writer.println(header_line);
        String translation_string = this.getTranslation().toString().toUpperCase();
        this.wrapAndWrite(print_writer, translation_string, 80);
        print_writer.println("*");
        print_writer.flush();
    }

    public void writeBasesOfFeature(Writer writer) throws IOException {
        FastaStreamSequence stream_sequence = new FastaStreamSequence(this.getBases(), this.getIDString() + ", " + this.getWriteRange());
        stream_sequence.writeToStream(writer);
    }

    public void writeAminoAcidsOfFeature(Writer writer) throws IOException {
        StringBuffer header_buffer = new StringBuffer(">");
        header_buffer.append(this.getSystematicName());
        header_buffer.append(" ");
        header_buffer.append(this.getIDString());
        header_buffer.append(" ");
        String product = this.getProductString();
        if (product == null) {
            header_buffer.append("undefined product");
        } else {
            header_buffer.append(product);
        }
        header_buffer.append(" ").append(this.getWriteRange()).append(" MW:");
        header_buffer.append((int)this.getMolecularWeight());
        PrintWriter print_writer = new PrintWriter(writer);
        print_writer.println(header_buffer);
        String translation_string = this.getTranslation().toString().toUpperCase();
        this.wrapAndWrite(print_writer, translation_string, 60);
        print_writer.flush();
    }

    public String getUpstreamBases(int count) {
        String bases_string;
        int feature_start_base = this.getFirstBase();
        if (feature_start_base == 1) {
            return "";
        }
        int end_base = feature_start_base - 1;
        int start_base = feature_start_base > count ? feature_start_base - count : 1;
        try {
            bases_string = this.getStrand().getSubSequence(new Range(start_base, end_base));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        return bases_string;
    }

    public String getDownstreamBases(int count) {
        String bases_string;
        int feature_end_base = this.getLastBase();
        if (feature_end_base == this.getSequenceLength()) {
            return "";
        }
        int start_base = feature_end_base + 1;
        int end_base = this.getSequenceLength() - feature_end_base > count ? feature_end_base + count : this.getSequenceLength();
        try {
            bases_string = this.getStrand().getSubSequence(new Range(start_base, end_base));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        return bases_string;
    }

    public String getWriteRange() {
        return this.isForwardFeature() ? this.getFirstCodingBaseMarker().getRawPosition() + ":" + this.getLastBaseMarker().getRawPosition() + " forward" : this.getLastBaseMarker().getRawPosition() + ":" + this.getFirstCodingBaseMarker().getRawPosition() + " reverse";
    }

    private void wrapAndWrite(PrintWriter writer, String string, int wrap_column) {
        String remaining_string = string;
        while (remaining_string.length() > 0) {
            int last_index = wrap_column;
            if (wrap_column > remaining_string.length()) {
                last_index = remaining_string.length();
            }
            String write_string = remaining_string.substring(0, last_index);
            writer.println(write_string);
            remaining_string = remaining_string.substring(last_index);
        }
    }

    public String toString() {
        StringWriter string_writer = new StringWriter();
        try {
            this.writeNative(string_writer);
        }
        catch (IOException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        return string_writer.toString();
    }

    public Reader toReader() {
        return new StringReader(this.toString());
    }

    public boolean isForwardFeature() {
        return !this.getLocation().isComplement();
    }

    public Key getKey() {
        return this.getEmblFeature().getKey();
    }

    public boolean isProteinFeature() {
        return this.getKey().toString().startsWith("CDS") || this.getKey().equals("BLASTCDS");
    }

    public boolean isCDS() {
        return this.getKey().equals("CDS");
    }

    public boolean isPseudoCDS() {
        try {
            return this.getKey().equals("CDS") && this.getQualifierByName("pseudo") != null;
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean isPartialCDS() {
        try {
            return this.getKey().equals("CDS") && this.getQualifierByName("partial") != null;
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean isCodingFeature() {
        return this.getKey().equals("CDS") && !this.isPseudoCDS() || this.getKey().equals("misc_RNA") || this.getKey().equals("mRNA") || this.getKey().equals("precursor_RNA") || this.getKey().equals("rRNA") || this.getKey().equals("scRNA") || this.getKey().equals("snRNA") || this.getKey().equals("tRNA");
    }

    public Location getLocation() {
        Location current_location = this.getEmblFeature().getLocation();
        return current_location;
    }

    private QualifierVector getEmblQualifiers() {
        return this.getEmblFeature().getQualifiers();
    }

    public QualifierVector getQualifiers() {
        return this.getEmblQualifiers();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public int getCodonStart() {
        try {
            String codon_start_string = this.getValueOfQualifier("codon_start");
            if (codon_start_string == null) {
                return 1;
            }
            if (codon_start_string.equals("2")) {
                return 2;
            }
            if (codon_start_string.equals("3")) {
                return 3;
            }
            return 1;
        }
        catch (InvalidRelationException e) {
            return 1;
        }
    }

    public int getScore() {
        try {
            String score_string = this.getValueOfQualifier("score");
            if (score_string == null) {
                return -1;
            }
            try {
                int score_int = Float.valueOf(score_string).intValue();
                if (score_int > 100) {
                    return 100;
                }
                if (score_int < 0) {
                    return 0;
                }
                return score_int;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    void setEntry(Entry entry) {
        if (this.entry != null) {
            this.stopListening();
        }
        Entry old_entry = this.entry;
        this.entry = entry;
        if (old_entry == entry) {
            return;
        }
        if (old_entry != null) {
            this.removeFeatureChangeListener(old_entry);
        }
        if (entry != null) {
            this.addFeatureChangeListener(this.getEntry());
        }
        if (this.entry != null) {
            this.startListening();
        }
    }

    public void set(Key new_key, Location new_location, QualifierVector new_qualifiers) throws EntryInformationException, OutOfRangeException, ReadOnlyException {
        try {
            this.set(null, new_key, new_location, new_qualifiers);
        }
        catch (OutOfDateException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public void set(Date datestamp, Key new_key, Location new_location, QualifierVector new_qualifiers) throws EntryInformationException, OutOfRangeException, ReadOnlyException, OutOfDateException {
        Range span;
        Key old_key = this.getKey();
        this.old_location = this.getLocation();
        QualifierVector old_qualifiers = this.getQualifiers().copy();
        int sequence_length = this.getEntry().getBases().getLength();
        if (new_location != null && ((span = new_location.getTotalRange()).getEnd() > sequence_length || span.getStart() < 1)) {
            throw new OutOfRangeException(new_location.toString());
        }
        if (datestamp == null || !(this.getEmblFeature() instanceof DateStampFeature)) {
            this.getEmblFeature().set(new_key, new_location, new_qualifiers);
        } else {
            ((DateStampFeature)this.getEmblFeature()).set(datestamp, new_key, new_location, new_qualifiers);
        }
        this.resetCache();
        if (new_location != this.old_location) {
            this.reexamineSegments();
        }
        FeatureChangeEvent event = new FeatureChangeEvent(this, this, old_key, this.old_location, old_qualifiers, 4);
        this.fireAction(this.feature_listener_list, event);
    }

    private void locationChanged(Location old_location) {
        this.resetCache();
        FeatureChangeEvent feature_change_event = new FeatureChangeEvent(this, this, null, old_location, null, 1);
        this.old_location = this.getLocation();
        this.fireAction(this.feature_listener_list, feature_change_event);
    }

    public Qualifier addQualifierValues(Qualifier qualifier) throws EntryInformationException, ReadOnlyException {
        Qualifier return_qualifier;
        QualifierVector old_qualifiers = this.getQualifiers().copy();
        Qualifier current_qualifier = this.getEmblFeature().getQualifierByName(qualifier.getName());
        if (current_qualifier == null) {
            return_qualifier = qualifier.copy();
        } else {
            return_qualifier = current_qualifier.copy();
            return_qualifier.addValues(qualifier.getValues());
        }
        this.setQualifier(return_qualifier);
        FeatureChangeEvent event = new FeatureChangeEvent(qualifier, this, null, null, old_qualifiers, 2);
        this.fireAction(this.feature_listener_list, event);
        return return_qualifier;
    }

    public void setQualifier(Qualifier qualifier) throws EntryInformationException, ReadOnlyException {
        QualifierVector old_qualifiers = this.getQualifiers().copy();
        this.getEmblFeature().setQualifier(qualifier);
        FeatureChangeEvent event = new FeatureChangeEvent(qualifier, this, null, null, old_qualifiers, 2);
        if (qualifier.getName().equals("transl_except")) {
            this.amino_acids = null;
        }
        this.fireAction(this.feature_listener_list, event);
    }

    public void removeQualifierByName(String name) throws EntryInformationException, ReadOnlyException, OutOfDateException {
        if (this.getEmblFeature().getQualifierByName(name) == null) {
            return;
        }
        QualifierVector old_qualifiers = this.getQualifiers().copy();
        this.getEmblFeature().removeQualifierByName(name);
        FeatureChangeEvent event = new FeatureChangeEvent(this, this, null, null, old_qualifiers, 2);
        if (name.equals("transl_except")) {
            this.amino_acids = null;
        }
        this.fireAction(this.feature_listener_list, event);
    }

    public Date getDatestamp() {
        if (this.getEmblFeature() instanceof DateStampFeature) {
            return ((DateStampFeature)this.getEmblFeature()).getDatestamp();
        }
        return null;
    }

    public boolean containsText(String search_text, boolean fold_case, boolean match_substring, StringVector qualifier_names) {
        String real_search_text = fold_case ? search_text.toLowerCase() : search_text;
        QualifierVector qualifiers = this.getQualifiers();
        for (int i = 0; i < qualifiers.size(); ++i) {
            StringVector values;
            Qualifier this_qualifier = qualifiers.elementAt(i);
            if (qualifier_names != null && !qualifier_names.contains(this_qualifier.getName()) || (values = this_qualifier.getValues()) == null) continue;
            for (int values_index = 0; values_index < values.size(); ++values_index) {
                String this_value_string = values.elementAt(values_index);
                if (this_value_string == null) continue;
                if (fold_case) {
                    this_value_string = this_value_string.toLowerCase();
                }
                if ((match_substring || !this_value_string.equals(real_search_text)) && (!match_substring || this_value_string.indexOf(real_search_text) == -1)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidStartCodon() {
        if (!this.isCDS()) {
            return true;
        }
        try {
            if (this.getQualifierByName("codon_start") != null && this.isPartialCDS() && this.getFirstBase() == 1) {
                return true;
            }
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        AminoAcidSequence translation = this.getTranslation();
        if (translation.length() < 1) {
            return false;
        }
        String first_codon = this.getTranslationBases().substring(0, 3);
        StringVector start_codons = Options.getOptions().isEukaryoticMode() ? Options.getOptions().getEukaryoticStartCodons() : Options.getOptions().getProkaryoticStartCodons();
        return start_codons.contains(first_codon);
    }

    public boolean hasValidStopCodon() {
        if (!this.isCDS()) {
            return true;
        }
        if (this.isPartialCDS() && this.getLastBase() == this.getEntry().getBases().getLength()) {
            return true;
        }
        int bases_length = this.getBaseCount() - this.getCodonStart() + 1;
        if (bases_length % 3 != 0) {
            return false;
        }
        if (bases_length < 3) {
            return false;
        }
        String codon_string = this.getBases().substring(this.getBaseCount() - 3);
        char last_codon_translation = AminoAcidSequence.getCodonTranslation(codon_string);
        return AminoAcidSequence.isStopCodon(last_codon_translation);
    }

    public boolean hasValidEMBLKey() {
        return this.getEntry().getEntryInformation().isValidKey(this.getKey());
    }

    public boolean hasRequiredQualifiers() {
        StringVector required_qualifiers = this.getEntry().getEntryInformation().getRequiredQualifiers(this.getKey());
        if (required_qualifiers == null) {
            return true;
        }
        try {
            for (int i = 0; i < required_qualifiers.size(); ++i) {
                if (this.getQualifierByName(required_qualifiers.elementAt(i)) != null) continue;
                return false;
            }
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        return true;
    }

    public boolean fixStopCodon() throws ReadOnlyException {
        Range next_codon_range;
        Range last_codon_range;
        Marker last_codon_marker;
        Location old_location = this.getLocation();
        int codon_start = this.getCodonStart();
        if ((this.getBaseCount() - codon_start + 1) % 3 != 0) {
            return false;
        }
        FeatureSegment last_segment = this.getSegments().lastElement();
        Marker last_base_marker = last_segment.getEnd();
        try {
            last_codon_marker = last_base_marker.moveBy(-2);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        try {
            last_codon_range = new Range(last_codon_marker.getPosition(), last_codon_marker.getPosition() + 2);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        String last_codon_string = last_codon_marker.getStrand().getSubSequence(last_codon_range);
        char last_amino_acid_char = AminoAcidSequence.getCodonTranslation(last_codon_string);
        if (AminoAcidSequence.isStopCodon(last_amino_acid_char)) {
            return true;
        }
        try {
            next_codon_range = new Range(last_codon_marker.getPosition() + 3, last_codon_marker.getPosition() + 5);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        String next_codon_string = last_codon_marker.getStrand().getSubSequence(next_codon_range);
        char next_amino_acid_char = AminoAcidSequence.getCodonTranslation(next_codon_string);
        if (AminoAcidSequence.isStopCodon(next_amino_acid_char)) {
            try {
                Marker new_end_marker = last_base_marker.moveBy(3);
                last_segment.setEndPosition(new_end_marker.getPosition());
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            this.updateEMBLFeatureLocation();
            this.locationChanged(old_location);
            return true;
        }
        return false;
    }

    public boolean trimStart(boolean trim_to_any, boolean trim_to_next) throws ReadOnlyException {
        BasePattern search_pattern;
        Location old_location = this.getLocation();
        FeatureSegment first_segment = this.getSegments().elementAt(0);
        if (first_segment.getBaseCount() < 6) {
            return false;
        }
        try {
            search_pattern = trim_to_any ? new BasePattern("dtg") : new BasePattern("atg");
        }
        catch (BasePatternFormatException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        String first_codon_bases = this.getTranslationBases().substring(0, 3);
        Marker current_marker = first_segment.getStart();
        try {
            current_marker = current_marker.moveBy(this.getCodonStart() - 1);
        }
        catch (OutOfRangeException e) {
            return false;
        }
        if (search_pattern.matches(first_codon_bases)) {
            if (trim_to_next) {
                try {
                    current_marker = current_marker.moveBy(3);
                }
                catch (OutOfRangeException e) {
                    return false;
                }
            } else {
                return true;
            }
        }
        int end_of_segment_position = first_segment.getEnd().getPosition();
        int start_of_feature_position = first_segment.getStart().getPosition();
        try {
            String current_codon;
            while (!search_pattern.matches(current_codon = Strand.getCodonAtMarker(current_marker))) {
                int current_marker_position = (current_marker = current_marker.moveBy(3)).getPosition();
                if (current_marker_position <= end_of_segment_position - 2 && (trim_to_next || !(1.0 * (double)(current_marker_position - start_of_feature_position) / (double)this.getTranslationBasesLength() > 0.3))) continue;
                return false;
            }
        }
        catch (OutOfRangeException e) {
            return false;
        }
        try {
            first_segment.setStartPosition(current_marker.getPosition());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        try {
            this.removeQualifierByName("codon_start");
        }
        catch (OutOfDateException _) {
        }
        catch (EntryInformationException _) {
            // empty catch block
        }
        this.updateEMBLFeatureLocation();
        this.locationChanged(old_location);
        return true;
    }

    public String getLabel() {
        try {
            return this.getValueOfQualifier("label");
        }
        catch (InvalidRelationException e) {
            return null;
        }
    }

    private String getGeneName() {
        try {
            return this.getValueOfQualifier("gene");
        }
        catch (InvalidRelationException e) {
            return null;
        }
    }

    public String getIDString() {
        String picked_name = this.pickName(Options.getOptions().getDisplayQualifierNames());
        if (picked_name == null) {
            return this.getKey().toString();
        }
        return picked_name;
    }

    public String getSystematicName() {
        String picked_name = this.pickName(Options.getOptions().getSystematicQualifierNames());
        if (picked_name == null) {
            return this.getIDString();
        }
        return picked_name;
    }

    private String pickName(StringVector qualifier_names) {
        for (int i = 0; i < qualifier_names.size(); ++i) {
            try {
                StringVector values;
                Qualifier qualifier = this.getQualifierByName(qualifier_names.elementAt(i));
                if (qualifier == null || (values = qualifier.getValues()) == null || values.size() <= 0 || values.elementAt(0) == null) continue;
                return values.elementAt(0);
            }
            catch (InvalidRelationException invalidRelationException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getNote() {
        try {
            return this.getValueOfQualifier("note");
        }
        catch (InvalidRelationException e) {
            return null;
        }
    }

    public String getProductString() {
        try {
            return this.getValueOfQualifier("product");
        }
        catch (InvalidRelationException e) {
            return null;
        }
    }

    public int getBaseCount() {
        if (this.base_count == -1) {
            int new_base_count = 0;
            for (int i = 0; i < this.getSegments().size(); ++i) {
                new_base_count += this.getSegments().elementAt(i).getBaseCount();
            }
            this.base_count = new_base_count;
        }
        return this.base_count;
    }

    public String getBases() {
        if (this.bases == null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.getSegments().size(); ++i) {
                buffer.append(this.getSegments().elementAt(i).getBases());
            }
            this.bases = buffer.toString();
        }
        return this.bases;
    }

    public int getTranslationBasesLength() {
        String last_codon;
        char amino_acid_char;
        int mod_value;
        int new_length;
        int codon_start = this.getCodonStart();
        int start_index = codon_start - 1;
        int end_index = this.getBases().length();
        if ((new_length = (end_index -= (mod_value = (end_index - start_index) % 3)) - start_index) >= 3 && AminoAcidSequence.isStopCodon(amino_acid_char = AminoAcidSequence.getCodonTranslation(last_codon = this.getBases().substring(end_index - 3)))) {
            return new_length - 3;
        }
        return new_length;
    }

    public String getTranslationBases() {
        int codon_start = this.getCodonStart();
        int start_index = codon_start - 1;
        int end_index = this.getTranslationBasesLength() + start_index;
        return this.getBases().substring(start_index, end_index);
    }

    private AminoAcidSequence fixTranslationExceptions() {
        String amino_acids_string;
        String new_amino_acids_string = amino_acids_string = this.amino_acids.toString();
        try {
            StringVector values;
            Qualifier except_qualifier = this.getQualifierByName("transl_except");
            if (except_qualifier != null && (values = except_qualifier.getValues()) != null) {
                for (int i = 0; i < values.size(); ++i) {
                    int comma_pos;
                    String value = values.elementAt(i);
                    String START_STRING = "(pos:";
                    String COMMA_STRING = ",aa:";
                    if (!value.startsWith("(pos:") || !value.endsWith(")") || (comma_pos = value.lastIndexOf(",aa:")) < 0) continue;
                    String location_part = value.substring("(pos:".length(), comma_pos);
                    String aa_part = value.substring(comma_pos + ",aa:".length(), value.length() - 1);
                    char aa_part_one_letter_code = AminoAcidSequence.getOneLetterCode(aa_part);
                    if (aa_part_one_letter_code == '\uffff') {
                        aa_part_one_letter_code = '.';
                    }
                    Location location = new Location(location_part);
                    int start_base_in_feature = this.isForwardFeature() ? location.getFirstBase() - this.getRawFirstBase() - (this.getCodonStart() - 1) : this.getRawLastBase() - location.getLastBase() - (this.getCodonStart() - 1);
                    if (start_base_in_feature < 0 || start_base_in_feature >= this.getBaseCount() - this.getCodonStart() + 1) continue;
                    int start_aa_in_feature = start_base_in_feature / 3;
                    new_amino_acids_string = new_amino_acids_string.substring(0, start_aa_in_feature) + aa_part_one_letter_code + new_amino_acids_string.substring(start_aa_in_feature + 1);
                }
            }
        }
        catch (InvalidRelationException e) {
        }
        catch (LocationParseException locationParseException) {
            // empty catch block
        }
        if (new_amino_acids_string == amino_acids_string) {
            return null;
        }
        return new AminoAcidSequence(new_amino_acids_string);
    }

    public AminoAcidSequence getTranslation() {
        if (this.amino_acids == null) {
            this.amino_acids = AminoAcidSequence.getTranslation(this.getTranslationBases(), true);
            if (this.amino_acids.length() == 0) {
                return this.amino_acids;
            }
            AminoAcidSequence fixed_amino_acids = this.fixTranslationExceptions();
            if (fixed_amino_acids != null) {
                this.amino_acids = fixed_amino_acids;
            }
            if (this.isCDS() && !this.isPartialCDS() && this.hasValidStartCodon() && this.amino_acids.elementAt(0) != 'm') {
                String amino_acids_string = this.amino_acids.toString();
                String new_amino_acids_string = 'M' + amino_acids_string.substring(1);
                this.amino_acids = new AminoAcidSequence(new_amino_acids_string);
            }
        }
        return this.amino_acids;
    }

    public int getAACount() {
        if (this.aa_count == -1) {
            this.aa_count = this.getTranslationBasesLength() / 3;
        }
        return this.aa_count;
    }

    public float getMolecularWeight() {
        return this.getTranslation().getMolecularWeight();
    }

    public int getCodonCount(int first, int second, int third) {
        if (this.codon_counts == null) {
            this.setArrays();
        }
        return this.codon_counts[first][second][third];
    }

    public int getResidueCount(int amino_acid_index) {
        if (this.residue_counts == null) {
            this.setArrays();
        }
        return this.residue_counts[amino_acid_index];
    }

    public int getPositionalBaseCount(int codon_base_position, int base_index) {
        if (this.positional_base_counts == null) {
            this.setArrays();
        }
        return this.positional_base_counts[codon_base_position][base_index];
    }

    public int getBaseCount(int base_index) {
        if (this.base_counts == null) {
            this.setArrays();
        }
        return this.base_counts[base_index];
    }

    public double get12CorrelationScore() {
        int t1_count = this.getPositionalBaseCount(0, Bases.getIndexOfBase('t'));
        int c1_count = this.getPositionalBaseCount(0, Bases.getIndexOfBase('c'));
        int a1_count = this.getPositionalBaseCount(0, Bases.getIndexOfBase('a'));
        int g1_count = this.getPositionalBaseCount(0, Bases.getIndexOfBase('g'));
        int t2_count = this.getPositionalBaseCount(1, Bases.getIndexOfBase('t'));
        int c2_count = this.getPositionalBaseCount(1, Bases.getIndexOfBase('c'));
        int a2_count = this.getPositionalBaseCount(1, Bases.getIndexOfBase('a'));
        int g2_count = this.getPositionalBaseCount(1, Bases.getIndexOfBase('g'));
        int c3_count = this.getPositionalBaseCount(2, Bases.getIndexOfBase('c'));
        int g3_count = this.getPositionalBaseCount(2, Bases.getIndexOfBase('g'));
        int base_total = this.getTranslationBases().length();
        double cor1_2_score = 3.0 * (double)t1_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_1[0] + 3.0 * (double)c1_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_1[1] + 3.0 * (double)a1_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_1[2] + 3.0 * (double)g1_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_1[3] + 3.0 * (double)t2_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_2[0] + 3.0 * (double)c2_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_2[1] + 3.0 * (double)a2_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_2[2] + 3.0 * (double)g2_count / (double)base_total * Codon12CorrelationAlgorithm.correlation_score_factors_2[3] + 0.5;
        return cor1_2_score;
    }

    public double getPercentGC() {
        String bases = this.getBases();
        if (bases.length() > 0) {
            int gc_count = 0;
            char[] sequence_chars = new char[bases.length()];
            bases.getChars(0, bases.length(), sequence_chars, 0);
            for (int i = 0; i < bases.length(); ++i) {
                char this_char = sequence_chars[i];
                if (this_char != 'g' && this_char != 'c') continue;
                ++gc_count;
            }
            return 100.0 * (double)gc_count / (double)bases.length();
        }
        return 0.0;
    }

    public int getFirstBase() {
        Marker first_base_marker = this.getFirstBaseMarker();
        if (first_base_marker == null) {
            return 0;
        }
        return first_base_marker.getPosition();
    }

    public int getLastBase() {
        Marker last_base_marker = this.getLastBaseMarker();
        if (last_base_marker == null) {
            return 0;
        }
        return last_base_marker.getPosition();
    }

    public boolean lessThan(Feature other_feature) {
        return this.getFirstBase() < other_feature.getFirstBase();
    }

    public boolean greaterThan(Feature other_feature) {
        return this.getFirstBase() > other_feature.getFirstBase();
    }

    public int getRawFirstBase() {
        int A_BIG_NUMBER = Integer.MAX_VALUE;
        int minimum = Integer.MAX_VALUE;
        for (int i = 0; i < this.getSegments().size(); ++i) {
            int current_minimum = this.isForwardFeature() ? this.getSegments().elementAt(i).getStart().getRawPosition() : this.getSegments().elementAt(i).getEnd().getRawPosition();
            if (current_minimum >= minimum) continue;
            minimum = current_minimum;
        }
        if (minimum == Integer.MAX_VALUE) {
            return 0;
        }
        return minimum;
    }

    public int getRawLastBase() {
        int A_SMALL_NUMBER = -1;
        int maximum = -1;
        for (int i = 0; i < this.getSegments().size(); ++i) {
            int current_maximum = this.isForwardFeature() ? this.getSegments().elementAt(i).getEnd().getRawPosition() : this.getSegments().elementAt(i).getStart().getRawPosition();
            if (current_maximum <= maximum) continue;
            maximum = current_maximum;
        }
        if (maximum == -1) {
            return 0;
        }
        return maximum;
    }

    public Range getMaxRawRange() {
        try {
            return new Range(this.getRawFirstBase(), this.getRawLastBase());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean rawLessThan(Feature other_feature) {
        return this.getRawFirstBase() < other_feature.getRawFirstBase();
    }

    public boolean rawGreaterThan(Feature other_feature) {
        return this.getRawFirstBase() > other_feature.getRawFirstBase();
    }

    public Marker getFirstBaseMarker() {
        int A_BIG_NUMBER = Integer.MAX_VALUE;
        int minimum = Integer.MAX_VALUE;
        Marker minimum_marker = null;
        for (int i = 0; i < this.getSegments().size(); ++i) {
            Marker current_marker = this.getSegments().elementAt(i).getStart();
            int current_minimum = current_marker.getPosition();
            if (current_minimum >= minimum) continue;
            minimum = current_minimum;
            minimum_marker = current_marker;
        }
        return minimum_marker;
    }

    public Marker getLastBaseMarker() {
        long A_SMALL_NUMBER = -1L;
        long maximum = -1L;
        Marker maximum_marker = null;
        for (int i = 0; i < this.getSegments().size(); ++i) {
            Marker current_marker = this.getSegments().elementAt(i).getEnd();
            int current_maximum = current_marker.getPosition();
            if ((long)current_maximum <= maximum) continue;
            maximum = current_maximum;
            maximum_marker = current_marker;
        }
        return maximum_marker;
    }

    public Marker getFirstCodingBaseMarker() {
        Marker first_base_marker = this.getFirstBaseMarker();
        try {
            return first_base_marker.moveBy(this.getCodonStart() - 1);
        }
        catch (OutOfRangeException e) {
            return first_base_marker;
        }
    }

    public Marker getPositionInSequence(int position) throws OutOfRangeException {
        if (position < 1) {
            throw new OutOfRangeException("position: " + position);
        }
        int bases_remaining = position - 1;
        for (int i = 0; i < this.segments.size(); ++i) {
            FeatureSegment this_segment = this.segments.elementAt(i);
            if (bases_remaining < this_segment.getBaseCount()) {
                return this_segment.getStart().moveBy(bases_remaining);
            }
            bases_remaining -= this_segment.getBaseCount();
        }
        throw new OutOfRangeException("position: " + position);
    }

    public int getFeaturePositionFromMarker(Marker base_marker) {
        int bases_so_far = 0;
        int marker_position = base_marker.getPosition();
        for (int i = 0; i < this.segments.size(); ++i) {
            FeatureSegment this_segment = this.segments.elementAt(i);
            int this_segment_start = this_segment.getStart().getPosition();
            int marker_start_diff = marker_position - this_segment_start;
            if (marker_start_diff >= 0 && marker_start_diff < this_segment.getBaseCount()) {
                return bases_so_far + marker_start_diff;
            }
            bases_so_far += this_segment.getBaseCount();
        }
        return -1;
    }

    public Color getColour() {
        String colour_qualifier;
        try {
            colour_qualifier = this.getValueOfQualifier("colour");
            if (colour_qualifier == null) {
                colour_qualifier = this.getValueOfQualifier("color");
            }
        }
        catch (InvalidRelationException e) {
            colour_qualifier = null;
        }
        if (colour_qualifier == null) {
            return Options.getOptions().getDefaultFeatureColour(this.getKey());
        }
        StringVector colours = StringVector.getStrings(colour_qualifier);
        if (colours.size() < 1) {
            return Options.getOptions().getDefaultFeatureColour(this.getKey());
        }
        try {
            if (colours.size() == 3) {
                int red = Integer.parseInt(colours.elementAt(0));
                int green = Integer.parseInt(colours.elementAt(1));
                int blue = Integer.parseInt(colours.elementAt(2));
                if (red < 0) {
                    red = 0;
                }
                if (red > 255) {
                    red = 255;
                }
                if (green < 0) {
                    green = 0;
                }
                if (green > 255) {
                    green = 255;
                }
                if (blue < 0) {
                    blue = 0;
                }
                if (blue > 255) {
                    blue = 255;
                }
                return new Color(red, green, blue);
            }
            String colour_string = colours.elementAt(0);
            int colour_number = Integer.parseInt(colour_string);
            return Options.getOptions().getColorFromColourNumber(colour_number);
        }
        catch (NumberFormatException e) {
            return Options.getOptions().getDefaultFeatureColour(this.getKey());
        }
    }

    public StringVector getValuesOfQualifier(String qualifier_name) throws InvalidRelationException {
        Qualifier this_qualifier = this.getQualifierByName(qualifier_name);
        if (this_qualifier == null) {
            return null;
        }
        return this_qualifier.getValues();
    }

    public Qualifier getQualifierByName(String name) throws InvalidRelationException {
        return this.getEmblFeature().getQualifierByName(name);
    }

    public String getValueOfQualifier(String qualifier_name) throws InvalidRelationException {
        StringVector values = this.getValuesOfQualifier(qualifier_name);
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return "";
        }
        String first_element = values.elementAt(0);
        if (first_element == null) {
            return "";
        }
        return first_element;
    }

    public void removeFromEntry() throws ReadOnlyException {
        this.getEntry().remove(this);
    }

    public FeatureSegmentVector getSegments() {
        Location current_location = this.getEmblFeature().getLocation();
        if (this.segments == null) {
            this.createSegments();
        } else if (current_location != this.old_location) {
            this.reexamineSegments();
            if (!this.old_location.equals(current_location)) {
                this.locationChanged(this.old_location);
                this.old_location = current_location;
            }
        }
        return this.segments;
    }

    private void reexamineSegments() {
        Range new_range;
        int range_index;
        FeatureSegment old_segment;
        int old_segment_index;
        this.stopSegmentsListening();
        Location current_location = this.getEmblFeature().getLocation();
        RangeVector ranges = current_location.getRanges();
        Vector<FeatureSegment> new_segments = new Vector<FeatureSegment>();
        new_segments.setSize(ranges.size());
        FeatureSegmentVector old_segments = (FeatureSegmentVector)this.segments.clone();
        if (current_location.isComplement() != this.old_location.isComplement()) {
            old_segments.removeAllElements();
        }
        block0: for (old_segment_index = old_segments.size() - 1; old_segment_index >= 0; --old_segment_index) {
            old_segment = old_segments.elementAt(old_segment_index);
            for (range_index = 0; range_index < ranges.size(); ++range_index) {
                new_range = ranges.elementAt(range_index);
                if (!old_segment.getRawRange().equals(new_range)) continue;
                old_segment.setRange(new_range);
                new_segments.setElementAt(old_segment, range_index);
                old_segments.removeElementAt(old_segment_index);
                continue block0;
            }
        }
        block2: for (old_segment_index = old_segments.size() - 1; old_segment_index >= 0; --old_segment_index) {
            old_segment = old_segments.elementAt(old_segment_index);
            for (range_index = 0; range_index < ranges.size(); ++range_index) {
                new_range = ranges.elementAt(range_index);
                if (old_segment.getRawRange().getStart() != new_range.getStart() && old_segment.getRawRange().getEnd() != new_range.getEnd()) continue;
                old_segment.setRange(new_range);
                new_segments.setElementAt(old_segment, range_index);
                old_segments.removeElementAt(old_segment_index);
                continue block2;
            }
        }
        for (int new_segment_index = 0; new_segment_index < ranges.size(); ++new_segment_index) {
            Range missing_range = ranges.elementAt(new_segment_index);
            if (new_segments.elementAt(new_segment_index) != null) continue;
            new_segments.setElementAt(this.makeSegment(missing_range), new_segment_index);
        }
        this.segments = new FeatureSegmentVector();
        for (int i = 0; i < ranges.size(); ++i) {
            this.segments.addElementAtEnd((FeatureSegment)new_segments.elementAt(i));
        }
        this.startSegmentsListening();
    }

    public Strand getStrand() {
        if (this.isForwardFeature()) {
            return this.entry.getBases().getForwardStrand();
        }
        return this.entry.getBases().getReverseStrand();
    }

    public Feature duplicate() throws ReadOnlyException {
        EmblStreamFeature new_embl_feature = new EmblStreamFeature(this.getEmblFeature());
        Feature return_feature = new Feature(new_embl_feature);
        try {
            this.getEntry().add(return_feature, false);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        return return_feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(Entry destination_entry, boolean force) throws EntryInformationException, OutOfRangeException, ReadOnlyException {
        if (destination_entry.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.startListening();
        try {
            Entry old_entry = this.getEntry();
            this.getEntry().remove(this);
            try {
                destination_entry.add(this, force);
            }
            catch (EntryInformationException e) {
                old_entry.add(this, true);
                throw e;
            }
        }
        finally {
            this.stopListening();
        }
    }

    public Feature copyTo(Entry destination_entry) throws EntryInformationException, OutOfRangeException, ReadOnlyException {
        if (destination_entry.isReadOnly()) {
            throw new ReadOnlyException();
        }
        EmblStreamFeature new_embl_feature = new EmblStreamFeature(this.getEmblFeature());
        Feature return_feature = new Feature(new_embl_feature);
        destination_entry.add(return_feature, false);
        return return_feature;
    }

    public void addFeatureChangeListener(FeatureChangeListener l) {
        this.feature_listener_list.addElement(l);
    }

    public void removeFeatureChangeListener(FeatureChangeListener l) {
        this.feature_listener_list.removeElement(l);
    }

    public boolean isReadOnly() {
        return this.getEmblFeature().isReadOnly();
    }

    private void updateEMBLFeatureLocation() throws ReadOnlyException {
        boolean complement = this.getLocation().isComplement();
        RangeVector ranges = new RangeVector();
        for (int i = 0; i < this.segments.size(); ++i) {
            ranges.addElement(this.segments.elementAt(i).getRawRange());
        }
        try {
            Location new_location = new Location(ranges, complement);
            this.getEmblFeature().setLocation(new_location);
            this.old_location = new_location;
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - inconsistent location information: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(Vector listeners, ChangeEvent event) {
        Vector targets;
        Feature feature = this;
        synchronized (feature) {
            targets = (Vector)listeners.clone();
        }
        for (int i = 0; i < targets.size(); ++i) {
            ChangeListener target = (ChangeListener)targets.elementAt(i);
            FeatureChangeListener feature_change_listener = (FeatureChangeListener)target;
            feature_change_listener.featureChanged((FeatureChangeEvent)event);
        }
    }

    private void resetCache() {
        this.amino_acids = null;
        this.bases = null;
        this.codon_counts = null;
        this.residue_counts = null;
        this.positional_base_counts = null;
        this.base_counts = null;
        this.aa_count = -1;
        this.base_count = -1;
    }

    private void setArrays() {
        int i;
        String translation_bases = this.getTranslationBases();
        AminoAcidSequence translation = this.getTranslation();
        String translation_string = translation.toString();
        this.codon_counts = new int[4][4][4];
        this.residue_counts = new int[AminoAcidSequence.symbol_count];
        this.base_counts = new int[4];
        this.positional_base_counts = new int[3][4];
        for (i = 0; i < this.residue_counts.length; ++i) {
            this.residue_counts[i] = 0;
        }
        for (i = 0; i < translation_string.length(); ++i) {
            int symbol_index;
            int n = symbol_index = AminoAcidSequence.getSymbolIndex(translation_string.charAt(i));
            this.residue_counts[n] = this.residue_counts[n] + 1;
        }
        for (int first = 0; first < 4; ++first) {
            for (int second = 0; second < 4; ++second) {
                for (int third = 0; third < 4; ++third) {
                    this.codon_counts[first][second][third] = 0;
                }
            }
        }
        for (int base_index = 0; base_index < translation_bases.length(); ++base_index) {
            int index_of_base = Bases.getIndexOfBase(translation_bases.charAt(base_index));
            if (index_of_base >= 4) continue;
            int n = index_of_base;
            this.base_counts[n] = this.base_counts[n] + 1;
        }
        for (i = 0; i < translation_bases.length() / 3; ++i) {
            int first_base_index = Bases.getIndexOfBase(translation_bases.charAt(i * 3));
            int second_base_index = Bases.getIndexOfBase(translation_bases.charAt(i * 3 + 1));
            int third_base_index = Bases.getIndexOfBase(translation_bases.charAt(i * 3 + 2));
            if (first_base_index < 4) {
                int[] nArray = this.positional_base_counts[0];
                int n = first_base_index;
                nArray[n] = nArray[n] + 1;
            }
            if (second_base_index < 4) {
                int[] nArray = this.positional_base_counts[1];
                int n = second_base_index;
                nArray[n] = nArray[n] + 1;
            }
            if (third_base_index < 4) {
                int[] nArray = this.positional_base_counts[2];
                int n = third_base_index;
                nArray[n] = nArray[n] + 1;
            }
            if (first_base_index >= 4 || second_base_index >= 4 || third_base_index >= 4) continue;
            int[] nArray = this.codon_counts[first_base_index][second_base_index];
            int n = third_base_index;
            nArray[n] = nArray[n] + 1;
        }
    }

    private void stopSegmentsListening() {
        if (this.segments != null) {
            for (int i = 0; i < this.segments.size(); ++i) {
                this.segments.elementAt(i).stopListening();
                this.segments.elementAt(i).removeMarkerChangeListener(this);
            }
        }
    }

    private void stopListening() {
        if (this.listen_count == 1) {
            if (this.getEntry() != null && this.getEntry().getBases() != null) {
                Bases bases = this.getEntry().getBases();
                bases.removeSequenceChangeListener(this);
            }
            this.stopSegmentsListening();
            Options.getOptions().removeOptionChangeListener(this);
        }
        --this.listen_count;
        if (this.listen_count < 0) {
            throw new Error("Feature.listen_count < 0");
        }
    }

    private void startSegmentsListening() {
        if (this.segments != null) {
            for (int i = 0; i < this.segments.size(); ++i) {
                this.segments.elementAt(i).startListening();
                this.segments.elementAt(i).addMarkerChangeListener(this);
            }
        }
    }

    private void startListening() {
        if (this.listen_count == 0) {
            if (this.getEntry() != null && this.getEntry().getBases() != null) {
                Bases bases = this.getEntry().getBases();
                this.startSegmentsListening();
                int PRIORITY = -2;
                bases.addSequenceChangeListener(this, -2);
            }
            Options.getOptions().addOptionChangeListener(this);
        }
        ++this.listen_count;
    }

    private void createSegments() {
        this.stopSegmentsListening();
        this.segments = new FeatureSegmentVector();
        Location location = this.getLocation();
        RangeVector ranges = location.getRanges();
        for (int i = 0; i < ranges.size(); ++i) {
            Range this_range = ranges.elementAt(i);
            this.segments.add(this.makeSegment(this_range));
        }
        this.startSegmentsListening();
    }

    private FeatureSegment makeSegment(Range range) {
        return new FeatureSegment(this, range);
    }

    private void setLocationInternal(Location new_location) throws ReadOnlyException, OutOfRangeException {
        this.getEmblFeature().setLocation(new_location);
        if (new_location != this.old_location) {
            this.reexamineSegments();
        }
        this.old_location = new_location;
        this.resetCache();
    }

    public void setLocation(Location new_location) throws ReadOnlyException, OutOfRangeException {
        Location old_location = this.getLocation();
        this.setLocationInternal(new_location);
        this.locationChanged(old_location);
    }

    public void addSegment(Range range) throws ReadOnlyException {
        Location old_location = this.getLocation();
        Location new_location = old_location.addRange(range);
        try {
            this.setLocationInternal(new_location);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - inconsistent location information: " + e);
        }
        this.reexamineSegments();
        this.locationChanged(old_location);
    }

    public void removeSegment(FeatureSegment segment) throws ReadOnlyException, LastSegmentException {
        Location old_location;
        if (this.getSegments().size() > 1) {
            old_location = this.getLocation();
            Location new_location = old_location.removeRange(segment.getRawRange());
            try {
                this.setLocationInternal(new_location);
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - inconsistent location information: " + e);
            }
        } else {
            throw new LastSegmentException();
        }
        this.reexamineSegments();
        this.locationChanged(old_location);
    }

    public static StringVector getAllQualifierNames(FeatureVector features) {
        StringVector qualifier_names = new StringVector();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.elementAt(i);
            QualifierVector qualifiers = feature.getQualifiers();
            for (int qualifier_index = 0; qualifier_index < qualifiers.size(); ++qualifier_index) {
                Qualifier this_qualifier = qualifiers.elementAt(qualifier_index);
                String name = this_qualifier.getName();
                if (qualifier_names.contains(name)) continue;
                qualifier_names.add(name);
            }
        }
        qualifier_names.sort();
        return qualifier_names;
    }

    private void reverseComplement(int sequence_length) throws ReadOnlyException {
        try {
            Location new_location = this.getLocation().reverseComplement(sequence_length);
            this.setLocationInternal(new_location);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - inconsistent location: " + e);
        }
    }

    private int getSequenceLength() {
        return this.getFirstSegment().getStart().getStrand().getSequenceLength();
    }

    private FeatureSegment getFirstSegment() {
        return this.getSegments().elementAt(0);
    }

    void setEmblFeature(uk.ac.sanger.artemis.io.Feature new_embl_feature) {
        this.embl_feature = new_embl_feature;
    }
}

