/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import uk.ac.sanger.artemis.ChangeEvent;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;

public class FeatureChangeEvent
extends ChangeEvent {
    public static final int LOCATION_CHANGED = 1;
    public static final int QUALIFIER_CHANGED = 2;
    public static final int KEY_CHANGED = 3;
    public static final int ALL_CHANGED = 4;
    private Feature feature;
    private int type;
    private Key old_key;
    private Location old_location;
    private QualifierVector old_qualifiers;
    private Key new_key;
    private Location new_location;
    private QualifierVector new_qualifiers;

    public FeatureChangeEvent(Object source, Feature feature, Key old_key, Location old_location, QualifierVector old_qualifiers, int type) {
        super(source);
        this.feature = feature;
        this.type = type;
        this.old_key = old_key;
        this.old_location = old_location;
        this.old_qualifiers = old_qualifiers;
        this.new_key = feature.getKey();
        this.new_location = feature.getLocation();
        this.new_qualifiers = feature.getQualifiers();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getType() {
        return this.type;
    }

    public Key getOldKey() {
        return this.old_key;
    }

    public Location getOldLocation() {
        return this.old_location;
    }

    public QualifierVector getOldQualifiers() {
        return this.old_qualifiers;
    }

    public Key getNewKey() {
        return this.new_key;
    }

    public Location getNewLocation() {
        return this.new_location;
    }

    public QualifierVector getNewQualifiers() {
        return this.new_qualifiers;
    }

    public boolean featureHasChanged() {
        if (this.getOldKey() != null && !this.getOldKey().equals(this.getNewKey())) {
            return true;
        }
        if (this.getOldLocation() != null && !this.getOldLocation().equals(this.getNewLocation())) {
            return true;
        }
        return this.getOldQualifiers() != null && !this.getOldQualifiers().equals(this.getNewQualifiers());
    }
}

