/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeaturePredicateVector;

public class FeaturePredicateConjunction
implements FeaturePredicate {
    public static final int AND = 1;
    public static final int OR = 0;
    private FeaturePredicateVector predicates = new FeaturePredicateVector();
    private int type;

    public FeaturePredicateConjunction(FeaturePredicate predicate1, FeaturePredicate predicate2, int type) {
        this.type = type;
        this.predicates.add(predicate1);
        this.predicates.add(predicate2);
        if (type != 0 && type != 1) {
            throw new Error("internal error - illegal type given to FeaturePredicateConjunction constructor");
        }
    }

    public FeaturePredicateConjunction(FeaturePredicateVector predicates, int type) {
        this.predicates = predicates.copy();
        this.type = type;
        if (type != 0 && type != 1) {
            throw new Error("internal error - illegal type given to FeaturePredicateConjunction constructor");
        }
        if (predicates.size() == 0) {
            throw new Error("internal error - no predicates given to FeaturePredicateConjunction constructor");
        }
    }

    public boolean testPredicate(Feature feature) {
        for (int i = 0; i < this.predicates.size(); ++i) {
            if (this.type == 1) {
                if (this.predicates.elementAt(i).testPredicate(feature)) continue;
                return false;
            }
            if (!this.predicates.elementAt(i).testPredicate(feature)) continue;
            return true;
        }
        return this.type == 1;
    }
}

