/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import uk.ac.sanger.artemis.ExternalProgramEvent;
import uk.ac.sanger.artemis.ExternalProgramMonitor;
import uk.ac.sanger.artemis.Logger;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.SimpleExternalProgramMonitor;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.Task;

public class TaskMonitor
extends SimpleExternalProgramMonitor
implements ExternalProgramMonitor {
    private final int SLEEP_TIME;
    public final Task task;

    public TaskMonitor(Task task, String name, Logger logger) {
        super(name, logger);
        this.task = task;
        this.SLEEP_TIME = 1000 * Options.getOptions().getIntegerProperty("jcon_task_check_time");
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Status status = this.task.getStatus();
                    String message = null;
                    if (status == null) {
                        message = this.getProgramName() + " disappeared";
                    } else {
                        int status_id = status.getId();
                        switch (status_id) {
                            case 4: {
                                message = this.getProgramName() + " completed";
                                break;
                            }
                            case 5: {
                                message = this.getProgramName() + " failed";
                                break;
                            }
                            case 6: {
                                message = this.getProgramName() + " cancelled";
                                break;
                            }
                            case 7: {
                                message = this.getProgramName() + " skipped";
                                break;
                            }
                        }
                    }
                    if (message != null) {
                        ExternalProgramEvent event = new ExternalProgramEvent(1, message, this.task);
                        this.sendEvent(event);
                        this.getLogger().log(message + "\n");
                        return;
                    }
                    Thread.sleep(this.SLEEP_TIME);
                }
            }
            catch (IllegalStateException e) {
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

