/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.biojava.bio.symbol.IllegalSymbolException;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.EntrySourceVector;
import uk.ac.sanger.artemis.EntryVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.LastSegmentException;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.ChoiceFrame;
import uk.ac.sanger.artemis.components.EntryEdit;
import uk.ac.sanger.artemis.components.EntryHeaderEdit;
import uk.ac.sanger.artemis.components.FeatureEdit;
import uk.ac.sanger.artemis.components.FeatureListFrame;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.QualifierEditor;
import uk.ac.sanger.artemis.components.SelectionMenu;
import uk.ac.sanger.artemis.components.TextDialog;
import uk.ac.sanger.artemis.components.TextRequester;
import uk.ac.sanger.artemis.components.TextRequesterEvent;
import uk.ac.sanger.artemis.components.TextRequesterListener;
import uk.ac.sanger.artemis.components.Utilities;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.OutOfDateException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class EditMenu
extends SelectionMenu
implements EntryGroupChangeListener,
EntryChangeListener {
    static final KeyStroke EDIT_FEATURES_KEY = KeyStroke.getKeyStroke(69, 2);
    public static final int EDIT_FEATURES_KEY_CODE = 69;
    static final KeyStroke MERGE_FEATURES_KEY = KeyStroke.getKeyStroke(77, 2);
    public static final int MERGE_FEATURES_KEY_CODE = 77;
    static final KeyStroke DUPLICATE_KEY = KeyStroke.getKeyStroke(68, 2);
    public static final int DUPLICATE_KEY_CODE = 68;
    static final KeyStroke DELETE_FEATURES_KEY = KeyStroke.getKeyStroke(127, 2);
    public static final int DELETE_FEATURES_KEY_CODE = 127;
    static final KeyStroke TRIM_FEATURES_KEY = KeyStroke.getKeyStroke(84, 2);
    public static final int TRIM_FEATURES_KEY_CODE = 84;
    static final KeyStroke TRIM_FEATURES_TO_NEXT_ANY_KEY = KeyStroke.getKeyStroke(89, 2);
    public static final int TRIM_FEATURES_TO_NEXT_ANY_KEY_CODE = 89;
    public static final int EXTEND_TO_PREVIOUS_STOP_CODON_KEY_CODE = 81;
    static final KeyStroke EXTEND_TO_PREVIOUS_STOP_CODON_KEY = SelectionMenu.makeMenuKeyStroke(81);
    public static final int UNDO_KEY_CODE = 85;
    static final KeyStroke UNDO_KEY = KeyStroke.getKeyStroke(85, 2);
    private static final int MAXIMUM_SELECTED_FEATURES = 25;
    private GotoEventSource goto_event_source = null;
    private EntryGroup entry_group = null;
    private BasePlotGroup base_plot_group = null;
    private JMenuItem undo_item = null;
    private JMenuItem edit_feature_item = null;
    private JMenuItem raw_edit_feature_item = null;
    private JMenuItem duplicate_item = null;
    private JMenuItem merge_features_item = null;
    private JMenuItem unmerge_feature_item = null;
    private JMenuItem delete_features_item = null;
    private JMenuItem edit_header_item = null;
    private JMenuItem add_qualifiers_item = null;
    private JMenuItem remove_qualifier_item = null;
    private JMenuItem delete_segments_item = null;
    private JMenuItem delete_introns_item = null;
    private JMenuItem edit_subsequence_item = null;
    private JMenuItem paste_item = null;
    private JMenu move_features_menu = null;
    private JMenu copy_features_menu = null;
    private JMenuItem trim_item = null;
    private JMenuItem trim_to_any_item = null;
    private JMenuItem trim_to_next_item = null;
    private JMenuItem trim_to_next_any_item = null;
    private JMenuItem extend_to_next_stop_item = null;
    private JMenuItem extend_to_prev_stop_item = null;
    private JMenuItem auto_label_item = null;
    private JMenuItem auto_gene_name_item = null;
    private JMenuItem fix_gene_names_item = null;
    private JMenuItem fix_stop_codons_item = null;
    private JMenuItem reverse_complement_item = null;
    private JMenuItem delete_bases_item = null;
    private JMenuItem add_bases_item = null;
    private JMenuItem add_bases_from_file_item = null;

    public EditMenu(JFrame frame, Selection selection, GotoEventSource goto_event_source, EntryGroup entry_group, BasePlotGroup base_plot_group, String menu_name) {
        super(frame, menu_name, selection);
        this.entry_group = entry_group;
        this.goto_event_source = goto_event_source;
        this.base_plot_group = base_plot_group;
        this.getEntryGroup().addEntryGroupChangeListener(this);
        this.getEntryGroup().addEntryChangeListener(this);
        this.refreshMenu();
    }

    public EditMenu(JFrame frame, Selection selection, GotoEventSource goto_event_source, EntryGroup entry_group, BasePlotGroup base_plot_group) {
        this(frame, selection, goto_event_source, entry_group, base_plot_group, "Edit");
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.refreshMenu();
            }
        }
    }

    public void entryChanged(EntryChangeEvent event) {
        if (event.getType() == 3) {
            this.refreshMenu();
        }
    }

    private void refreshMenu() {
        this.removeAll();
        this.undo_item = new JMenuItem("Undo");
        this.undo_item.setAccelerator(UNDO_KEY);
        this.undo_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.undo(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup());
            }
        });
        this.edit_feature_item = new JMenuItem("Edit Selected Features");
        this.edit_feature_item.setAccelerator(EDIT_FEATURES_KEY);
        this.edit_feature_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.editSelectedFeatures(EditMenu.this.getParentFrame(), EditMenu.this.getEntryGroup(), EditMenu.this.getSelection(), EditMenu.this.getGotoEventSource());
            }
        });
        this.edit_subsequence_item = new JMenuItem("Edit Subsequence (and Features)");
        this.edit_subsequence_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.editSubSequence();
            }
        });
        this.add_qualifiers_item = new JMenuItem("Change Qualifiers Of Selected ...");
        this.add_qualifiers_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.addQualifiers(EditMenu.this.getParentFrame(), EditMenu.this.getSelection());
            }
        });
        this.remove_qualifier_item = new JMenuItem("Remove Qualifier Of Selected ...");
        this.remove_qualifier_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.removeQualifier(EditMenu.this.getParentFrame(), EditMenu.this.getSelection());
            }
        });
        this.merge_features_item = new JMenuItem("Merge Selected Features");
        this.merge_features_item.setAccelerator(MERGE_FEATURES_KEY);
        this.merge_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.mergeFeatures(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup());
            }
        });
        this.unmerge_feature_item = new JMenuItem("Unmerge Selected Feature");
        this.unmerge_feature_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.unmergeFeature(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup());
            }
        });
        this.duplicate_item = new JMenuItem("Duplicate Selected Features");
        this.duplicate_item.setAccelerator(DUPLICATE_KEY);
        this.duplicate_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.duplicateFeatures(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup());
            }
        });
        this.delete_features_item = new JMenuItem("Delete Selected Features");
        this.delete_features_item.setAccelerator(DELETE_FEATURES_KEY);
        this.delete_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.deleteSelectedFeatures(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup());
            }
        });
        this.delete_segments_item = new JMenuItem("Delete Selected Exons");
        this.delete_segments_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.deleteSelectedSegments();
            }
        });
        this.delete_introns_item = new JMenuItem("Remove Introns of Selected Features");
        this.delete_introns_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.removeIntrons();
            }
        });
        this.edit_header_item = new JMenuItem("Edit Header Of Default Entry");
        this.edit_header_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.editHeader();
            }
        });
        this.move_features_menu = new JMenu("Move Selected Features To");
        this.copy_features_menu = new JMenu("Copy Selected Features To");
        if (this.entry_group == null || this.getEntryGroup().size() == 0) {
            this.move_features_menu.add(new JMenuItem("(No Entries Currently)"));
            this.copy_features_menu.add(new JMenuItem("(No Entries Currently)"));
        } else {
            for (int i = 0; i < this.getEntryGroup().size(); ++i) {
                final Entry this_entry = this.getEntryGroup().elementAt(i);
                String entry_name = this_entry.getName();
                if (entry_name == null) {
                    entry_name = "no name";
                }
                JMenuItem move_to_item = new JMenuItem(entry_name);
                move_to_item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        FeatureVector selected_features = EditMenu.this.getSelection().getAllFeatures();
                        EditMenu.this.getSelection().clear();
                        EditMenu.this.moveFeatures(selected_features, this_entry);
                        EditMenu.this.getSelection().set(selected_features);
                    }
                });
                this.move_features_menu.add(move_to_item);
                JMenuItem copy_to_item = new JMenuItem(entry_name);
                copy_to_item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        EditMenu.this.copyFeatures(EditMenu.this.getSelection().getAllFeatures(), this_entry);
                    }
                });
                this.copy_features_menu.add(copy_to_item);
            }
        }
        this.trim_to_any_item = new JMenuItem("Trim Selected Features To Any");
        this.trim_to_any_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.trimSelected(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup(), true, false);
            }
        });
        this.trim_item = new JMenuItem("Trim Selected Features To Met");
        this.trim_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.trimSelected(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup(), false, false);
            }
        });
        this.trim_to_next_any_item = new JMenuItem("Trim Selected Features To Next Any");
        this.trim_to_next_any_item.setAccelerator(TRIM_FEATURES_TO_NEXT_ANY_KEY);
        this.trim_to_next_any_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.trimSelected(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup(), true, true);
            }
        });
        this.trim_to_next_item = new JMenuItem("Trim Selected Features To Next Met");
        this.trim_to_next_item.setAccelerator(TRIM_FEATURES_KEY);
        this.trim_to_next_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.trimSelected(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup(), false, true);
            }
        });
        this.extend_to_prev_stop_item = new JMenuItem("Extend to Previous Stop Codon");
        this.extend_to_prev_stop_item.setAccelerator(EXTEND_TO_PREVIOUS_STOP_CODON_KEY);
        this.extend_to_prev_stop_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.extendToORF(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup(), false);
            }
        });
        this.extend_to_next_stop_item = new JMenuItem("Extend to Next Stop Codon");
        this.extend_to_next_stop_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.extendToORF(EditMenu.this.getParentFrame(), EditMenu.this.getSelection(), EditMenu.this.getEntryGroup(), true);
            }
        });
        this.fix_stop_codons_item = new JMenuItem("Fix Stop Codons");
        this.fix_stop_codons_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.fixStopCodons();
            }
        });
        this.auto_gene_name_item = new JMenuItem("Automatically Create Gene Names");
        this.auto_gene_name_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.autoGeneName();
            }
        });
        this.fix_gene_names_item = new JMenuItem("Fix Gene Names");
        this.fix_gene_names_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.fixGeneNames(EditMenu.this.getParentFrame(), EditMenu.this.getEntryGroup(), EditMenu.this.getSelection());
            }
        });
        this.reverse_complement_item = new JMenuItem("Reverse And Complement");
        this.reverse_complement_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.reverseAndComplement();
            }
        });
        this.delete_bases_item = new JMenuItem("Delete Selected Bases");
        this.delete_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.deleteSelectedBases();
            }
        });
        this.add_bases_item = new JMenuItem("Add Bases At Selection");
        this.add_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EditMenu.this.addBases();
            }
        });
        if (Options.readWritePossible()) {
            this.add_bases_from_file_item = new JMenuItem("Add Bases From File ...");
            this.add_bases_from_file_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    EditMenu.this.addBasesFromFile();
                }
            });
        }
        if (Options.getOptions().getPropertyTruthValue("val_mode")) {
            this.add(this.edit_feature_item);
            this.add(this.edit_subsequence_item);
            this.addSeparator();
            this.add(this.edit_header_item);
            this.addSeparator();
        }
        if (Options.getOptions().getUndoLevels() > 0) {
            this.add(this.undo_item);
            this.addSeparator();
        }
        if (!Options.getOptions().getPropertyTruthValue("val_mode")) {
            this.add(this.edit_feature_item);
            this.add(this.edit_subsequence_item);
            this.addSeparator();
            this.add(this.edit_header_item);
            this.addSeparator();
        }
        this.add(this.add_qualifiers_item);
        this.add(this.remove_qualifier_item);
        this.add(this.duplicate_item);
        this.add(this.merge_features_item);
        this.add(this.unmerge_feature_item);
        this.add(this.delete_features_item);
        this.add(this.delete_segments_item);
        this.add(this.delete_introns_item);
        this.addSeparator();
        this.add(this.move_features_menu);
        this.add(this.copy_features_menu);
        this.addSeparator();
        this.add(this.trim_item);
        this.add(this.trim_to_any_item);
        this.add(this.trim_to_next_item);
        this.add(this.trim_to_next_any_item);
        this.add(this.extend_to_prev_stop_item);
        this.add(this.extend_to_next_stop_item);
        this.add(this.fix_stop_codons_item);
        this.addSeparator();
        this.add(this.auto_gene_name_item);
        this.add(this.fix_gene_names_item);
        this.add(this.reverse_complement_item);
        this.add(this.delete_bases_item);
        this.add(this.add_bases_item);
        if (Options.readWritePossible()) {
            this.add(this.add_bases_from_file_item);
        }
    }

    public static void undo(JFrame frame, Selection selection, EntryGroup entry_group) {
        if (Options.getOptions().getUndoLevels() == 0) {
            return;
        }
        if (entry_group.getActionController().canUndo()) {
            selection.clear();
        }
        if (!entry_group.getActionController().undo()) {
            new MessageDialog(frame, "sorry - no further undo information");
        }
    }

    static void editSelectedFeatures(JFrame frame, EntryGroup entry_group, Selection selection, GotoEventSource goto_event_source) {
        FeatureVector features_to_edit = selection.getAllFeatures();
        if (features_to_edit.size() > 25) {
            new MessageDialog(frame, "warning: only editing the first 25 selected features");
        }
        for (int i = 0; i < features_to_edit.size() && i < 25; ++i) {
            Feature selection_feature = features_to_edit.elementAt(i);
            new FeatureEdit(selection_feature, entry_group, selection, goto_event_source).show();
        }
        selection.set(features_to_edit);
    }

    private void editSubSequence() {
        if (this.getSelection().isEmpty()) {
            new MessageDialog(this.getParentFrame(), "nothing selected");
        }
        Range range = this.getSelection().getSelectionRange();
        EntryGroup new_entry_group = this.getEntryGroup().truncate(range);
        new EntryEdit(new_entry_group).show();
    }

    private void editHeader() {
        Entry default_entry = this.getEntryGroup().getDefaultEntry();
        if (default_entry == null) {
            String message = "there is no default entry";
            new MessageDialog(this.getParentFrame(), "there is no default entry");
        } else {
            if (default_entry.isReadOnly()) {
                new MessageDialog(this.getParentFrame(), "the default entry is read-only - cannot continue");
                return;
            }
            new EntryHeaderEdit(this.entry_group, default_entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mergeFeatures(JFrame frame, Selection selection, EntryGroup entry_group) {
        try {
            boolean delete_old_features;
            String message;
            Feature new_feature;
            YesNoDialog dialog;
            entry_group.getActionController().startAction();
            if (!SelectionMenu.checkForSelectionFeatures(frame, selection, 10, "really merge all (>10) selected features?")) {
                return;
            }
            FeatureVector features_to_merge = selection.getAllFeatures();
            if (features_to_merge.size() < 2) {
                new MessageDialog(frame, "nothing to merge - select more than one feature");
                return;
            }
            Feature merge_feature = features_to_merge.elementAt(0);
            for (int i = 1; i < features_to_merge.size(); ++i) {
                Feature this_feature = features_to_merge.elementAt(i);
                if (this_feature.isForwardFeature() != merge_feature.isForwardFeature()) {
                    new MessageDialog(frame, "all the features in a merge must be on the same strand");
                    return;
                }
                if (this_feature.getKey().equals(merge_feature.getKey())) continue;
                new MessageDialog(frame, "all the features in a merge must have the same key");
                return;
            }
            Options.getOptions();
            if (Options.isNoddyMode() && !(dialog = new YesNoDialog(frame, "Are you sure you want to merge the selected features?")).getResult()) {
                return;
            }
            try {
                new_feature = merge_feature.duplicate();
            }
            catch (ReadOnlyException e) {
                String message2 = "one or more of the features is read-only or is in a read-only entry - cannot continue";
                new MessageDialog(frame, "one or more of the features is read-only or is in a read-only entry - cannot continue");
                entry_group.getActionController().endAction();
                return;
            }
            for (int i = 1; i < features_to_merge.size(); ++i) {
                Feature this_feature = features_to_merge.elementAt(i);
                QualifierVector qualifiers = this_feature.getQualifiers();
                for (int qualifier_index = 0; qualifier_index < qualifiers.size(); ++qualifier_index) {
                    String message3;
                    Qualifier this_qualifier = qualifiers.elementAt(qualifier_index);
                    try {
                        new_feature.addQualifierValues(this_qualifier);
                        continue;
                    }
                    catch (EntryInformationException e) {
                        try {
                            new_feature.removeFromEntry();
                        }
                        catch (ReadOnlyException _) {
                            // empty catch block
                        }
                        message3 = "destination entry does not support all the qualifiers needed by " + this_feature.getIDString();
                        new MessageDialog(frame, message3);
                        continue;
                    }
                    catch (ReadOnlyException e) {
                        message3 = "the new feature is read-only so some qualifiers have been lost";
                        new MessageDialog(frame, "the new feature is read-only so some qualifiers have been lost");
                    }
                }
                FeatureSegmentVector segments = this_feature.getSegments();
                for (int segment_index = 0; segment_index < segments.size(); ++segment_index) {
                    FeatureSegment this_segment = segments.elementAt(segment_index);
                    Range this_range = this_segment.getRawRange();
                    try {
                        new_feature.addSegment(this_range);
                        continue;
                    }
                    catch (ReadOnlyException e) {
                        message = "merging failed because the entry is read-only";
                        new MessageDialog(frame, "merging failed because the entry is read-only");
                        try {
                            new_feature.removeFromEntry();
                            continue;
                        }
                        catch (ReadOnlyException _) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean keep_looping = true;
            block29: while (keep_looping) {
                FeatureSegmentVector feature_segments = new_feature.getSegments();
                keep_looping = false;
                for (int segment_index = 0; segment_index < feature_segments.size() - 1; ++segment_index) {
                    FeatureSegment next_segment;
                    MarkerRange next_range;
                    FeatureSegment this_segment = feature_segments.elementAt(segment_index);
                    MarkerRange this_range = this_segment.getMarkerRange();
                    if (!this_range.overlaps(next_range = (next_segment = feature_segments.elementAt(segment_index + 1)).getMarkerRange()) || this_segment.getFrameID() != next_segment.getFrameID()) continue;
                    try {
                        Range new_range = this_range.combineRanges(next_range, false).getRawRange();
                        new_feature.addSegment(new_range);
                        new_feature.removeSegment(this_segment);
                        new_feature.removeSegment(next_segment);
                        keep_looping = true;
                        continue block29;
                    }
                    catch (ReadOnlyException e) {
                        message = "merging failed because the entry is read-only";
                        new MessageDialog(frame, "merging failed because the entry is read-only");
                        continue;
                    }
                    catch (LastSegmentException e) {
                        throw new Error("internal error - tried to remove last segment: " + e);
                    }
                }
            }
            Options.getOptions();
            if (Options.isNoddyMode()) {
                YesNoDialog delete_old_dialog = new YesNoDialog(frame, "delete old features?");
                delete_old_features = delete_old_dialog.getResult();
            } else {
                delete_old_features = true;
            }
            if (delete_old_features) {
                if (EditMenu.getReadOnlyFeatures(features_to_merge).size() > 0) {
                    new MessageDialog(frame, "deletion failed because the features are read-only");
                } else {
                    for (int i = 0; i < features_to_merge.size(); ++i) {
                        try {
                            features_to_merge.elementAt(i).removeFromEntry();
                            continue;
                        }
                        catch (ReadOnlyException e) {
                            new MessageDialog(frame, "deletion failed one or more of the features are read-only");
                        }
                    }
                }
            }
            selection.set(new_feature);
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unmergeFeature(JFrame frame, Selection selection, EntryGroup entry_group) {
        try {
            int index_of_second_segment;
            entry_group.getActionController().startAction();
            FeatureSegmentVector selected_segments = selection.getSelectedSegments();
            if (selected_segments.size() != 2) {
                String message = "you need to select exactly two exons use unmerge";
                new MessageDialog(frame, "you need to select exactly two exons use unmerge");
                return;
            }
            FeatureSegment first_segment = selected_segments.elementAt(0);
            FeatureSegment second_segment = selected_segments.elementAt(1);
            if (first_segment.getFeature() != second_segment.getFeature()) {
                String message = "you need to select two exons from the same feature to use unmerge";
                new MessageDialog(frame, "you need to select two exons from the same feature to use unmerge");
                return;
            }
            Feature segment_feature = first_segment.getFeature();
            FeatureSegmentVector all_feature_segments = segment_feature.getSegments();
            int index_of_first_segment = all_feature_segments.indexOf(first_segment);
            if (index_of_first_segment - (index_of_second_segment = all_feature_segments.indexOf(second_segment)) < -1 || index_of_first_segment - index_of_second_segment > 1) {
                String message = "you need to select two adjacent exons to use unmerge";
                new MessageDialog(frame, "you need to select two adjacent exons to use unmerge");
                return;
            }
            if (index_of_second_segment < index_of_first_segment) {
                FeatureSegment temp_segment = first_segment;
                int temp_segment_index = index_of_first_segment;
                first_segment = second_segment;
                index_of_first_segment = index_of_second_segment;
                second_segment = temp_segment;
                index_of_second_segment = temp_segment_index;
            }
            try {
                int i;
                Feature new_feature = segment_feature.duplicate();
                selection.clear();
                for (i = all_feature_segments.size() - 1; i >= index_of_second_segment; --i) {
                    segment_feature.getSegments().elementAt(i).removeFromFeature();
                }
                for (i = 0; i <= index_of_first_segment; ++i) {
                    new_feature.getSegments().elementAt(0).removeFromFeature();
                }
                selection.set(segment_feature.getSegments().lastElement());
                selection.add(new_feature.getSegments().elementAt(0));
            }
            catch (ReadOnlyException e) {
                String message = "the selected exons (in " + segment_feature.getIDString() + ") are in a read only entry - cannot continue";
                new MessageDialog(frame, message);
            }
            catch (LastSegmentException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    private void addQualifiers(JFrame frame, Selection selection) {
        if (!SelectionMenu.checkForSelectionFeatures(frame, selection)) {
            return;
        }
        FeatureVector selected_features = selection.getAllFeatures();
        if (EditMenu.getReadOnlyFeatures(selected_features).size() > 0) {
            new MessageDialog(frame, "one or more of the selected features is read-only - cannot continue");
            return;
        }
        QualifierEditor qualifier_editor = new QualifierEditor(selected_features, this.getEntryGroup());
        ((Component)qualifier_editor).setVisible(true);
    }

    private void removeQualifier(JFrame frame, Selection selection) {
        if (!SelectionMenu.checkForSelectionFeatures(frame, selection)) {
            return;
        }
        final FeatureVector selected_features = selection.getAllFeatures();
        StringVector qualifier_names = Feature.getAllQualifierNames(selected_features);
        if (qualifier_names.size() == 0) {
            new MessageDialog(this.getParentFrame(), "feature has no qualifiers");
            return;
        }
        final ChoiceFrame choice_frame = new ChoiceFrame("Select a qualifer name", qualifier_names);
        final JComboBox choice = choice_frame.getChoice();
        int MAX_VISIBLE_ROWS = 30;
        choice.setMaximumRowCount(30);
        choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                EditMenu.this.removeQualifierFromFeatures(selected_features, (String)choice.getSelectedItem());
                ((Component)choice_frame).setVisible(false);
                choice_frame.dispose();
            }
        });
        choice_frame.getOKButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                EditMenu.this.removeQualifierFromFeatures(selected_features, (String)choice.getSelectedItem());
            }
        });
        ((Component)choice_frame).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeQualifierFromFeatures(FeatureVector features, String qualifier_name) {
        boolean found_read_only = false;
        try {
            this.entry_group.getActionController().startAction();
            for (int i = 0; i < features.size(); ++i) {
                Feature this_feature = features.elementAt(i);
                try {
                    this_feature.removeQualifierByName(qualifier_name);
                    continue;
                }
                catch (OutOfDateException _) {
                    continue;
                }
                catch (EntryInformationException _) {
                    continue;
                }
                catch (ReadOnlyException _) {
                    found_read_only = true;
                }
            }
            if (found_read_only) {
                String message = "ignored one or more read-only features";
                new MessageDialog(this.getParentFrame(), "ignored one or more read-only features");
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void duplicateFeatures(JFrame frame, Selection selection, EntryGroup entry_group) {
        try {
            entry_group.getActionController().startAction();
            if (EditMenu.getReadOnlyFeatures(selection.getAllFeatures()).size() > 0) {
                new MessageDialog(frame, "one or more of the selected features is read-only - cannot continue");
                return;
            }
            Options.getOptions();
            if (Options.isNoddyMode()) {
                YesNoDialog dialog = new YesNoDialog(frame, "Are you sure you want to duplicate the selected features?");
                if (!dialog.getResult()) {
                    return;
                }
            } else if (!SelectionMenu.checkForSelectionFeatures(frame, selection, 100, "really duplicate all (>100) selected features?")) {
                return;
            }
            FeatureVector features_to_duplicate = selection.getAllFeatures();
            for (int i = 0; i < features_to_duplicate.size(); ++i) {
                Feature this_feature = features_to_duplicate.elementAt(i);
                try {
                    this_feature.duplicate();
                    continue;
                }
                catch (ReadOnlyException e) {
                    String message = "one of the selected features (" + this_feature.getIDString() + ")  is read only - cannot continue";
                    new MessageDialog(frame, message);
                    entry_group.getActionController().endAction();
                    return;
                }
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteSelectedFeatures(JFrame frame, Selection selection, EntryGroup entry_group) {
        try {
            entry_group.getActionController().startAction();
            FeatureVector features_to_delete = selection.getAllFeatures();
            String feature_count_string = features_to_delete.size() == 1 ? "the selected feature" : features_to_delete.size() + " features";
            Options.getOptions();
            if (Options.isNoddyMode() && !SelectionMenu.checkForSelectionFeatures(frame, selection, 0, "really delete " + feature_count_string + "?")) {
                return;
            }
            selection.clear();
            while (features_to_delete.size() > 0) {
                Feature current_selection_feature = features_to_delete.lastElement();
                features_to_delete.removeElementAt(features_to_delete.size() - 1);
                try {
                    current_selection_feature.removeFromEntry();
                }
                catch (ReadOnlyException e) {
                    selection.set(current_selection_feature);
                    if (features_to_delete.size() == 1) {
                        String message = "the selected feature (" + current_selection_feature.getIDString() + ") is read only - cannot continue";
                        new MessageDialog(frame, message);
                    } else {
                        String message = "one of the selected features (" + current_selection_feature.getIDString() + ") is read only - cannot continue";
                        new MessageDialog(frame, message);
                    }
                    features_to_delete.add(current_selection_feature);
                    selection.set(features_to_delete);
                    entry_group.getActionController().endAction();
                    return;
                }
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedSegments() {
        try {
            this.entry_group.getActionController().startAction();
            FeatureSegmentVector segments_to_delete = (FeatureSegmentVector)this.getSelection().getSelectedSegments().clone();
            Options.getOptions();
            if (Options.isNoddyMode() && !this.checkForSelectionFeatureSegments(0, "really delete " + (segments_to_delete.size() == 1 ? "the selected exon?" : segments_to_delete.size() + " exons?"))) {
                return;
            }
            for (int i = 0; i < segments_to_delete.size(); ++i) {
                String message;
                FeatureSegment selection_segment = segments_to_delete.elementAt(i);
                try {
                    this.getSelection().remove(selection_segment);
                    selection_segment.removeFromFeature();
                    continue;
                }
                catch (ReadOnlyException e) {
                    message = "one of the selected exons (in " + selection_segment.getFeature().getIDString() + ") is in a read only - cannot continue";
                    new MessageDialog(this.getParentFrame(), message);
                    continue;
                }
                catch (LastSegmentException e) {
                    message = "the last exon in this feature: " + selection_segment.getFeature().getIDString() + " cannot be removed (all features must have at least one exon)";
                    new MessageDialog(this.getParentFrame(), message);
                }
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIntrons() {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        boolean found_read_only = false;
        try {
            this.entry_group.getActionController().startAction();
            FeatureVector features = this.getSelection().getAllFeatures();
            for (int i = 0; i < features.size(); ++i) {
                Feature this_feature = features.elementAt(i);
                try {
                    RangeVector new_ranges = new RangeVector();
                    Range new_range = this_feature.getMaxRawRange();
                    new_ranges.add(new_range);
                    Location old_location = this_feature.getLocation();
                    Location new_location = new Location(new_ranges, old_location.isComplement());
                    this_feature.setLocation(new_location);
                    continue;
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                catch (ReadOnlyException _) {
                    found_read_only = true;
                }
            }
            if (found_read_only) {
                String message = "ignored one or more read-only features";
                new MessageDialog(this.getParentFrame(), "ignored one or more read-only features");
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFeatures(FeatureVector features, Entry destination_entry) {
        try {
            this.entry_group.getActionController().startAction();
            if (features.size() == 0) {
                return;
            }
            FeatureVector read_only_features = EditMenu.getReadOnlyFeatures(features);
            if (read_only_features.size() > 0) {
                String message = (features.size() == 1 ? "the selected feature (" + read_only_features.elementAt(0).getIDString() + ") is read only " : "some of the selected features (eg. " + read_only_features.elementAt(0).getIDString() + ") are read only - ") + "cannot continue";
                new MessageDialog(this.getParentFrame(), message);
                return;
            }
            block10: for (int i = 0; i < features.size(); ++i) {
                Feature this_feature = features.elementAt(i);
                int MAX_COUNT = 100;
                int count = 0;
                while (count++ < 100) {
                    try {
                        this_feature.moveTo(destination_entry, false);
                        continue block10;
                    }
                    catch (OutOfRangeException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                    catch (EntryInformationException e) {
                        EntryInformation dest_entry_information = destination_entry.getEntryInformation();
                        dest_entry_information.fixException(e);
                    }
                    catch (ReadOnlyException e) {
                        String message = "either the source or destination for one of the features is read only - cannot continue";
                        new MessageDialog(this.getParentFrame(), "either the source or destination for one of the features is read only - cannot continue");
                        this.entry_group.getActionController().endAction();
                        return;
                    }
                }
                String message = "internal error while copying";
                new MessageDialog(this.getParentFrame(), "internal error while copying");
                throw new Error("internal error in EditMenu.copyFeatures() - infinite loop");
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFeatures(FeatureVector features, Entry destination_entry) {
        try {
            this.entry_group.getActionController().startAction();
            block8: for (int i = 0; i < features.size(); ++i) {
                Feature this_feature = features.elementAt(i);
                int MAX_COUNT = 100;
                int count = 0;
                while (count++ < 100) {
                    try {
                        this_feature.copyTo(destination_entry);
                        continue block8;
                    }
                    catch (OutOfRangeException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                    catch (EntryInformationException e) {
                        EntryInformation dest_entry_information = destination_entry.getEntryInformation();
                        dest_entry_information.fixException(e);
                    }
                    catch (ReadOnlyException e) {
                        String message = "the destination entry is read only - cannot continue";
                        new MessageDialog(this.getParentFrame(), "the destination entry is read only - cannot continue");
                        this.entry_group.getActionController().endAction();
                        return;
                    }
                }
                String message = "internal error while copying";
                new MessageDialog(this.getParentFrame(), "internal error while copying");
                throw new Error("internal error in EditMenu.copyFeatures() - infinite loop");
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixStopCodons() {
        try {
            Feature selection_feature;
            int i;
            this.entry_group.getActionController().startAction();
            if (!this.checkForSelectionFeatures()) {
                return;
            }
            FeatureVector bad_features = new FeatureVector();
            FeatureVector features_to_fix = this.getSelection().getAllFeatures();
            for (i = 0; i < features_to_fix.size(); ++i) {
                selection_feature = features_to_fix.elementAt(i);
                if (selection_feature.isCDS()) continue;
                String message = "Warning: some of the selected features are not coding features. Continue?";
                YesNoDialog yes_no_dialog = new YesNoDialog(this.getParentFrame(), "Warning: some of the selected features are not coding features. Continue?");
                if (yes_no_dialog.getResult()) break;
                return;
            }
            for (i = 0; i < features_to_fix.size(); ++i) {
                selection_feature = features_to_fix.elementAt(i);
                try {
                    if (selection_feature.fixStopCodon()) continue;
                    bad_features.add(selection_feature);
                    continue;
                }
                catch (ReadOnlyException e) {
                    String message = "one of the entries is read only - cannot continue";
                    new MessageDialog(this.getParentFrame(), "one of the entries is read only - cannot continue");
                    break;
                }
            }
            if (bad_features.size() > 0) {
                this.getSelection().set(bad_features);
                String message = "Warning: could not fix the stop codon for some of the features. View them now?";
                YesNoDialog yes_no_dialog = new YesNoDialog(this.getParentFrame(), "Warning: could not fix the stop codon for some of the features. View them now?");
                if (yes_no_dialog.getResult()) {
                    FeatureFromVectorPredicate predicate = new FeatureFromVectorPredicate(bad_features);
                    String filter_name = "features that can't be fixed (filtered from: " + this.getParentFrame().getTitle() + ")";
                    FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(this.entry_group, predicate, filter_name);
                    FeatureListFrame feature_list_frame = new FeatureListFrame(filter_name, this.getSelection(), this.goto_event_source, filtered_entry_group, this.base_plot_group);
                    ((Component)feature_list_frame).setVisible(true);
                }
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trimSelected(JFrame frame, Selection selection, EntryGroup entry_group, boolean trim_to_any, boolean trim_to_next) {
        try {
            entry_group.getActionController().startAction();
            if (!SelectionMenu.checkForSelectionFeatures(frame, selection)) {
                return;
            }
            FeatureVector features_to_trim = selection.getAllFeatures();
            FeatureVector failed_features = new FeatureVector();
            for (int i = 0; i < features_to_trim.size(); ++i) {
                Feature selection_feature = features_to_trim.elementAt(i);
                try {
                    if (selection_feature.trimStart(trim_to_any, trim_to_next)) continue;
                    failed_features.add(selection_feature);
                    continue;
                }
                catch (ReadOnlyException e) {
                    String message = "one or more of the of the selected features are read only - cannot continue";
                    new MessageDialog(frame, "one or more of the of the selected features are read only - cannot continue");
                    break;
                }
            }
            if (failed_features.size() > 0) {
                selection.set(failed_features);
                if (failed_features.size() == 1) {
                    String message = "could not trim the feature";
                    new MessageDialog(frame, "could not trim the feature");
                } else {
                    String message = "some features could not be trimmed (they are now selected)";
                    new MessageDialog(frame, "some features could not be trimmed (they are now selected)");
                }
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extendToORF(JFrame frame, Selection selection, EntryGroup entry_group, boolean extend_to_next_stop) {
        try {
            entry_group.getActionController().startAction();
            if (!SelectionMenu.checkForSelectionFeatures(frame, selection)) {
                return;
            }
            FeatureVector features_to_extend = selection.getAllFeatures();
            for (int i = 0; i < features_to_extend.size(); ++i) {
                Marker feature_start_marker;
                char first_aa;
                FeatureSegmentVector feature_segments;
                Feature selection_feature = features_to_extend.elementAt(i);
                if (selection_feature.isReadOnly()) {
                    String message = "one or more of the of the selected features are read only - cannot continue";
                    new MessageDialog(frame, "one or more of the of the selected features are read only - cannot continue");
                    break;
                }
                if (selection_feature.getSegments().size() < 1 || (feature_segments = selection_feature.getSegments()).size() == 0) continue;
                Strand strand = selection_feature.getStrand();
                if (extend_to_next_stop) {
                    if (selection_feature.hasValidStopCodon()) continue;
                    Marker feature_end_marker = selection_feature.getLastBaseMarker();
                    Marker end_marker_copy = null;
                    try {
                        end_marker_copy = selection_feature.getBaseCount() == 1 ? feature_end_marker : (selection_feature.getBaseCount() == 2 ? feature_end_marker.moveBy(-1) : feature_end_marker.moveBy(-2));
                        int frame_shift = selection_feature.getCodonStart() - 1;
                        int bases_from_start_pos_mod_3 = (3 + selection_feature.getBaseCount() - frame_shift) % 3;
                        end_marker_copy = end_marker_copy.moveBy(-bases_from_start_pos_mod_3);
                    }
                    catch (OutOfRangeException e) {
                        end_marker_copy = feature_end_marker;
                    }
                    MarkerRange end_orf_range = Strand.getORFAroundMarker(end_marker_copy, true);
                    if (end_orf_range == null) continue;
                    Marker new_end_marker = end_orf_range.getEnd();
                    try {
                        feature_end_marker.setPosition(new_end_marker.getPosition());
                        continue;
                    }
                    catch (OutOfRangeException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                }
                AminoAcidSequence translation = selection_feature.getTranslation();
                if (translation.length() > 0 && AminoAcidSequence.isStopCodon(first_aa = translation.elementAt(0))) continue;
                Marker start_marker_copy = feature_start_marker = selection_feature.getFirstBaseMarker();
                int frame_shift = selection_feature.getCodonStart() - 1;
                if (frame_shift != 0) {
                    try {
                        start_marker_copy = feature_start_marker.moveBy(frame_shift);
                    }
                    catch (OutOfRangeException e) {
                        // empty catch block
                    }
                }
                MarkerRange start_orf_range = Strand.getORFAroundMarker(start_marker_copy, true);
                Marker new_start_marker = start_orf_range.getStart();
                try {
                    feature_start_marker.setPosition(new_start_marker.getPosition());
                    selection_feature.removeQualifierByName("codon_start");
                    continue;
                }
                catch (EntryInformationException _) {
                    continue;
                }
                catch (OutOfDateException _) {
                    continue;
                }
                catch (ReadOnlyException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    private void reverseAndComplement() {
        if (this.getEntryGroup().isReadOnly()) {
            String message = "one or more of the entries or features are read only - cannot continue";
            new MessageDialog(this.getParentFrame(), "one or more of the entries or features are read only - cannot continue");
            return;
        }
        YesNoDialog dialog = new YesNoDialog(this.getParentFrame(), "Are you sure you want to reverse complement all entries?");
        if (!dialog.getResult()) {
            return;
        }
        try {
            this.getEntryGroup().reverseComplement();
            this.makeSelectionStartVisible();
        }
        catch (ReadOnlyException e) {
            String message = "one of the entries is read only - cannot continue";
            new MessageDialog(this.getParentFrame(), "one of the entries is read only - cannot continue");
            return;
        }
    }

    private void deleteSelectedBases() {
        YesNoDialog dialog;
        FeatureVector features_in_range;
        if (!this.checkForSelectionRange()) {
            return;
        }
        MarkerRange marker_range = this.getSelection().getMarkerRange();
        if (marker_range.getCount() == this.getEntryGroup().getSequenceLength()) {
            new MessageDialog(this.getParentFrame(), "You can't delete every base");
            return;
        }
        if (this.getEntryGroup().isReadOnly()) {
            new MessageDialog(this.getParentFrame(), "one of the current entries or features is read-only - connot continue");
            return;
        }
        Range raw_range = marker_range.getRawRange();
        EntryVector old_active_entries = this.getEntryGroup().getActiveEntries();
        for (int i = 0; i < this.getEntryGroup().size(); ++i) {
            this.getEntryGroup().setIsActive(i, true);
        }
        try {
            features_in_range = this.getEntryGroup().getFeaturesInRange(raw_range);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        if (features_in_range.size() != 0) {
            FeatureVector read_only_features = EditMenu.getReadOnlyFeatures(features_in_range);
            if (read_only_features.size() > 0) {
                this.getSelection().set(read_only_features);
                String message = "one or more of the features in the selected range are read only - cannot continue";
                new MessageDialog(this.getParentFrame(), "one or more of the features in the selected range are read only - cannot continue");
                this.getSelection().setMarkerRange(marker_range);
                return;
            }
            for (int feature_index = 0; feature_index < features_in_range.size(); ++feature_index) {
                Feature this_feature = features_in_range.elementAt(feature_index);
                FeatureSegmentVector segments = this_feature.getSegments();
                for (int i = 0; i < segments.size(); ++i) {
                    FeatureSegment this_segment = segments.elementAt(i);
                    Range this_segment_range = this_segment.getRawRange();
                    if ((raw_range.getStart() > this_segment_range.getStart() || raw_range.getEnd() < this_segment_range.getStart()) && (raw_range.getStart() > this_segment_range.getEnd() || raw_range.getEnd() < this_segment_range.getEnd())) continue;
                    new MessageDialog(this.getParentFrame(), "the selected range overlaps the start or end of an exon - cannot continue");
                    return;
                }
            }
        }
        for (int i = 0; i < this.getEntryGroup().size(); ++i) {
            Entry this_entry = this.getEntryGroup().elementAt(i);
            boolean old_active_flag = old_active_entries.contains(this_entry);
            this.getEntryGroup().setIsActive(i, old_active_flag);
        }
        Options.getOptions();
        if (Options.isNoddyMode() && !(dialog = new YesNoDialog(this.getParentFrame(), "Are you sure you want to delete the selected bases?")).getResult()) {
            return;
        }
        try {
            this.getSelection().setMarkerRange(null);
            Strand.deleteRange(marker_range);
        }
        catch (ReadOnlyException e) {
            this.getSelection().setMarkerRange(marker_range);
            new MessageDialog(this.getParentFrame(), "the bases are read only - cannot delete");
            return;
        }
    }

    private void addBases() {
        if (!this.checkForSelectionRange()) {
            return;
        }
        if (this.getEntryGroup().isReadOnly()) {
            new MessageDialog(this.getParentFrame(), "one of the current entries or features is read-only - connot continue");
            return;
        }
        final MarkerRange range = this.getSelection().getMarkerRange();
        TextRequester text_requester = new TextRequester("enter the bases to insert before base " + range.getStart().getPosition() + (range.isForwardMarker() ? " on the forward strand" : " on the reverse strand") + ":", 18, "");
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                if (event.getType() == 2) {
                    return;
                }
                String bases_string = event.getRequesterText().trim();
                if (bases_string.length() == 0) {
                    new MessageDialog(EditMenu.this.getParentFrame(), "no bases inserted");
                    return;
                }
                try {
                    Strand.addBases(range.getStart(), bases_string);
                }
                catch (ReadOnlyException e) {
                    new MessageDialog(EditMenu.this.getParentFrame(), "sorry the bases are read only");
                    return;
                }
                catch (IllegalSymbolException e) {
                    new MessageDialog(EditMenu.this.getParentFrame(), "sorry - new sequence contains non-IUB base codes");
                    return;
                }
            }
        });
        text_requester.show();
    }

    private void addBasesFromFile() {
        if (!this.checkForSelectionRange()) {
            return;
        }
        if (this.getEntryGroup().isReadOnly()) {
            new MessageDialog(this.getParentFrame(), "one of the current entries or features is read-only - connot continue");
            return;
        }
        MarkerRange range = this.getSelection().getMarkerRange();
        EntrySourceVector entry_sources = Utilities.getEntrySources(this.getParentFrame(), null);
        EntrySource filesystem_entry_source = null;
        for (int source_index = 0; source_index < entry_sources.size(); ++source_index) {
            EntrySource this_source = entry_sources.elementAt(source_index);
            if (this_source.isFullEntrySource() || !this_source.getSourceName().equals("Filesystem")) continue;
            filesystem_entry_source = this_source;
        }
        if (filesystem_entry_source == null) {
            throw new Error("internal error - can't find a file system to read from");
        }
        try {
            Entry new_entry = filesystem_entry_source.getEntry(true);
            Bases bases = new_entry.getBases();
            String bases_string = bases.toString();
            if (bases_string.length() == 0) {
                new MessageDialog(this.getParentFrame(), "no bases inserted");
                return;
            }
            Strand.addBases(range.getStart(), bases_string);
        }
        catch (ReadOnlyException e) {
            new MessageDialog(this.getParentFrame(), "sorry the bases are read only");
            return;
        }
        catch (IOException e) {
            new MessageDialog(this.getParentFrame(), "error while reading: " + e.getMessage());
            return;
        }
        catch (OutOfRangeException e) {
            new MessageDialog(this.getParentFrame(), "out of range exception while reading: " + e.getMessage());
            return;
        }
        catch (NoSequenceException e) {
            new MessageDialog(this.getParentFrame(), "sorry the file did not contain any sequence");
            return;
        }
        catch (IllegalSymbolException e) {
            new MessageDialog(this.getParentFrame(), "sorry - new sequence contains non-IUB base codes");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void autoGeneNameHelper(FeatureVector features_to_name, String prefix_string, int start_number, int increment, String qualifier_name, boolean tag_complement_names) {
        try {
            this.entry_group.getActionController().startAction();
            int current_number = start_number;
            for (int i = 0; i < features_to_name.size(); ++i) {
                Feature this_feature = features_to_name.elementAt(i);
                Key key = this_feature.getKey();
                if (!key.equals("CDS")) continue;
                String number_string = current_number < 10 ? "000" + current_number : (current_number < 100 ? "00" + current_number : (current_number < 1000 ? "0" + current_number : String.valueOf(current_number)));
                try {
                    Qualifier new_qualifier = new Qualifier(qualifier_name, prefix_string + number_string + (!tag_complement_names || this_feature.isForwardFeature() ? "" : "c"));
                    this_feature.addQualifierValues(new_qualifier);
                }
                catch (EntryInformationException e) {
                    new MessageDialog(this.getParentFrame(), "/" + qualifier_name + " not supported by this entry " + "- cannot continue");
                    this.entry_group.getActionController().endAction();
                    return;
                }
                catch (ReadOnlyException e) {
                    new MessageDialog(this.getParentFrame(), "one of the features is in a read-only entry - cannot continue");
                    this.entry_group.getActionController().endAction();
                    return;
                }
                current_number += increment;
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    private void autoGeneName() {
        int increment_value;
        int start_value;
        if (!SelectionMenu.checkForSelectionFeatures(this.getParentFrame(), this.getSelection())) {
            return;
        }
        FeatureVector features_to_name = this.getSelection().getAllFeatures();
        if (EditMenu.getReadOnlyFeatures(features_to_name).size() > 0) {
            new MessageDialog(this.getParentFrame(), "one or more of the current features is read-only - cannot continue");
            return;
        }
        TextDialog prefix_dialog = new TextDialog(this.getParentFrame(), "enter the start characters of the new gene names:", 18, "");
        String prefix_text = prefix_dialog.getText();
        if (prefix_text == null) {
            return;
        }
        String prefix_string = prefix_text.trim();
        if (prefix_string.length() == 0) {
            new MessageDialog(this.getParentFrame(), "no prefix given");
            return;
        }
        TextDialog start_number_dialog = new TextDialog(this.getParentFrame(), "start counting at:", 18, "1");
        String start_number_text = start_number_dialog.getText();
        if (start_number_text == null) {
            return;
        }
        String start_string = start_number_text.trim();
        if (start_string.length() == 0) {
            new MessageDialog(this.getParentFrame(), "no start given");
            return;
        }
        try {
            start_value = Integer.valueOf(start_string);
        }
        catch (NumberFormatException e) {
            new MessageDialog(this.getParentFrame(), "this is not a number: " + start_string);
            return;
        }
        TextDialog increment_dialog = new TextDialog(this.getParentFrame(), "increment number by:", 18, "1");
        String increment_text = increment_dialog.getText();
        if (increment_text == null) {
            return;
        }
        String increment_string = increment_text.trim();
        if (increment_string.length() == 0) {
            new MessageDialog(this.getParentFrame(), "no increment given");
            return;
        }
        try {
            increment_value = Integer.valueOf(increment_string);
        }
        catch (NumberFormatException e) {
            new MessageDialog(this.getParentFrame(), "this is not a number: " + increment_string);
            return;
        }
        TextDialog qualifier_name_dialog = new TextDialog(this.getParentFrame(), "enter a qualifier name to use", 18, "gene");
        String qualifier_name_text = qualifier_name_dialog.getText();
        if (qualifier_name_text == null) {
            return;
        }
        String qualifier_name_string = qualifier_name_text.trim();
        if (qualifier_name_string.length() == 0) {
            new MessageDialog(this.getParentFrame(), "no qualifier name given");
            return;
        }
        YesNoDialog complement_tag_dialog = new YesNoDialog(this.getParentFrame(), "append \"c\" to names of reverse strand features?");
        this.autoGeneNameHelper(features_to_name, prefix_string, start_value, increment_value, qualifier_name_string, complement_tag_dialog.getResult());
    }

    private static boolean fixGeneNamesHelper(JFrame frame, EntryGroup entry_group, Feature cds_to_fix) {
        if (cds_to_fix.isReadOnly()) {
            String message = "one or more of the of the selected features are read only - cannot continue";
            new MessageDialog(frame, "one or more of the of the selected features are read only - cannot continue");
            return false;
        }
        try {
            int feature_index;
            String message;
            YesNoDialog dialog;
            Strand cds_to_fix_strand = cds_to_fix.getStrand();
            Marker cds_start_marker = cds_to_fix.getFirstBaseMarker();
            Marker cds_end_marker = cds_to_fix.getLastBaseMarker();
            try {
                cds_start_marker = cds_start_marker.moveBy(-1);
            }
            catch (OutOfRangeException _) {
                // empty catch block
            }
            try {
                cds_end_marker = cds_end_marker.moveBy(1);
            }
            catch (OutOfRangeException _) {
                // empty catch block
            }
            Range search_range = cds_start_marker.getRawPosition() < cds_end_marker.getRawPosition() ? new Range(cds_start_marker.getRawPosition(), cds_end_marker.getRawPosition()) : new Range(cds_end_marker.getRawPosition(), cds_start_marker.getRawPosition());
            FeatureVector features_in_range = entry_group.getFeaturesInRange(search_range);
            FeatureVector features_to_change = new FeatureVector();
            for (int i = 0; i < features_in_range.size(); ++i) {
                Feature this_feature = features_in_range.elementAt(i);
                if (this_feature.getStrand() != cds_to_fix_strand || !(this_feature.isCDS() || this_feature.getKey().equals("mRNA") || this_feature.getKey().equals("intron") || this_feature.getKey().equals("exon") || this_feature.getKey().equals("5'UTR") && cds_to_fix.getFirstBase() == this_feature.getLastBase() + 1 || this_feature.getKey().equals("3'UTR") && cds_to_fix.getLastBase() + 1 == this_feature.getFirstBase()) && !this_feature.getKey().equals("gene")) continue;
                if (this_feature.isReadOnly()) {
                    String message2 = "one or more of the of the overlapping features are read only - cannot continue";
                    new MessageDialog(frame, "one or more of the of the overlapping features are read only - cannot continue");
                    return false;
                }
                features_to_change.add(this_feature);
            }
            FeatureVector overlapping_cds_features = new FeatureVector();
            for (int i = 0; i < features_to_change.size(); ++i) {
                Feature this_test_feature = features_to_change.elementAt(i);
                if (this_test_feature == cds_to_fix || !this_test_feature.isCDS()) continue;
                overlapping_cds_features.add(this_test_feature);
                features_to_change.remove(this_test_feature);
            }
            if (overlapping_cds_features.size() > 0 && !(dialog = new YesNoDialog(frame, message = "your CDS (" + cds_to_fix.getIDString() + ") overlaps " + overlapping_cds_features.size() + " other CDS feature" + (overlapping_cds_features.size() == 1 ? "" : "s") + " - continue?")).getResult()) {
                return false;
            }
            StringVector gene_names = new StringVector();
            for (feature_index = 0; feature_index < features_to_change.size(); ++feature_index) {
                Feature test_feature = features_to_change.elementAt(feature_index);
                StringVector test_feature_gene_names = test_feature.getValuesOfQualifier("gene");
                if (test_feature_gene_names == null) continue;
                for (int test_feature_gene_name_index = 0; test_feature_gene_name_index < test_feature_gene_names.size(); ++test_feature_gene_name_index) {
                    String this_gene_name = test_feature_gene_names.elementAt(test_feature_gene_name_index);
                    if (gene_names.contains(this_gene_name)) continue;
                    gene_names.add(this_gene_name);
                }
            }
            if (gene_names.size() == 0) {
                return true;
            }
            for (feature_index = 0; feature_index < features_to_change.size(); ++feature_index) {
                Feature this_feature = features_to_change.elementAt(feature_index);
                Qualifier qualifier = new Qualifier("gene", gene_names);
                this_feature.setQualifier(qualifier);
            }
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixGeneNames(JFrame frame, EntryGroup entry_group, Selection selection) {
        try {
            entry_group.getActionController().startAction();
            FeatureVector features_to_fix = selection.getAllFeatures();
            int cds_features_found = 0;
            for (int i = 0; i < features_to_fix.size(); ++i) {
                Feature selection_feature = features_to_fix.elementAt(i);
                if (!selection_feature.isCDS()) continue;
                ++cds_features_found;
                if (EditMenu.fixGeneNamesHelper(frame, entry_group, selection_feature)) continue;
                return;
            }
            if (cds_features_found == 0) {
                new MessageDialog(frame, "no CDS features selected");
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }

    private void makeSelectionStartVisible() {
        GotoEvent new_event = new GotoEvent(this, this.getSelection().getStartBaseOfSelection());
        this.goto_event_source.sendGotoEvent(new_event);
    }

    private GotoEventSource getGotoEventSource() {
        return this.goto_event_source;
    }

    private static FeatureVector getReadOnlyFeatures(FeatureVector features) {
        FeatureVector return_vector = new FeatureVector();
        for (int i = 0; i < features.size(); ++i) {
            Feature this_feature = features.elementAt(i);
            if (!this_feature.isReadOnly()) continue;
            return_vector.add(this_feature);
        }
        return return_vector;
    }
}

