/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import javax.swing.JFrame;
import uk.ac.sanger.artemis.components.MarkerRangeRequester;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.TextRequesterEvent;
import uk.ac.sanger.artemis.io.LocationLexer;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class MarkerRangeRequesterEvent
extends TextRequesterEvent {
    public MarkerRangeRequesterEvent(MarkerRangeRequester source, String requester_text, int type) {
        super(source, requester_text, type);
    }

    private int[] getRangeInternal() {
        if (this.getRequesterText().length() == 0) {
            return null;
        }
        LocationLexer lexer = new LocationLexer(this.getRequesterText());
        LocationLexer.TokenEnumeration tokenEnumeration = lexer.getTokens();
        boolean complement_flag = false;
        if (tokenEnumeration.peekElement() instanceof String && ((String)tokenEnumeration.peekElement()).equals("complement")) {
            complement_flag = true;
            tokenEnumeration.nextElement();
        }
        tokenEnumeration.eatToken('(');
        if (tokenEnumeration.peekElement() instanceof Integer) {
            int first_base = (Integer)tokenEnumeration.nextElement();
            if (tokenEnumeration.peekElement() instanceof Integer || (tokenEnumeration.eatToken("..") || tokenEnumeration.eatToken('.') || tokenEnumeration.eatToken("-")) && tokenEnumeration.peekElement() instanceof Integer) {
                int last_base = (Integer)tokenEnumeration.nextElement();
                tokenEnumeration.eatToken(')');
                if (tokenEnumeration.peekElement() == null) {
                    if (complement_flag) {
                        int temp = first_base;
                        first_base = last_base;
                        last_base = temp;
                    }
                    return new int[]{first_base, last_base};
                }
                new MessageDialog((JFrame)this.getSource(), "garbage at the end of the range: " + tokenEnumeration);
                return null;
            }
        }
        new MessageDialog((JFrame)this.getSource(), "error in range: the range should have this form: 100..200 - error at: " + tokenEnumeration);
        return null;
    }

    public MarkerRange getMarkerRange(Bases bases) {
        try {
            MarkerRange marker_range;
            int[] return_values = this.getRangeInternal();
            if (return_values == null) {
                return null;
            }
            int first_base = return_values[0];
            int last_base = return_values[1];
            if (first_base <= last_base) {
                Strand strand = bases.getForwardStrand();
                marker_range = strand.makeMarkerRangeFromPositions(first_base, last_base);
            } else {
                Strand strand = bases.getReverseStrand();
                int raw_first = bases.getComplementPosition(first_base);
                int raw_last = bases.getComplementPosition(last_base);
                marker_range = strand.makeMarkerRangeFromPositions(raw_last, raw_first);
            }
            return marker_range;
        }
        catch (OutOfRangeException e) {
            new MessageDialog((JFrame)this.getSource(), "the bases are out of range for this sequence");
            return null;
        }
    }

    public Range getRawRange() {
        int[] return_values = this.getRangeInternal();
        if (return_values == null) {
            return null;
        }
        int first_base = return_values[0];
        int last_base = return_values[1];
        try {
            if (first_base < last_base) {
                return new Range(first_base, last_base);
            }
            return new Range(last_base, first_base);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }
}

