/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import uk.ac.sanger.artemis.Logger;
import uk.ac.sanger.artemis.components.MessageFrame;
import uk.ac.sanger.artemis.components.ProcessWatcherEvent;
import uk.ac.sanger.artemis.components.ProcessWatcherListener;
import uk.ac.sanger.artemis.components.Splash;

public class ProcessWatcher
implements Runnable {
    private Process process;
    private String name;
    private boolean alert_user;
    private final Vector listeners = new Vector();

    public ProcessWatcher(Process process, String name) {
        this(process, name, true);
    }

    public ProcessWatcher(Process process, String name, boolean alert_user) {
        this.process = process;
        this.name = name;
        this.alert_user = alert_user;
    }

    public void run() {
        MessageFrame message_frame;
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(this.process.getErrorStream());
            ProcessWatcher.getLogger().log(reader);
        }
        catch (IOException e) {
            message_frame = new MessageFrame("error while reading output of: " + this.name);
            ((Component)message_frame).setVisible(true);
        }
        try {
            reader = new InputStreamReader(this.process.getInputStream());
            ProcessWatcher.getLogger().log(reader);
        }
        catch (IOException e) {
            message_frame = new MessageFrame("error while reading output of: " + this.name);
            ((Component)message_frame).setVisible(true);
        }
        while (true) {
            try {
                String log_message;
                int return_value = this.process.waitFor();
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ProcessWatcherEvent event = new ProcessWatcherEvent(this.process, return_value);
                    ProcessWatcherListener listener = (ProcessWatcherListener)this.listeners.elementAt(i);
                    listener.processFinished(event);
                }
                boolean core_dumped = (return_value & 0x80) != 0;
                ProcessWatcher.getLogger().log("\n-----------------------------------------------------------\n\n");
                if (core_dumped) {
                    log_message = this.name + " process dumped core";
                    ((Component)new MessageFrame(log_message + " - check the log window")).setVisible(true);
                } else {
                    int sig_number = return_value & 0x7F;
                    if (sig_number > 0) {
                        log_message = this.name + " process received signal: " + sig_number;
                        ((Component)new MessageFrame(log_message + " - check the log window")).setVisible(true);
                    } else {
                        int exit_code = return_value >> 8;
                        if (exit_code == 0) {
                            log_message = this.name + " process completed";
                            if (this.alert_user) {
                                MessageFrame message_frame2 = new MessageFrame(log_message);
                                ((Component)message_frame2).setVisible(true);
                            }
                        } else {
                            log_message = this.name + " process finished with exit code: " + exit_code;
                            ((Component)new MessageFrame(log_message + " - check the log window")).setVisible(true);
                        }
                    }
                }
                ProcessWatcher.getLogger().log(log_message + "\n");
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static Logger getLogger() {
        return Splash.getLogger();
    }

    public void addProcessWatcherListener(ProcessWatcherListener l) {
        this.listeners.addElement(l);
    }

    public void removeProcessWatcherListener(ProcessWatcherListener l) {
        this.listeners.removeElement(l);
    }
}

