/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleDocumentEntry;
import uk.ac.sanger.artemis.io.SimpleDocumentFeature;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.Document;

public class BlastDocumentEntry
extends SimpleDocumentEntry
implements DocumentEntry {
    public BlastDocumentEntry(Document document, ReadListener listener) throws IOException, EntryInformationException {
        super((EntryInformation)new BlastEntryInformation(), document, listener);
    }

    public BlastDocumentEntry(Entry new_entry, boolean force) throws EntryInformationException {
        super((EntryInformation)new BlastEntryInformation(), new_entry, force);
    }

    public BlastDocumentEntry(EntryInformation entry_information) {
        super(new BlastEntryInformation());
    }

    public boolean isReadOnly() {
        return true;
    }

    protected SimpleDocumentFeature makeNativeFeature(Feature feature, boolean copy) {
        if (!copy && feature instanceof BlastStreamFeature) {
            return (BlastStreamFeature)feature;
        }
        return new BlastStreamFeature(feature);
    }

    protected StreamSequence makeNativeSequence(Sequence sequence) {
        return new FastaStreamSequence(sequence);
    }
}

