/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.BetweenRange;
import uk.ac.sanger.artemis.io.FuzzyRange;
import uk.ac.sanger.artemis.io.LocationLexer;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.LocationParseNode;
import uk.ac.sanger.artemis.io.LocationParseNodeVector;
import uk.ac.sanger.artemis.io.LowerInteger;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.UpperInteger;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class Location {
    private LocationParseNode parse_tree = null;
    private RangeVector ranges = null;
    private Range total_range = null;

    public Location(String location_string) throws LocationParseException {
        this.parse_tree = this.getParseTree(location_string).getCanonical();
        if (this.parse_tree == null) {
            throw new LocationParseException("invalid location", location_string);
        }
    }

    public Location(Range location_range) throws OutOfRangeException {
        if (location_range.getStart() < 1) {
            throw new OutOfRangeException("location out of range: " + location_range.toString());
        }
        this.parse_tree = new LocationParseNode(location_range);
        this.ranges = new RangeVector(location_range);
    }

    public Location(RangeVector ranges, boolean complement) {
        LocationParseNodeVector vector = new LocationParseNodeVector();
        if (ranges.size() == 0) {
            throw new Error("internal error - ranges.size () == 0");
        }
        for (int i = 0; i < ranges.size(); ++i) {
            LocationParseNode range_node = new LocationParseNode(ranges.elementAt(i));
            if (complement) {
                LocationParseNode complement_node = new LocationParseNode(1, range_node);
                vector.addElement(complement_node);
                continue;
            }
            vector.addElement(range_node);
        }
        this.parse_tree = vector.size() == 1 ? vector.elementAt(0) : new LocationParseNode(2, vector);
    }

    public Location truncate(Range constraint) {
        boolean is_complement = this.isComplement();
        RangeVector ranges = this.getRanges();
        RangeVector new_ranges = new RangeVector();
        for (int i = 0; i < ranges.size(); ++i) {
            Range truncated_range = ranges.elementAt(i).truncate(constraint);
            if (truncated_range == null) continue;
            new_ranges.add(truncated_range);
        }
        if (new_ranges.size() > 0) {
            return new Location(new_ranges, is_complement);
        }
        return null;
    }

    public String toString() {
        return this.getParsedLocation().toString();
    }

    public boolean equals(Location other_location) {
        return this.toString().equals(other_location.toString());
    }

    public String toStringShort() {
        LocationParseNode top = this.getParsedLocation();
        if (top.getType() == 2 && top.getJoinChildren().elementAt(0).getType() == 1 || top.getType() == 3 && top.getOrderChildren().elementAt(0).getType() == 1) {
            LocationParseNodeVector children;
            StringBuffer return_buffer;
            if (top.getType() == 2) {
                return_buffer = new StringBuffer("complement(join(");
                children = top.getJoinChildren();
            } else {
                return_buffer = new StringBuffer("complement(order(");
                children = top.getOrderChildren();
            }
            for (int i = children.size() - 1; i >= 0; --i) {
                LocationParseNode child_node = children.elementAt(i);
                if (child_node.getType() == 1) {
                    LocationParseNode complement_child = child_node.getComplementChild();
                    return_buffer.append(complement_child.toString());
                } else {
                    return_buffer.append(child_node.toString());
                }
                if (i == 0) continue;
                return_buffer.append(',');
            }
            return_buffer.append("))");
            return return_buffer.toString();
        }
        return this.toString();
    }

    public boolean isComplement() {
        if (this.getParsedLocation().getType() == 1) {
            return true;
        }
        if (this.getParsedLocation().getType() == 2 || this.getParsedLocation().getType() == 3) {
            return this.getParsedLocation().getChildren().elementAt(0).getType() == 1;
        }
        return false;
    }

    public Location copy() {
        return new Location(this.getParsedLocation().copyClean());
    }

    public Location changeRange(Range old_range, Range new_range) {
        Location new_location = new Location(this.getParsedLocation().copy());
        new_location.getParsedLocation().changeRange(old_range, new_range);
        return new_location;
    }

    public Location addRange(Range new_range) {
        Location new_location = new Location(this.getParsedLocation().copy());
        LocationParseNode new_node = new LocationParseNode(new_range);
        new_location.parse_tree = new_location.getParsedLocation().addRangeNode(new_node);
        return new_location;
    }

    public Location removeRange(Range remove_range) {
        Location new_location = new Location(this.getParsedLocation().copy());
        new_location.parse_tree = new_location.getParsedLocation().removeRange(remove_range);
        return new_location;
    }

    public Location reverseComplement(int sequence_length) {
        Location new_location = new Location(this.getParsedLocation().copy());
        new_location.parse_tree = new_location.getParsedLocation().reverseComplement(sequence_length);
        new_location.parse_tree = new_location.parse_tree.getCanonical();
        return new_location;
    }

    public Range getTotalRange() {
        try {
            if (this.total_range == null) {
                RangeVector ranges = this.getRanges();
                int lowest_so_far = -1;
                int highest_so_far = -1;
                for (int i = 0; i < ranges.size(); ++i) {
                    int this_start = ranges.elementAt(i).getStart();
                    int this_end = ranges.elementAt(i).getEnd();
                    if (lowest_so_far == -1 || this_start < lowest_so_far) {
                        lowest_so_far = this_start;
                    }
                    if (this_end <= highest_so_far) continue;
                    highest_so_far = this_end;
                }
                this.total_range = new Range(lowest_so_far, highest_so_far);
            }
            return this.total_range;
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public RangeVector getRanges() {
        LocationParseNodeVector range_nodes;
        if (this.ranges != null) {
            return this.ranges;
        }
        this.ranges = new RangeVector();
        LocationParseNode parsed_location = this.getParsedLocation();
        if (parsed_location.getType() == 2) {
            range_nodes = parsed_location.getJoinChildren();
        } else if (parsed_location.getType() == 3) {
            range_nodes = parsed_location.getOrderChildren();
        } else {
            range_nodes = new LocationParseNodeVector();
            range_nodes.addElement(parsed_location);
        }
        for (int i = 0; i < range_nodes.size(); ++i) {
            Range current_node_range;
            LocationParseNode current_node = range_nodes.elementAt(i);
            if (current_node.getType() == 1) {
                LocationParseNode child = current_node.getComplementChild();
                if (child.getType() != 4) continue;
                current_node_range = child.getRange();
            } else {
                if (current_node.getType() != 4) continue;
                current_node_range = current_node.getRange();
            }
            this.ranges.add(current_node_range);
        }
        return this.ranges;
    }

    public int getFirstBase() {
        return this.getTotalRange().getStart();
    }

    public int getLastBase() {
        return this.getTotalRange().getEnd();
    }

    public Location getComplement() {
        return new Location(this.getParsedLocation().getNodeComplement());
    }

    public LocationParseNode getParsedLocation() {
        return this.parse_tree;
    }

    private Location(LocationParseNode parse_tree) {
        this.parse_tree = parse_tree;
    }

    private LocationParseNode getParseTree(String location_string) throws LocationParseException {
        LocationLexer lexer = new LocationLexer(location_string);
        LocationLexer.TokenEnumeration tokenEnumeration = lexer.getTokens();
        LocationParseNode join = Location.parseJoinContents(tokenEnumeration);
        if (tokenEnumeration.peekElement() != null) {
            throw new LocationParseException("garbage at the end of the location string", tokenEnumeration);
        }
        return join;
    }

    private static LocationParseNode parseLocation(LocationLexer.TokenEnumeration tokenEnumeration) throws LocationParseException {
        LocationParseNode parsed_functional = Location.parseFunctional(tokenEnumeration);
        if (parsed_functional != null) {
            return parsed_functional;
        }
        LocationParseNode entry_range = Location.parseEntryRange(tokenEnumeration);
        if (entry_range != null) {
            return entry_range;
        }
        LocationParseNode parsed_range = Location.parseRange(tokenEnumeration);
        if (parsed_range != null) {
            return parsed_range;
        }
        throw new LocationParseException("expected a range or a functional", tokenEnumeration);
    }

    private static LocationParseNode parseEntryRange(LocationLexer.TokenEnumeration tokenEnumeration) throws LocationParseException {
        if (!(tokenEnumeration.peekElement() instanceof String)) {
            return null;
        }
        String entry_string = (String)tokenEnumeration.nextElement();
        if (!tokenEnumeration.eatToken(':')) {
            throw new LocationParseException("parse error after reading \"" + entry_string + "\"", tokenEnumeration);
        }
        LocationParseNode entry_location = Location.parseLocation(tokenEnumeration);
        return new LocationParseNode(entry_string, entry_location);
    }

    private static LocationParseNode parseJoinContents(LocationLexer.TokenEnumeration tokenEnumeration) throws LocationParseException {
        LocationParseNodeVector return_ranges = new LocationParseNodeVector();
        LocationParseNode parsed_range = Location.parseLocation(tokenEnumeration);
        if (parsed_range == null) {
            return null;
        }
        return_ranges.addElement(parsed_range);
        Object peek_element = tokenEnumeration.peekElement();
        while (tokenEnumeration.eatToken(',')) {
            LocationParseNode new_child = Location.parseLocation(tokenEnumeration);
            return_ranges.addElement(new_child);
        }
        if (return_ranges.size() > 1) {
            return new LocationParseNode(2, return_ranges);
        }
        return return_ranges.elementAt(0);
    }

    private static LocationParseNode parseRange(LocationLexer.TokenEnumeration tokenEnumeration) throws LocationParseException {
        boolean is_lower_unbounded_range = false;
        boolean is_upper_unbounded_range = false;
        Object start_object = Location.parseRangeBound(tokenEnumeration);
        if (start_object == null) {
            return null;
        }
        Object middle_token = tokenEnumeration.peekElement();
        if (!tokenEnumeration.eatToken("..") && !tokenEnumeration.eatToken('^')) {
            return new LocationParseNode(FuzzyRange.makeRange(start_object));
        }
        if (tokenEnumeration.peekElement() == null) {
            throw new LocationParseException("location ends in the middle of a range", tokenEnumeration);
        }
        if (start_object instanceof UpperInteger) {
            throw new LocationParseException("range cannot start with: " + start_object, tokenEnumeration);
        }
        Object end_object = Location.parseRangeBound(tokenEnumeration);
        if (end_object == null) {
            throw new LocationParseException("unexpected characters in location", tokenEnumeration);
        }
        if (end_object instanceof LowerInteger) {
            throw new LocationParseException("a range cannot end with: " + end_object, tokenEnumeration);
        }
        if (middle_token instanceof Character && ((Character)middle_token).charValue() == '^') {
            if (start_object instanceof Integer && end_object instanceof Integer) {
                try {
                    BetweenRange new_range = new BetweenRange((Integer)start_object, (Integer)end_object);
                    return new LocationParseNode(new_range);
                }
                catch (OutOfRangeException e) {
                    throw new LocationParseException("a range must start before it ends", tokenEnumeration);
                }
            }
            throw new LocationParseException("a range that contains a '^' must start and end with a plain number", tokenEnumeration);
        }
        try {
            return new LocationParseNode(FuzzyRange.makeRange(start_object, end_object));
        }
        catch (OutOfRangeException e) {
            throw new LocationParseException("a range must start before it ends", tokenEnumeration);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object parseRangeBound(LocationLexer.TokenEnumeration tokenEnumeration) throws LocationParseException {
        Object peek_element = tokenEnumeration.peekElement();
        if (peek_element instanceof Integer) {
            if ((Integer)peek_element < 1) {
                throw new LocationParseException("range bounds must be greater than 0", tokenEnumeration);
            }
            return tokenEnumeration.nextElement();
        }
        if (peek_element instanceof LowerInteger) {
            if (((LowerInteger)peek_element).getPosition() < 1) {
                throw new LocationParseException("range bounds must be greater than 0", tokenEnumeration);
            }
            return tokenEnumeration.nextElement();
        }
        if (peek_element instanceof UpperInteger) {
            if (((UpperInteger)peek_element).getPosition() < 1) {
                throw new LocationParseException("range bounds must be greater than 0", tokenEnumeration);
            }
            return tokenEnumeration.nextElement();
        }
        if (tokenEnumeration.eatToken('(')) {
            if (tokenEnumeration.peekElement() instanceof Integer) {
                Integer start = (Integer)tokenEnumeration.nextElement();
                if (tokenEnumeration.eatToken('.')) {
                    if (tokenEnumeration.peekElement() instanceof Integer) {
                        Object return_object;
                        int end_value;
                        Integer end = (Integer)tokenEnumeration.nextElement();
                        int start_value = start;
                        if (start_value > (end_value = end.intValue())) {
                            int tmp = start_value;
                            start_value = end_value;
                            end_value = tmp;
                        }
                        if (start_value < 1) {
                            throw new LocationParseException("range bounds must be greater than 0", tokenEnumeration);
                        }
                        if (start_value == end_value) {
                            return_object = new Integer(start_value);
                        } else {
                            try {
                                return_object = new Range(start_value, end_value);
                            }
                            catch (OutOfRangeException e) {
                                throw new Error("internal error - unexpected exception: " + e);
                            }
                        }
                        if (tokenEnumeration.eatToken(')')) {
                            void var6_7;
                            return var6_7;
                        }
                        String message = "expected a closing parenthesis after reading: (" + start + "." + end;
                        throw new LocationParseException(message, tokenEnumeration);
                    }
                    throw new LocationParseException("expected an integer", tokenEnumeration);
                }
                throw new LocationParseException("expected a '.'", tokenEnumeration);
            }
            throw new LocationParseException("expected an integer", tokenEnumeration);
        }
        return null;
    }

    private static LocationParseNode parseFunctional(LocationLexer.TokenEnumeration tokenEnumeration) throws LocationParseException {
        Object peeked_element = tokenEnumeration.peekElement();
        if (peeked_element instanceof String && ("complement".equals((String)peeked_element) || "join".equals((String)peeked_element) || "order".equals((String)peeked_element))) {
            String functional_name = (String)tokenEnumeration.nextElement();
            if (!tokenEnumeration.eatToken('(')) {
                throw new LocationParseException("expected (", tokenEnumeration);
            }
            if ("complement".equals(functional_name)) {
                LocationParseNode child = Location.parseJoinContents(tokenEnumeration);
                if (!tokenEnumeration.eatToken(')')) {
                    // empty if block
                }
                return new LocationParseNode(1, child);
            }
            LocationParseNode join = Location.parseJoinContents(tokenEnumeration);
            if (!tokenEnumeration.eatToken(')')) {
                // empty if block
            }
            if (join.getType() == 2) {
                if ("join".equals(functional_name)) {
                    return new LocationParseNode(2, join.getChildren());
                }
                return new LocationParseNode(3, join.getChildren());
            }
            return join;
        }
        return null;
    }
}

