/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureEnumeration;
import uk.ac.sanger.artemis.io.FeatureHeader;
import uk.ac.sanger.artemis.io.FeatureTable;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.InvalidKeyException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.LineGroupVector;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MiscLineGroup;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.PublicDBStreamFeature;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.ReadEvent;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleDocumentFeature;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamFeatureTable;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public abstract class SimpleDocumentEntry
implements DocumentEntry {
    private FeatureVector fake_fasta_features = new FeatureVector();
    private final EntryInformation entry_information;
    private Vector listeners = new Vector();
    private Document document = null;
    protected LineGroupVector line_groups = new LineGroupVector();
    private Thread autosave_thread = null;
    private Date last_change_time = null;
    private boolean in_constructor = false;

    public SimpleDocumentEntry(EntryInformation entry_information, Document document, ReadListener read_listener) throws IOException, EntryInformationException {
        FastaStreamSequence fasta_sequence;
        String[] header_strings;
        LineGroup new_line_group;
        this.document = document;
        this.entry_information = new SimpleEntryInformation(entry_information);
        this.in_constructor = true;
        this.addReadListener(read_listener);
        LinePushBackReader pushback_reader = this.getDocument().getLinePushBackReader();
        while ((new_line_group = LineGroup.readNextLineGroup(pushback_reader)) != null) {
            if (new_line_group instanceof SimpleDocumentFeature) {
                int i;
                SimpleDocumentFeature new_feature = (SimpleDocumentFeature)new_line_group;
                int MAX_LOOP = 9999;
                EntryInformationException saved_error = null;
                for (i = 0; i < 9999; ++i) {
                    try {
                        this.addInternal(new_feature, true);
                        break;
                    }
                    catch (EntryInformationException e) {
                        this.getEntryInformation().fixException(e);
                        saved_error = e;
                        continue;
                    }
                }
                if (i != 9999) continue;
                throw new Error("internal error - too many exceptions: " + saved_error.getMessage());
            }
            this.addLineGroup(new_line_group);
        }
        this.last_change_time = null;
        Sequence sequence = this.getSequence();
        if (sequence != null && sequence instanceof FastaStreamSequence && (header_strings = (fasta_sequence = (FastaStreamSequence)sequence).getFastaHeaderStrings()).length > 1) {
            int[] header_positions = fasta_sequence.getFastaHeaderPositions();
            FeatureTable feature_table = this.getFeatureTable();
            for (int i = 0; i < header_strings.length; ++i) {
                try {
                    Range new_range;
                    if (i == header_strings.length - 1) {
                        if (header_positions[i] == fasta_sequence.length()) {
                            throw new ReadFormatException("empty FASTA record: >" + header_strings[i]);
                        }
                        new_range = new Range(header_positions[i] + 1, fasta_sequence.length());
                    } else {
                        if (header_positions[i] == header_positions[i + 1]) {
                            throw new ReadFormatException("empty FASTA record: >" + header_strings[i]);
                        }
                        new_range = new Range(header_positions[i] + 1, header_positions[i + 1]);
                    }
                    QualifierVector qualifiers = new QualifierVector();
                    qualifiers.setQualifier(new Qualifier("note", header_strings[i]));
                    qualifiers.setQualifier(new Qualifier("label", header_strings[i]));
                    if (i % 2 == 0) {
                        qualifiers.setQualifier(new Qualifier("colour", "10"));
                    } else {
                        qualifiers.setQualifier(new Qualifier("colour", "11"));
                    }
                    ReadOnlyEmblStreamFeature new_feature = new ReadOnlyEmblStreamFeature(new Key("fasta_record"), new Location(new_range), qualifiers);
                    this.fake_fasta_features.add(new_feature);
                    continue;
                }
                catch (InvalidRelationException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
            this.addFakeFeatures();
        }
        this.in_constructor = false;
    }

    public SimpleDocumentEntry(EntryInformation entry_information) {
        this.entry_information = new SimpleEntryInformation(entry_information);
    }

    public SimpleDocumentEntry(EntryInformation entry_information, Entry new_entry, boolean force) throws EntryInformationException {
        this.entry_information = new SimpleEntryInformation(entry_information);
        if (new_entry.getClass().equals(this.getClass())) {
            try {
                this.setHeaderText(new_entry.getHeaderText());
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        FeatureEnumeration feature_enum = new_entry.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature new_feature = feature_enum.nextFeature();
            try {
                if (force) {
                    this.forcedAdd(this.makeNativeFeature(new_feature, true));
                    continue;
                }
                this.add(this.makeNativeFeature(new_feature, true));
            }
            catch (ReadOnlyException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        Sequence new_sequence = new_entry.getSequence();
        if (new_sequence != null) {
            this.setSequence(this.makeNativeSequence(new_sequence));
        }
    }

    public String getHeaderText() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.line_groups.size(); ++i) {
            LineGroup current_line_group = this.line_groups.elementAt(i);
            if (current_line_group instanceof FeatureTable || current_line_group instanceof Sequence) continue;
            buffer.append(current_line_group.toString());
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    public boolean setHeaderText(String new_header) throws IOException {
        int i;
        LineGroupVector new_line_groups = new LineGroupVector();
        if (new_header != null) {
            StringReader reader = new StringReader(new_header);
            LinePushBackReader pushback_reader = new LinePushBackReader(reader);
            try {
                LineGroup new_line_group;
                while ((new_line_group = LineGroup.readNextLineGroup(pushback_reader)) != null) {
                    if (new_line_group instanceof MiscLineGroup) {
                        new_line_groups.addElement(new_line_group);
                        continue;
                    }
                    throw new ReadFormatException("the header must contain only header lines");
                }
            }
            catch (InvalidRelationException e) {
                throw new ReadFormatException("the header must contain only header lines");
            }
        }
        for (i = this.line_groups.size() - 1; i >= 0; --i) {
            LineGroup current_line_group = this.line_groups.elementAt(i);
            if (!(current_line_group instanceof MiscLineGroup)) continue;
            this.line_groups.removeElementAt(i);
        }
        if (new_header != null) {
            for (i = 0; i < new_line_groups.size(); ++i) {
                this.line_groups.insertElementAt(new_line_groups.elementAt(i), i);
            }
        }
        this.setDirtyFlag();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(Writer writer) throws IOException {
        this.removeFakeFeatures();
        try {
            LineGroup second_line_group;
            for (int i = 0; i < this.line_groups.size(); ++i) {
                LineGroup current_line_group = this.line_groups.elementAt(i);
                current_line_group.writeToStream(writer);
            }
            if (this.line_groups.size() == 1) {
                return;
            }
            if (this.line_groups.size() == 2 && ((second_line_group = this.line_groups.elementAt(1)) instanceof RawStreamSequence || second_line_group instanceof FastaStreamSequence)) {
                return;
            }
            if (this instanceof PublicDBDocumentEntry) {
                LineGroup.writeEndOfEMBLEntry(writer);
            }
        }
        finally {
            this.addFakeFeatures();
        }
    }

    public int getFeatureCount() {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return 0;
        }
        return feature_table.getFeatureCount();
    }

    private Feature addInternal(Feature feature, boolean throw_entry_info_exceptions) throws EntryInformationException {
        if (feature.getEntry() != null) {
            throw new Error("internal error - a feature must have one owner");
        }
        EntryInformation entry_information = this.getEntryInformation();
        if (!entry_information.isValidKey(feature.getKey())) {
            String message = feature.getKey() + " is not a valid key";
            this.fireEvent(new ReadEvent(this, message));
            throw new InvalidKeyException(feature.getKey() + " is not a valid " + "key for this entry", feature.getKey());
        }
        QualifierVector new_qualifiers = feature.getQualifiers();
        Key new_key = feature.getKey();
        for (int i = 0; i < new_qualifiers.size(); ++i) {
            Qualifier this_qualifier = new_qualifiers.elementAt(i);
            String this_qualifier_name = this_qualifier.getName();
            if (entry_information.isValidQualifier(new_key, this_qualifier_name)) continue;
            String message = new_key + " can't have " + this_qualifier_name + " as a qualifier";
            this.fireEvent(new ReadEvent(this, message));
            if (!throw_entry_info_exceptions) continue;
            throw new InvalidRelationException(message, new_key, this_qualifier);
        }
        SimpleDocumentFeature native_feature = this.makeNativeFeature(feature, false);
        FeatureTable feature_table = this.getFeatureTable();
        feature_table.add(native_feature);
        try {
            native_feature.setDocumentEntry(this);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        this.setDirtyFlag();
        return native_feature;
    }

    public Feature add(Feature feature) throws EntryInformationException, ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        return this.addInternal(feature, true);
    }

    public Feature forcedAdd(Feature feature) throws ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        if (feature.getEntry() != null) {
            throw new Error("internal error - a feature must have one owner");
        }
        EntryInformation entry_information = this.getEntryInformation();
        if (!entry_information.isValidKey(feature.getKey())) {
            return null;
        }
        QualifierVector feature_qualifiers = feature.getQualifiers();
        QualifierVector fixed_qualifiers = new QualifierVector();
        Key new_key = feature.getKey();
        boolean qualifiers_fixed = false;
        for (int i = 0; i < feature_qualifiers.size(); ++i) {
            Qualifier this_qualifier = feature_qualifiers.elementAt(i);
            String this_qualifier_name = this_qualifier.getName();
            if (entry_information.isValidQualifier(new_key, this_qualifier_name)) {
                fixed_qualifiers.setQualifier(this_qualifier);
                continue;
            }
            qualifiers_fixed = true;
        }
        SimpleDocumentFeature native_feature = this.makeNativeFeature(feature, false);
        if (qualifiers_fixed) {
            try {
                native_feature.setQualifiers(fixed_qualifiers);
            }
            catch (EntryInformationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        FeatureTable feature_table = this.getFeatureTable();
        feature_table.add(native_feature);
        native_feature.setDocumentEntry(this);
        this.setDirtyFlag();
        return native_feature;
    }

    protected boolean removeInternal(Feature feature) {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return false;
        }
        SimpleDocumentFeature feature_from_table = (SimpleDocumentFeature)feature_table.remove(feature);
        if (feature_from_table == null) {
            return false;
        }
        try {
            feature_from_table.setDocumentEntry(null);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        if (feature_table.getFeatureCount() == 0) {
            this.removeLineGroup(feature_table);
        }
        this.setDirtyFlag();
        return true;
    }

    public boolean remove(Feature feature) throws ReadOnlyException {
        if (this.isReadOnly() || feature.isReadOnly()) {
            throw new ReadOnlyException();
        }
        return this.removeInternal(feature);
    }

    public Feature getFeatureAtIndex(int i) {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return null;
        }
        return feature_table.getFeatureAtIndex(i);
    }

    public int indexOf(Feature feature) {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return -1;
        }
        return feature_table.indexOf(feature);
    }

    public boolean contains(Feature feature) {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return false;
        }
        return feature_table.contains(feature);
    }

    public Feature createFeature(Key key, Location location, QualifierVector qualifiers) throws EntryInformationException, ReadOnlyException, OutOfRangeException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        PublicDBStreamFeature new_feature = this instanceof EmblDocumentEntry ? new EmblStreamFeature(key, location, qualifiers) : new GenbankStreamFeature(key, location, qualifiers);
        this.add(new_feature);
        this.setDirtyFlag();
        return new_feature;
    }

    public FeatureVector getFeaturesInRange(Range range) {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return new FeatureVector();
        }
        return feature_table.getFeaturesInRange(range);
    }

    public FeatureVector getAllFeatures() {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return new FeatureVector();
        }
        return feature_table.getAllFeatures();
    }

    public FeatureEnumeration features() {
        FeatureTable feature_table = this.findFeatureTable();
        if (feature_table == null) {
            return new FeatureEnumeration(){

                public boolean hasMoreFeatures() {
                    return false;
                }

                public Feature nextFeature() {
                    return null;
                }
            };
        }
        return feature_table.features();
    }

    public Sequence getSequence() {
        for (int i = 0; i < this.line_groups.size(); ++i) {
            LineGroup current_line_group = this.line_groups.elementAt(i);
            if (!(current_line_group instanceof Sequence)) continue;
            return (Sequence)((Object)current_line_group);
        }
        return null;
    }

    private void addLineGroup(LineGroup new_line_group) {
        if (new_line_group instanceof FeatureHeader) {
            for (int i = 0; i < this.line_groups.size(); ++i) {
                LineGroup this_line_group = this.line_groups.elementAt(i);
                if (!(this_line_group instanceof Feature) && !(this_line_group instanceof FeatureTable) && !(this_line_group instanceof Sequence)) continue;
                this.line_groups.insertElementAt(new_line_group, i);
                return;
            }
        } else if (new_line_group instanceof Feature) {
            for (int i = 0; i < this.line_groups.size(); ++i) {
                LineGroup this_line_group = this.line_groups.elementAt(i);
                if (!(this_line_group instanceof FeatureTable) && !(this_line_group instanceof Sequence)) continue;
                this.line_groups.insertElementAt(new_line_group, i);
                return;
            }
        } else if (!(new_line_group instanceof Sequence) && !(new_line_group instanceof FeatureTable)) {
            for (int i = 0; i < this.line_groups.size(); ++i) {
                LineGroup this_line_group = this.line_groups.elementAt(i);
                if (!(this_line_group instanceof Feature) && !(this_line_group instanceof FeatureTable) && !(this_line_group instanceof FeatureHeader) && !(this_line_group instanceof Sequence)) continue;
                this.line_groups.insertElementAt(new_line_group, i);
                return;
            }
        }
        this.line_groups.addElement(new_line_group);
    }

    public String getName() {
        if (this.getDocument() == null || this.getDocument().getName() == null) {
            return null;
        }
        return this.getDocument().getName();
    }

    public boolean setName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        this.setDocument(new FileDocument(new File(name)));
        return true;
    }

    public EntryInformation getEntryInformation() {
        return this.entry_information;
    }

    private FeatureTable createFeatureTable() {
        StreamFeatureTable new_feature_table = new StreamFeatureTable();
        if (this.line_groups.size() > 0 && this.line_groups.lastElement() instanceof Sequence) {
            this.line_groups.insertElementAt(new_feature_table, this.line_groups.size() - 1);
        } else {
            this.line_groups.insertElementAt(new_feature_table, this.line_groups.size());
        }
        return new_feature_table;
    }

    private FeatureTable findFeatureTable() {
        for (int i = 0; i < this.line_groups.size(); ++i) {
            LineGroup current_line_group = this.line_groups.elementAt(i);
            if (!(current_line_group instanceof FeatureTable)) continue;
            return (FeatureTable)current_line_group;
        }
        return null;
    }

    FeatureTable getFeatureTable() {
        FeatureTable found_feature_table = this.findFeatureTable();
        if (found_feature_table == null) {
            return this.createFeatureTable();
        }
        return found_feature_table;
    }

    private void removeLineGroup(LineGroup line_group) {
        for (int i = 0; i < this.line_groups.size(); ++i) {
            LineGroup current_line_group = this.line_groups.elementAt(i);
            if (current_line_group != line_group) continue;
            this.line_groups.removeElementAt(i);
            this.setDirtyFlag();
            return;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void save() throws IOException {
        this.save(this.getDocument());
    }

    public void save(Document document) throws IOException {
        Writer out_file = document.getWriter();
        this.writeToStream(out_file);
        out_file.close();
        this.last_change_time = null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean hasUnsavedChanges() {
        return this.last_change_time != null;
    }

    public void setDirtyFlag() {
        if (!this.in_constructor) {
            Calendar calendar = Calendar.getInstance();
            this.last_change_time = calendar.getTime();
        }
    }

    public Date getLastChangeTime() {
        return this.last_change_time;
    }

    public void setSequence(StreamSequence sequence) {
        Sequence old_sequence = this.getSequence();
        if (old_sequence != null) {
            this.removeLineGroup((StreamSequence)old_sequence);
        }
        this.addLineGroup(sequence);
    }

    protected abstract SimpleDocumentFeature makeNativeFeature(Feature var1, boolean var2);

    protected abstract StreamSequence makeNativeSequence(Sequence var1);

    private void addFakeFeatures() {
        FeatureTable feature_table = this.getFeatureTable();
        for (int i = 0; i < this.fake_fasta_features.size(); ++i) {
            feature_table.add(this.fake_fasta_features.elementAt(i));
        }
    }

    private void removeFakeFeatures() {
        FeatureTable feature_table = this.getFeatureTable();
        for (int i = 0; i < this.fake_fasta_features.size(); ++i) {
            feature_table.remove(this.fake_fasta_features.elementAt(i));
        }
    }

    private void addReadListener(ReadListener listener) {
        this.listeners.addElement(listener);
    }

    private void fireEvent(ReadEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReadListener)this.listeners.elementAt(i)).notify(event);
        }
    }
}

