/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.lsf;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControl;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.lsf.LSFBatchException;
import uk.ac.sanger.jcon.lsf.LSFJobUpdater;

public class LSFQueueWatcher {
    public static final String BATCH_QUEUE_KEY = "jobcontrol.queue.name";
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$lsf$LSFQueueWatcher == null ? (class$uk$ac$sanger$jcon$lsf$LSFQueueWatcher = LSFQueueWatcher.class$("uk.ac.sanger.jcon.lsf.LSFQueueWatcher")) : class$uk$ac$sanger$jcon$lsf$LSFQueueWatcher).getName());
    private Map queues;
    private LSFJobUpdater jobUpdater;
    private StatusDAO statusDAO;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$lsf$LSFQueueWatcher;

    public LSFQueueWatcher(StatusDAO statusDAO) {
        this.statusDAO = statusDAO;
        this.queues = new HashMap();
        this.jobUpdater = new LSFJobUpdater(statusDAO);
        ResourceBundle bundle = JobControl.getConfiguration();
        try {
            Enumeration<String> e = bundle.getKeys();
            while (e.hasMoreElements()) {
                String val;
                String key = e.nextElement();
                try {
                    val = bundle.getString(key);
                }
                catch (NullPointerException npe) {
                    throw new Error("Malformed configuration ResourceBundle contains key '" + key + "' missing a corresponding value");
                }
                if (!key.equals(BATCH_QUEUE_KEY)) continue;
                StringTokenizer st = new StringTokenizer(val);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    cat.info((Object)("Adding queue '" + token + "' to known queues"));
                    this.queues.put(token, new HashMap());
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Number format error in configuration ResourceBundle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchFor(BatchJob job) throws LSFBatchException {
        Map jobs;
        String queue = job.getQueue();
        cat.debug((Object)("Starting to watch Job [" + job.getId() + "] on queue " + queue));
        if (!this.queues.containsKey(queue)) {
            throw new LSFBatchException("Unknown batch queue '" + queue + "'");
        }
        Map map = jobs = (Map)this.queues.get(queue);
        synchronized (map) {
            if (jobs.containsValue(job)) {
                throw new LSFBatchException("Batch Job [" + job.getId() + "] batch job ID " + job.getBatchId() + " is already being watched");
            }
            jobs.put(new Integer(job.getBatchId()), job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching(BatchJob job) throws LSFBatchException {
        Map jobs;
        String queue = job.getQueue();
        cat.debug((Object)("Stopping watch over Job [" + job.getId() + "] on queue " + queue));
        if (!this.queues.containsKey(queue)) {
            throw new LSFBatchException("Unknown batch queue '" + queue + "'");
        }
        Map map = jobs = (Map)this.queues.get(queue);
        synchronized (map) {
            if (!jobs.containsValue(job)) {
                throw new LSFBatchException("Batch Job [" + job.getId() + "] batch job ID " + job.getBatchId() + " is not being watched");
            }
            jobs.remove(new Integer(job.getBatchId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        try {
            Iterator ki = this.queues.keySet().iterator();
            while (ki.hasNext()) {
                String queue = (String)ki.next();
                Map jobs = (Map)this.queues.get(queue);
                if (jobs == null) continue;
                Map map = jobs;
                synchronized (map) {
                    this.jobUpdater.updateJobs(queue, jobs);
                }
            }
        }
        catch (Exception e) {
            cat.error((Object)"Caught Exception while checking batch queues", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

