/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.ByteInstruction;
import org.biojava.utils.bytecode.ClassInstruction;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.DoubleInstruction;
import org.biojava.utils.bytecode.FieldInstruction;
import org.biojava.utils.bytecode.FloatConstantInstruction;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.InstructionVector;
import org.biojava.utils.bytecode.IntConstantInstruction;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LabelInstruction;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.LocalVariableInstruction;
import org.biojava.utils.bytecode.LongConstantInstruction;
import org.biojava.utils.bytecode.MarkLabel;
import org.biojava.utils.bytecode.MethodInstruction;
import org.biojava.utils.bytecode.NoOperandsInstruction;
import org.biojava.utils.bytecode.PParametricCodeGenerator;
import org.biojava.utils.bytecode.ParametricCodeGenerator;
import org.biojava.utils.bytecode.ParametricType;
import org.biojava.utils.bytecode.ShortInstruction;
import org.biojava.utils.bytecode.StringConstantInstruction;

public class ByteCode {
    public static final byte op_nop = 0;
    public static final byte op_aconst_null = 1;
    public static final byte op_iconst_m1 = 2;
    public static final byte op_iconst_0 = 3;
    public static final byte op_iconst_1 = 4;
    public static final byte op_iconst_2 = 5;
    public static final byte op_iconst_3 = 6;
    public static final byte op_iconst_4 = 7;
    public static final byte op_iconst_5 = 8;
    public static final byte op_lconst_0 = 9;
    public static final byte op_lconst_1 = 10;
    public static final byte op_fconst_0 = 11;
    public static final byte op_fconst_1 = 12;
    public static final byte op_fconst_2 = 13;
    public static final byte op_dconst_0 = 14;
    public static final byte op_dconst_1 = 15;
    public static final byte op_bipush = 16;
    public static final byte op_sipush = 17;
    public static final byte op_ldc = 18;
    public static final byte op_ldc_w = 19;
    public static final byte op_ldc2_w = 20;
    public static final byte op_iload = 21;
    public static final byte op_lload = 22;
    public static final byte op_fload = 23;
    public static final byte op_dload = 24;
    public static final byte op_aload = 25;
    public static final byte op_iload_0 = 26;
    public static final byte op_iload_1 = 27;
    public static final byte op_iload_2 = 28;
    public static final byte op_iload_3 = 29;
    public static final byte op_lload_0 = 30;
    public static final byte op_lload_1 = 31;
    public static final byte op_lload_2 = 32;
    public static final byte op_lload_3 = 33;
    public static final byte op_fload_0 = 34;
    public static final byte op_fload_1 = 35;
    public static final byte op_fload_2 = 36;
    public static final byte op_fload_3 = 37;
    public static final byte op_dload_0 = 38;
    public static final byte op_dload_1 = 39;
    public static final byte op_dload_2 = 40;
    public static final byte op_dload_3 = 41;
    public static final byte op_aload_0 = 42;
    public static final byte op_aload_1 = 43;
    public static final byte op_aload_2 = 44;
    public static final byte op_aload_3 = 45;
    public static final byte op_iaload = 46;
    public static final byte op_laload = 47;
    public static final byte op_faload = 48;
    public static final byte op_daload = 49;
    public static final byte op_aaload = 50;
    public static final byte op_baload = 51;
    public static final byte op_caload = 52;
    public static final byte op_saload = 53;
    public static final byte op_istore = 54;
    public static final byte op_lstore = 55;
    public static final byte op_fstore = 56;
    public static final byte op_dstore = 57;
    public static final byte op_astore = 58;
    public static final byte op_istore_0 = 59;
    public static final byte op_istore_1 = 60;
    public static final byte op_istore_2 = 61;
    public static final byte op_istore_3 = 62;
    public static final byte op_lstore_0 = 63;
    public static final byte op_lstore_1 = 64;
    public static final byte op_lstore_2 = 65;
    public static final byte op_lstore_3 = 66;
    public static final byte op_fstore_0 = 67;
    public static final byte op_fstore_1 = 68;
    public static final byte op_fstore_2 = 69;
    public static final byte op_fstore_3 = 70;
    public static final byte op_dstore_0 = 71;
    public static final byte op_dstore_1 = 72;
    public static final byte op_dstore_2 = 73;
    public static final byte op_dstore_3 = 74;
    public static final byte op_astore_0 = 75;
    public static final byte op_astore_1 = 76;
    public static final byte op_astore_2 = 77;
    public static final byte op_astore_3 = 78;
    public static final byte op_iastore = 79;
    public static final byte op_lastore = 80;
    public static final byte op_fastore = 81;
    public static final byte op_dastore = 82;
    public static final byte op_aastore = 83;
    public static final byte op_bastore = 84;
    public static final byte op_castore = 85;
    public static final byte op_sastore = 86;
    public static final byte op_pop = 87;
    public static final byte op_pop2 = 88;
    public static final byte op_dup = 89;
    public static final byte op_dup_x1 = 90;
    public static final byte op_dup_x2 = 91;
    public static final byte op_dup2 = 92;
    public static final byte op_dup2_x1 = 93;
    public static final byte op_dup2_x2 = 94;
    public static final byte op_swap = 95;
    public static final byte op_iadd = 96;
    public static final byte op_ladd = 97;
    public static final byte op_fadd = 98;
    public static final byte op_dadd = 99;
    public static final byte op_isub = 100;
    public static final byte op_lsub = 101;
    public static final byte op_fsub = 102;
    public static final byte op_dsub = 103;
    public static final byte op_imul = 104;
    public static final byte op_lmul = 105;
    public static final byte op_fmul = 106;
    public static final byte op_dmul = 107;
    public static final byte op_idiv = 108;
    public static final byte op_ldiv = 109;
    public static final byte op_fdiv = 110;
    public static final byte op_ddiv = 111;
    public static final byte op_irem = 112;
    public static final byte op_lrem = 113;
    public static final byte op_frem = 114;
    public static final byte op_drem = 115;
    public static final byte op_ineg = 116;
    public static final byte op_lneg = 117;
    public static final byte op_fneg = 118;
    public static final byte op_dneg = 119;
    public static final byte op_ishl = 120;
    public static final byte op_lshl = 121;
    public static final byte op_ishr = 122;
    public static final byte op_lshr = 123;
    public static final byte op_iushr = 124;
    public static final byte op_lushr = 125;
    public static final byte op_iand = 126;
    public static final byte op_land = 127;
    public static final byte op_ior = -128;
    public static final byte op_lor = -127;
    public static final byte op_ixor = -126;
    public static final byte op_lxor = -125;
    public static final byte op_iinc = -124;
    public static final byte op_i2l = -123;
    public static final byte op_i2f = -122;
    public static final byte op_i2d = -121;
    public static final byte op_l2i = -120;
    public static final byte op_l2f = -119;
    public static final byte op_l2d = -118;
    public static final byte op_f2i = -117;
    public static final byte op_f2l = -116;
    public static final byte op_f2d = -115;
    public static final byte op_d2i = -114;
    public static final byte op_d2l = -113;
    public static final byte op_d2f = -112;
    public static final byte op_i2b = -111;
    public static final byte op_i2c = -110;
    public static final byte op_i2s = -109;
    public static final byte op_lcmp = -108;
    public static final byte op_fcmpl = -107;
    public static final byte op_fcmpg = -106;
    public static final byte op_dcmpl = -105;
    public static final byte op_dcmpg = -104;
    public static final byte op_ifeq = -103;
    public static final byte op_ifne = -102;
    public static final byte op_iflt = -101;
    public static final byte op_ifge = -100;
    public static final byte op_ifgt = -99;
    public static final byte op_ifle = -98;
    public static final byte op_if_icmpeq = -97;
    public static final byte op_if_icmpne = -96;
    public static final byte op_if_icmplt = -95;
    public static final byte op_if_icmpge = -94;
    public static final byte op_if_icmpgt = -93;
    public static final byte op_if_icmple = -92;
    public static final byte op_if_acmpeq = -91;
    public static final byte op_if_acmpne = -90;
    public static final byte op_goto = -89;
    public static final byte op_jsr = -88;
    public static final byte op_ret = -87;
    public static final byte op_tableswitch = -86;
    public static final byte op_lookupswitch = -85;
    public static final byte op_ireturn = -84;
    public static final byte op_lreturn = -83;
    public static final byte op_freturn = -82;
    public static final byte op_dreturn = -81;
    public static final byte op_areturn = -80;
    public static final byte op_return = -79;
    public static final byte op_getstatic = -78;
    public static final byte op_putstatic = -77;
    public static final byte op_getfield = -76;
    public static final byte op_putfield = -75;
    public static final byte op_invokevirtual = -74;
    public static final byte op_invokespecial = -73;
    public static final byte op_invokestatic = -72;
    public static final byte op_invokeinterface = -71;
    public static final byte op_new = -69;
    public static final byte op_newarray = -68;
    public static final byte op_anewarray = -67;
    public static final byte op_arraylength = -66;
    public static final byte op_athrow = -65;
    public static final byte op_checkcast = -64;
    public static final byte op_instanceof = -63;
    public static final byte op_monitorenter = -62;
    public static final byte op_monitorexit = -61;
    public static final byte op_wide = -60;
    public static final byte op_multianewarray = -59;
    public static final byte op_ifnull = -58;
    public static final byte op_ifnonnull = -57;
    public static final byte op_goto_w = -56;
    public static final byte op_jsr_w = -55;
    public static final byte op_breakpoint = -54;
    public static final byte op_ldc_quick = -53;
    public static final byte op_ldc_w_quick = -52;
    public static final byte op_ldc2_w_quick = -51;
    public static final byte op_getfield_quick = -50;
    public static final byte op_putfield_quick = -49;
    public static final byte op_getfield2_quick = -48;
    public static final byte op_putfield2_quick = -47;
    public static final byte op_getstatic_quick = -46;
    public static final byte op_putstatic_quick = -45;
    public static final byte op_getstatic2_quick = -44;
    public static final byte op_putstatic2_quick = -43;
    public static final byte op_invokevirtual_quick = -42;
    public static final byte op_invokenonvirtual_quick = -41;
    public static final byte op_invokesuper_quick = -40;
    public static final byte op_invokestatic_quick = -39;
    public static final byte op_invokeinterface_quick = -38;
    public static final byte op_invokevirtualobject_quick = -37;
    public static final byte op_new_quick = -35;
    public static final byte op_anewarray_quick = -34;
    public static final byte op_multianewarray_quick = -33;
    public static final byte op_checkcast_quick = -32;
    public static final byte op_instanceof_quick = -31;
    public static final byte op_invokevirtual_quick_w = -30;
    public static final byte op_getfield_quick_w = -29;
    public static final byte op_putfield_quick_w = -28;
    public static final byte op_impdep1 = -2;
    public static final byte op_impdep2 = -1;

    public static Instruction make_iconst(int i) {
        if (i >= -1 && i <= 5) {
            return new NoOperandsInstruction((byte)(3 + i), 1);
        }
        if (i >= -128 && i <= 127) {
            return new ByteInstruction(16, (byte)i, 1);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return new ShortInstruction(17, i, 1);
        }
        return new IntConstantInstruction(i);
    }

    public static Instruction make_sconst(String s) {
        return new StringConstantInstruction(s);
    }

    public static Instruction make_dconst(double d) {
        if (d == 0.0) {
            return new NoOperandsInstruction(14, 1);
        }
        if (d == 1.0) {
            return new NoOperandsInstruction(15, 1);
        }
        return new DoubleInstruction(d);
    }

    public static Instruction make_lconst(long l) {
        if (l == 0L) {
            return new NoOperandsInstruction(9, 1);
        }
        if (l == 1L) {
            return new NoOperandsInstruction(10, 1);
        }
        return new LongConstantInstruction(l);
    }

    public static Instruction make_fconst(float f) {
        if (f == 0.0f) {
            return new NoOperandsInstruction(11, 1);
        }
        if (f == 1.0f) {
            return new NoOperandsInstruction(12, 1);
        }
        if (f == 2.0f) {
            return new NoOperandsInstruction(13, 1);
        }
        return new FloatConstantInstruction(f);
    }

    public static Instruction make_invokevirtual(CodeMethod cm) {
        return new MethodInstruction(-74, cm);
    }

    public static Instruction make_invokespecial(CodeMethod cm) {
        return new MethodInstruction(-73, cm);
    }

    public static Instruction make_invokestatic(CodeMethod cm) {
        return new MethodInstruction(-72, cm);
    }

    public static Instruction make_invokeinterface(CodeMethod cm) {
        return new MethodInstruction(-71, cm);
    }

    public static Instruction make_getfield(CodeField cf) {
        return new FieldInstruction(-76, cf);
    }

    public static Instruction make_putfield(CodeField cf) {
        return new FieldInstruction(-75, cf);
    }

    public static Instruction make_getstatic(CodeField cf) {
        return new FieldInstruction(-78, cf);
    }

    public static Instruction make_putstatic(CodeField cf) {
        return new FieldInstruction(-77, cf);
    }

    public static Instruction make_iload(LocalVariable lv) throws CodeException {
        CodeClass cc = lv.getType();
        if (cc != CodeUtils.TYPE_INT && cc != CodeUtils.TYPE_SHORT && cc != CodeUtils.TYPE_CHAR && cc != CodeUtils.TYPE_BYTE && cc != CodeUtils.TYPE_BOOLEAN) {
            throw new CodeException(cc.getName() + " is not a VM `i' type");
        }
        return new LocalVariableInstruction(21, 26, lv);
    }

    public static Instruction make_lload(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_LONG) {
            throw new CodeException(lv.getType().getName() + " is not a long");
        }
        return new LocalVariableInstruction(22, 30, lv);
    }

    public static Instruction make_fload(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_FLOAT) {
            throw new CodeException(lv.getType().getName() + " is not a float");
        }
        return new LocalVariableInstruction(23, 34, lv);
    }

    public static Instruction make_dload(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_DOUBLE) {
            throw new CodeException(lv.getType().getName() + " is not a double");
        }
        return new LocalVariableInstruction(24, 38, lv);
    }

    public static Instruction make_aload(LocalVariable lv) throws CodeException {
        if (lv.getType().isPrimitive()) {
            throw new CodeException(lv.getType().getName() + " is a primitive type");
        }
        return new LocalVariableInstruction(25, 42, lv);
    }

    public static Instruction make_istore(LocalVariable lv) throws CodeException {
        CodeClass cc = lv.getType();
        if (cc != CodeUtils.TYPE_INT && cc != CodeUtils.TYPE_SHORT && cc != CodeUtils.TYPE_CHAR && cc != CodeUtils.TYPE_BYTE && cc != CodeUtils.TYPE_BOOLEAN) {
            throw new CodeException(cc.getName() + " is not a VM `i' type");
        }
        return new LocalVariableInstruction(54, 59, lv);
    }

    public static Instruction make_lstore(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_LONG) {
            throw new CodeException(lv.getType().getName() + " is not a long");
        }
        return new LocalVariableInstruction(55, 63, lv);
    }

    public static Instruction make_fstore(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_FLOAT) {
            throw new CodeException(lv.getType().getName() + " is not a float");
        }
        return new LocalVariableInstruction(56, 67, lv);
    }

    public static Instruction make_dstore(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_DOUBLE) {
            throw new CodeException(lv.getType().getName() + " is not a double");
        }
        return new LocalVariableInstruction(57, 71, lv);
    }

    public static Instruction make_astore(LocalVariable lv) throws CodeException {
        if (lv.getType().isPrimitive()) {
            throw new CodeException(lv.getType().getName() + " is a primitive type");
        }
        return new LocalVariableInstruction(58, 75, lv);
    }

    public static Instruction make_ifeq(Label lab) {
        return ByteCode.make_if((byte)-103, lab);
    }

    public static Instruction make_ifne(Label lab) {
        return ByteCode.make_if((byte)-102, lab);
    }

    public static Instruction make_iflt(Label lab) {
        return new LabelInstruction(-101, lab, -1);
    }

    public static Instruction make_ifge(Label lab) {
        return new LabelInstruction(-100, lab, -1);
    }

    public static Instruction make_ifgt(Label lab) {
        return new LabelInstruction(-99, lab, -1);
    }

    public static Instruction make_ifle(Label lab) {
        return new LabelInstruction(-98, lab, -1);
    }

    public static Instruction make_if_icmpeq(Label l) {
        return new LabelInstruction(-97, l, -2);
    }

    public static Instruction make_if_icmpne(Label l) {
        return new LabelInstruction(-96, l, -2);
    }

    public static Instruction make_if_icmplt(Label l) {
        return new LabelInstruction(-95, l, -2);
    }

    public static Instruction make_if_icmpge(Label l) {
        return new LabelInstruction(-94, l, -2);
    }

    public static Instruction make_if_icmpgt(Label l) {
        return new LabelInstruction(-93, l, -2);
    }

    public static Instruction make_if_icmple(Label l) {
        return new LabelInstruction(-92, l, -2);
    }

    public static Instruction make_if_acmpeq(Label l) {
        return new LabelInstruction(-91, l, -2);
    }

    public static Instruction make_if_acmpne(Label l) {
        return new LabelInstruction(-90, l, -2);
    }

    public static Instruction make_ifnull(Label l) {
        return new LabelInstruction(-58, l, -1);
    }

    public static Instruction make_ifnonnull(Label l) {
        return new LabelInstruction(-57, l, -1);
    }

    public static Instruction make_goto(Label l) {
        return new LabelInstruction(-89, l, 0);
    }

    public static Instruction make_jsr(Label l) {
        return new LabelInstruction(-88, l, 1);
    }

    public static Instruction make_nop() {
        return new NoOperandsInstruction(0, 0);
    }

    public static Instruction make_aconst_null() {
        return new NoOperandsInstruction(1, 1);
    }

    public static Instruction make_iaload() {
        return new NoOperandsInstruction(46, -1);
    }

    public static Instruction make_laload() {
        return new NoOperandsInstruction(47, -1);
    }

    public static Instruction make_faload() {
        return new NoOperandsInstruction(48, -1);
    }

    public static Instruction make_daload() {
        return new NoOperandsInstruction(49, -1);
    }

    public static Instruction make_aaload() {
        return new NoOperandsInstruction(50, -1);
    }

    public static Instruction make_baload() {
        return new NoOperandsInstruction(51, -1);
    }

    public static Instruction make_caload() {
        return new NoOperandsInstruction(52, -1);
    }

    public static Instruction make_saload() {
        return new NoOperandsInstruction(53, -1);
    }

    public static Instruction make_iastore() {
        return new NoOperandsInstruction(79, -3);
    }

    public static Instruction make_lastore() {
        return new NoOperandsInstruction(80, -3);
    }

    public static Instruction make_fastore() {
        return new NoOperandsInstruction(81, -3);
    }

    public static Instruction make_dastore() {
        return new NoOperandsInstruction(82, -3);
    }

    public static Instruction make_aastore() {
        return new NoOperandsInstruction(83, -3);
    }

    public static Instruction make_bastore() {
        return new NoOperandsInstruction(84, -3);
    }

    public static Instruction make_castore() {
        return new NoOperandsInstruction(85, -3);
    }

    public static Instruction make_sastore() {
        return new NoOperandsInstruction(86, -3);
    }

    public static Instruction make_pop() {
        return new NoOperandsInstruction(87, -1);
    }

    public static Instruction make_pop2() {
        return new NoOperandsInstruction(88, -2);
    }

    public static Instruction make_dup() {
        return new NoOperandsInstruction(89, 1);
    }

    public static Instruction make_dup_x1() {
        return new NoOperandsInstruction(90, 1);
    }

    public static Instruction make_dup_x2() {
        return new NoOperandsInstruction(91, 1);
    }

    public static Instruction make_dup2() {
        return new NoOperandsInstruction(92, 2);
    }

    public static Instruction make_dup2_x1() {
        return new NoOperandsInstruction(93, 2);
    }

    public static Instruction make_dup2_x2() {
        return new NoOperandsInstruction(94, 2);
    }

    public static Instruction make_swap() {
        return new NoOperandsInstruction(95, 0);
    }

    public static Instruction make_iadd() {
        return new NoOperandsInstruction(96, -1);
    }

    public static Instruction make_ladd() {
        return new NoOperandsInstruction(97, -1);
    }

    public static Instruction make_fadd() {
        return new NoOperandsInstruction(98, -1);
    }

    public static Instruction make_dadd() {
        return new NoOperandsInstruction(99, -1);
    }

    public static Instruction make_isub() {
        return new NoOperandsInstruction(100, -1);
    }

    public static Instruction make_lsub() {
        return new NoOperandsInstruction(101, -1);
    }

    public static Instruction make_fsub() {
        return new NoOperandsInstruction(102, -1);
    }

    public static Instruction make_dsub() {
        return new NoOperandsInstruction(103, -1);
    }

    public static Instruction make_imul() {
        return new NoOperandsInstruction(104, -1);
    }

    public static Instruction make_lmul() {
        return new NoOperandsInstruction(105, -1);
    }

    public static Instruction make_fmul() {
        return new NoOperandsInstruction(106, -1);
    }

    public static Instruction make_dmul() {
        return new NoOperandsInstruction(107, -1);
    }

    public static Instruction make_idiv() {
        return new NoOperandsInstruction(108, -1);
    }

    public static Instruction make_ldiv() {
        return new NoOperandsInstruction(109, -1);
    }

    public static Instruction make_fdiv() {
        return new NoOperandsInstruction(110, -1);
    }

    public static Instruction make_ddiv() {
        return new NoOperandsInstruction(111, -1);
    }

    public static Instruction make_irem() {
        return new NoOperandsInstruction(112, -1);
    }

    public static Instruction make_lrem() {
        return new NoOperandsInstruction(113, -1);
    }

    public static Instruction make_frem() {
        return new NoOperandsInstruction(114, -1);
    }

    public static Instruction make_drem() {
        return new NoOperandsInstruction(115, -1);
    }

    public static Instruction make_ineg() {
        return new NoOperandsInstruction(116, 0);
    }

    public static Instruction make_lneg() {
        return new NoOperandsInstruction(117, 0);
    }

    public static Instruction make_fneg() {
        return new NoOperandsInstruction(118, 0);
    }

    public static Instruction make_dneg() {
        return new NoOperandsInstruction(119, 0);
    }

    public static Instruction make_ishl() {
        return new NoOperandsInstruction(120, -1);
    }

    public static Instruction make_lshl() {
        return new NoOperandsInstruction(121, -1);
    }

    public static Instruction make_ishr() {
        return new NoOperandsInstruction(122, -1);
    }

    public static Instruction make_lshr() {
        return new NoOperandsInstruction(123, -1);
    }

    public static Instruction make_iushr() {
        return new NoOperandsInstruction(124, -1);
    }

    public static Instruction make_lushr() {
        return new NoOperandsInstruction(125, -1);
    }

    public static Instruction make_iand() {
        return new NoOperandsInstruction(126, -1);
    }

    public static Instruction make_land() {
        return new NoOperandsInstruction(127, -1);
    }

    public static Instruction make_ior() {
        return new NoOperandsInstruction(-128, -1);
    }

    public static Instruction make_lor() {
        return new NoOperandsInstruction(-127, -1);
    }

    public static Instruction make_ixor() {
        return new NoOperandsInstruction(-126, -1);
    }

    public static Instruction make_lxor() {
        return new NoOperandsInstruction(-125, -1);
    }

    public static Instruction make_i2l() {
        return new NoOperandsInstruction(-123, 0);
    }

    public static Instruction make_i2f() {
        return new NoOperandsInstruction(-122, 0);
    }

    public static Instruction make_i2d() {
        return new NoOperandsInstruction(-121, 0);
    }

    public static Instruction make_l2i() {
        return new NoOperandsInstruction(-120, 0);
    }

    public static Instruction make_l2f() {
        return new NoOperandsInstruction(-119, 0);
    }

    public static Instruction make_l2d() {
        return new NoOperandsInstruction(-118, 0);
    }

    public static Instruction make_f2i() {
        return new NoOperandsInstruction(-117, 0);
    }

    public static Instruction make_f2l() {
        return new NoOperandsInstruction(-116, 0);
    }

    public static Instruction make_f2d() {
        return new NoOperandsInstruction(-115, 0);
    }

    public static Instruction make_d2i() {
        return new NoOperandsInstruction(-114, 0);
    }

    public static Instruction make_d2l() {
        return new NoOperandsInstruction(-113, 0);
    }

    public static Instruction make_d2f() {
        return new NoOperandsInstruction(-112, 0);
    }

    public static Instruction make_i2b() {
        return new NoOperandsInstruction(-111, 0);
    }

    public static Instruction make_i2c() {
        return new NoOperandsInstruction(-110, 0);
    }

    public static Instruction make_i2s() {
        return new NoOperandsInstruction(-109, 0);
    }

    public static Instruction make_lcmp() {
        return new NoOperandsInstruction(-108, -1);
    }

    public static Instruction make_fcmpl() {
        return new NoOperandsInstruction(-107, -1);
    }

    public static Instruction make_fcmpg() {
        return new NoOperandsInstruction(-106, -1);
    }

    public static Instruction make_dcmpl() {
        return new NoOperandsInstruction(-105, -1);
    }

    public static Instruction make_dcmpg() {
        return new NoOperandsInstruction(-104, -1);
    }

    public static Instruction make_ireturn() {
        return new NoOperandsInstruction(-84, -1);
    }

    public static Instruction make_lreturn() {
        return new NoOperandsInstruction(-83, -1);
    }

    public static Instruction make_freturn() {
        return new NoOperandsInstruction(-82, -1);
    }

    public static Instruction make_dreturn() {
        return new NoOperandsInstruction(-81, -1);
    }

    public static Instruction make_areturn() {
        return new NoOperandsInstruction(-80, -1);
    }

    public static Instruction make_return() {
        return new NoOperandsInstruction(-79, 0);
    }

    public static Instruction make_arraylength() {
        return new NoOperandsInstruction(-66, 0);
    }

    public static Instruction make_athrow() {
        return new NoOperandsInstruction(-65, 0);
    }

    public static Instruction make_monitorenter() {
        return new NoOperandsInstruction(-62, -1);
    }

    public static Instruction make_monitorexit() {
        return new NoOperandsInstruction(-61, -1);
    }

    public static Instruction make_wide() {
        return new NoOperandsInstruction(-60, 0);
    }

    public static Instruction make_breakpoint() {
        return new NoOperandsInstruction(-54, 0);
    }

    public static Instruction make_invokevirtual_quick_w() {
        return new NoOperandsInstruction(-30, 0);
    }

    public static Instruction make_impdep1() {
        return new NoOperandsInstruction(-2, 0);
    }

    public static Instruction make_impdep2() {
        return new NoOperandsInstruction(-1, 0);
    }

    public static Instruction make_checkcast(CodeClass clazz) {
        return new ClassInstruction(-64, clazz, 0);
    }

    public static Instruction make_instanceof(CodeClass clazz) {
        return new ClassInstruction(-63, clazz, 0);
    }

    public static Instruction make_new(CodeClass clazz) {
        return new ClassInstruction(-69, clazz, 1);
    }

    public static Instruction make_newarray(CodeClass clazz) throws CodeException {
        if (clazz.isPrimitive()) {
            int type = -1;
            if (clazz == CodeUtils.TYPE_BOOLEAN) {
                type = 4;
            } else if (clazz == CodeUtils.TYPE_CHAR) {
                type = 5;
            } else if (clazz == CodeUtils.TYPE_FLOAT) {
                type = 6;
            } else if (clazz == CodeUtils.TYPE_DOUBLE) {
                type = 7;
            } else if (clazz == CodeUtils.TYPE_BYTE) {
                type = 8;
            } else if (clazz == CodeUtils.TYPE_SHORT) {
                type = 9;
            } else if (clazz == CodeUtils.TYPE_INT) {
                type = 10;
            } else if (clazz == CodeUtils.TYPE_LONG) {
                type = 11;
            }
            if (type < 0) {
                throw new CodeException("Invalid type " + clazz.getName());
            }
            return new ByteInstruction(-68, (byte)type, 0);
        }
        return new ClassInstruction(-67, clazz, 0);
    }

    public static Instruction make_return(CodeMethod method) {
        return ByteCode.make_return(method.getReturnType());
    }

    public static Instruction make_return(CodeClass clazz) {
        if (CodeUtils.TYPE_VOID.equals(clazz)) {
            return ByteCode.make_return();
        }
        if (CodeUtils.TYPE_BYTE.equals(clazz) || CodeUtils.TYPE_SHORT.equals(clazz) || CodeUtils.TYPE_CHAR.equals(clazz) || CodeUtils.TYPE_BOOLEAN.equals(clazz) || CodeUtils.TYPE_INT.equals(clazz)) {
            return ByteCode.make_ireturn();
        }
        if (CodeUtils.TYPE_LONG.equals(clazz)) {
            return ByteCode.make_lreturn();
        }
        if (CodeUtils.TYPE_FLOAT.equals(clazz)) {
            return ByteCode.make_freturn();
        }
        if (CodeUtils.TYPE_DOUBLE.equals(clazz)) {
            return ByteCode.make_dreturn();
        }
        return ByteCode.make_areturn();
    }

    public static Instruction make_invoke(CodeMethod cm) {
        int modifiers = cm.getModifiers();
        if ((8 & modifiers) != 0) {
            return ByteCode.make_invokestatic(cm);
        }
        return ByteCode.make_invokeinterface(cm);
    }

    public static CodeGenerator make_synchronizedBlock(LocalVariable lockVar, CodeGenerator code) throws CodeException {
        InstructionVector block = new InstructionVector();
        block.add(ByteCode.make_aload(lockVar));
        block.add(ByteCode.make_dup());
        block.add(ByteCode.make_monitorenter());
        block.add(code);
        block.add(ByteCode.make_monitorexit());
        return block;
    }

    public static CodeGenerator make_synchronizedBlock(CodeGenerator code) {
        InstructionVector block = new InstructionVector();
        block.add(ByteCode.make_dup());
        block.add(ByteCode.make_monitorenter());
        block.add(code);
        block.add(ByteCode.make_monitorexit());
        return block;
    }

    public static CodeGenerator make_markLabel(Label lab) {
        return new MarkLabel(lab);
    }

    public static Instruction make_if(byte op, Label lab) {
        if (op >= -103 && op <= -98) {
            return new LabelInstruction(op, lab, -1);
        }
        if (op >= -97 && op <= -90) {
            return new LabelInstruction(op, lab, -2);
        }
        throw new IllegalArgumentException("Opcode must be an if. " + op);
    }

    public static ParametricCodeGenerator make_newraray(final ParametricType type) {
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDepth() {
                return 0;
            }

            public int stackDelta() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                ByteCode.make_newarray(cc).writeCode(ctx);
            }
        };
    }

    public static ParametricCodeGenerator make_array_load(final ParametricType type) {
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDepth() {
                return 0;
            }

            public int stackDelta() {
                return -1;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    ctx.writeByte((byte)50);
                } else if (cc == CodeUtils.TYPE_INT) {
                    ctx.writeByte((byte)46);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)49);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)48);
                } else if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)49);
                } else if (cc == CodeUtils.TYPE_BYTE) {
                    ctx.writeByte((byte)51);
                } else if (cc == CodeUtils.TYPE_CHAR) {
                    ctx.writeByte((byte)52);
                } else if (cc == CodeUtils.TYPE_SHORT) {
                    ctx.writeByte((byte)53);
                } else {
                    throw new CodeException("Confused. Don't recognize type: " + cc);
                }
            }
        };
    }

    public static ParametricCodeGenerator make_arrayStore(final ParametricType type) {
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDepth() {
                return 0;
            }

            public int stackDelta() {
                return -3;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    ctx.writeByte((byte)83);
                } else if (cc == CodeUtils.TYPE_INT) {
                    ctx.writeByte((byte)79);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)82);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)81);
                } else if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)82);
                } else if (cc == CodeUtils.TYPE_BYTE) {
                    ctx.writeByte((byte)84);
                } else if (cc == CodeUtils.TYPE_CHAR) {
                    ctx.writeByte((byte)85);
                } else if (cc == CodeUtils.TYPE_SHORT) {
                    ctx.writeByte((byte)86);
                } else {
                    throw new CodeException("Confused. Don't recognize type: " + cc);
                }
            }
        };
    }

    public ParametricCodeGenerator make_load(final ParametricType type, final LocalVariable lv) throws CodeException {
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDepth() {
                return 1;
            }

            public int stackDelta() {
                return 1;
            }

            /*
             * WARNING - void declaration
             */
            public void writeCode(CodeContext ctx) throws CodeException {
                void var3_3;
                Instruction ins;
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    ins = ByteCode.make_aload(lv);
                } else if (cc == CodeUtils.TYPE_INT) {
                    ins = ByteCode.make_iload(lv);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ins = ByteCode.make_lload(lv);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ins = ByteCode.make_fload(lv);
                } else if (cc == CodeUtils.TYPE_DOUBLE) {
                    ins = ByteCode.make_dload(lv);
                } else if (cc == CodeUtils.TYPE_BYTE) {
                    ins = ByteCode.make_iload(lv);
                } else if (cc == CodeUtils.TYPE_CHAR) {
                    ins = ByteCode.make_iload(lv);
                } else if (cc == CodeUtils.TYPE_SHORT) {
                    ins = ByteCode.make_iload(lv);
                } else {
                    throw new CodeException("Confused. Don't recognize type: " + cc);
                }
                var3_3.writeCode(ctx);
            }
        };
    }

    public ParametricCodeGenerator make_save(final ParametricType type, final LocalVariable lv) throws CodeException {
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDepth() {
                return 0;
            }

            public int stackDelta() {
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            public void writeCode(CodeContext ctx) throws CodeException {
                void var3_3;
                Instruction ins;
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    ins = ByteCode.make_astore(lv);
                } else if (cc == CodeUtils.TYPE_INT) {
                    ins = ByteCode.make_istore(lv);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ins = ByteCode.make_lstore(lv);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ins = ByteCode.make_fstore(lv);
                } else if (cc == CodeUtils.TYPE_DOUBLE) {
                    ins = ByteCode.make_dstore(lv);
                } else if (cc == CodeUtils.TYPE_BYTE) {
                    ins = ByteCode.make_istore(lv);
                } else if (cc == CodeUtils.TYPE_CHAR) {
                    ins = ByteCode.make_istore(lv);
                } else if (cc == CodeUtils.TYPE_SHORT) {
                    ins = ByteCode.make_istore(lv);
                } else {
                    throw new CodeException("Confused. Don't recognize type: " + cc);
                }
                var3_3.writeCode(ctx);
            }
        };
    }

    public ParametricCodeGenerator make_return(final ParametricType type) {
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDepth() {
                return 0;
            }

            public int stackDelta() {
                return -1;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    ctx.writeByte((byte)-80);
                } else if (cc == CodeUtils.TYPE_INT) {
                    ctx.writeByte((byte)-84);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)-83);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)-82);
                } else if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)-81);
                } else if (cc == CodeUtils.TYPE_BYTE) {
                    ctx.writeByte((byte)-84);
                } else if (cc == CodeUtils.TYPE_CHAR) {
                    ctx.writeByte((byte)-84);
                } else if (cc == CodeUtils.TYPE_SHORT) {
                    ctx.writeByte((byte)-84);
                } else {
                    throw new CodeException("Confused. Don't recognize type: " + cc);
                }
            }
        };
    }

    public PParametricCodeGenerator make_cast(final ParametricType from, final ParametricType to) throws CodeException {
        if (from.isObject()) {
            throw new CodeException("Can not cast from non-primative type: " + from);
        }
        if (to.isObject()) {
            throw new CodeException("Can not cast to non-primative type: " + to);
        }
        return new PParametricCodeGenerator(){

            public ParametricType getType1() {
                return from;
            }

            public ParametricType getType2() {
                return to;
            }

            public int stackDepth() {
                return 0;
            }

            public int stackDelta() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                if (from == to) {
                    return;
                }
                CodeClass fromc = ctx.resolveParametricType(from);
                CodeClass toc = ctx.resolveParametricType(to);
                if (!fromc.isPrimitive()) {
                    throw new CodeException("Can't cast from non-primitive type: " + fromc);
                }
                if (!toc.isPrimitive()) {
                    throw new CodeException("Can't cast to non-primitive type: " + toc);
                }
                if (fromc == CodeUtils.TYPE_DOUBLE) {
                    if (toc == CodeUtils.TYPE_FLOAT) {
                        ctx.writeByte((byte)-112);
                    } else if (toc == CodeUtils.TYPE_LONG) {
                        ctx.writeByte((byte)-113);
                    } else {
                        ctx.writeByte((byte)-114);
                    }
                } else if (fromc == CodeUtils.TYPE_LONG) {
                    if (toc == CodeUtils.TYPE_FLOAT) {
                        ctx.writeByte((byte)-119);
                    } else if (toc == CodeUtils.TYPE_DOUBLE) {
                        ctx.writeByte((byte)-118);
                    } else {
                        ctx.writeByte((byte)-114);
                    }
                } else if (toc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)-122);
                } else if (toc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)-121);
                } else if (toc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)-123);
                } else if (toc == CodeUtils.TYPE_BYTE) {
                    ctx.writeByte((byte)-111);
                } else if (toc == CodeUtils.TYPE_CHAR) {
                    ctx.writeByte((byte)-110);
                } else if (toc == CodeUtils.TYPE_SHORT) {
                    ctx.writeByte((byte)-109);
                }
            }
        };
    }

    public ParametricCodeGenerator make_add(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't add non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("We can only add primitive types: " + type + " : " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)99);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)97);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)98);
                } else {
                    ctx.writeByte((byte)96);
                }
            }
        };
    }

    public ParametricCodeGenerator make_sub(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't sub non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("We can only sub primitive types: " + type + " : " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)103);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)101);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)102);
                } else {
                    ctx.writeByte((byte)100);
                }
            }
        };
    }

    public ParametricCodeGenerator make_mul(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't mul non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("We can only mul primitive types: " + type + " : " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)107);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)105);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)106);
                } else {
                    ctx.writeByte((byte)104);
                }
            }
        };
    }

    public ParametricCodeGenerator make_div(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't div non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("We can only div primitive types: " + type + " : " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)111);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)109);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)110);
                } else {
                    ctx.writeByte((byte)108);
                }
            }
        };
    }

    public ParametricCodeGenerator make_rem(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't rem non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("We can only rem primitive types: " + type + " : " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)115);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)113);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)114);
                } else {
                    ctx.writeByte((byte)112);
                }
            }
        };
    }

    public ParametricCodeGenerator make_neg(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't add non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return 0;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("We can only add primitive types: " + type + " : " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)119);
                } else if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)117);
                } else if (cc == CodeUtils.TYPE_FLOAT) {
                    ctx.writeByte((byte)118);
                } else {
                    ctx.writeByte((byte)116);
                }
            }
        };
    }

    public ParametricCodeGenerator make_shiftLeft(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't shift non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("Can't shift non-primitive type: " + cc);
                }
                if (CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can't shift floating point type: " + cc);
                }
                if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)121);
                } else {
                    ctx.writeByte((byte)120);
                }
            }
        };
    }

    public ParametricCodeGenerator make_shiftRight(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't shift non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("Can't shift non-primitive type: " + cc);
                }
                if (CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can't shift floating point type: " + cc);
                }
                if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)123);
                } else {
                    ctx.writeByte((byte)122);
                }
            }
        };
    }

    public ParametricCodeGenerator make_shiftRightLogical(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't shift non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("Can't shift non-primitive type: " + cc);
                }
                if (CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can't shift floating point type: " + cc);
                }
                if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)125);
                } else {
                    ctx.writeByte((byte)124);
                }
            }
        };
    }

    public ParametricCodeGenerator make_and(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't and non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("Can't and non-primitive type: " + cc);
                }
                if (CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can't and floating point type: " + cc);
                }
                if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)127);
                } else {
                    ctx.writeByte((byte)126);
                }
            }
        };
    }

    public ParametricCodeGenerator make_or(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't and non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("Can't or non-primitive type: " + cc);
                }
                if (CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can't or floating point type: " + cc);
                }
                if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)-127);
                } else {
                    ctx.writeByte((byte)-128);
                }
            }
        };
    }

    public ParametricCodeGenerator make_xor(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't and non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!cc.isPrimitive()) {
                    throw new CodeException("Can't xor non-primitive type: " + cc);
                }
                if (CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can't xor floating point type: " + cc);
                }
                if (cc == CodeUtils.TYPE_LONG) {
                    ctx.writeByte((byte)-125);
                } else {
                    ctx.writeByte((byte)-126);
                }
            }
        };
    }

    public ParametricCodeGenerator make_cmpg(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't cmpg non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can only cmpg floating point types: " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)-104);
                } else {
                    ctx.writeByte((byte)-106);
                }
            }
        };
    }

    public ParametricCodeGenerator make_cmpl(final ParametricType type) throws CodeException {
        if (type.isObject()) {
            throw new CodeException("Can't cmpl non-primitive type: " + type);
        }
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return -1;
            }

            public int stackDepth() {
                return 0;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (!CodeUtils.isFloatType(cc)) {
                    throw new CodeException("Can only cmpl floating point types: " + cc);
                }
                if (cc == CodeUtils.TYPE_DOUBLE) {
                    ctx.writeByte((byte)-105);
                } else {
                    ctx.writeByte((byte)-107);
                }
            }
        };
    }

    public ParametricCodeGenerator make_dup(final ParametricType type) throws CodeException {
        return new ParametricCodeGenerator(){

            public ParametricType getType() {
                return type;
            }

            public int stackDelta() {
                return 1;
            }

            public int stackDepth() {
                return 1;
            }

            public void writeCode(CodeContext ctx) throws CodeException {
                CodeClass cc = ctx.resolveParametricType(type);
                if (CodeUtils.wordsForType(cc) == 2) {
                    ctx.writeByte((byte)92);
                } else {
                    ctx.writeByte((byte)89);
                }
            }
        };
    }
}

