/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.LayeredRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class MultiLineRenderer
extends AbstractChangeable
implements SequenceRenderer,
Serializable {
    public static final ChangeType RENDERERS = new ChangeType("A SequenceRenderer has been added or removed.", "org.biojava.bio.gui.sequence.MultiLineRenderer", "RENDERERS", SequenceRenderContext.LAYOUT);
    protected List renderers = new ArrayList();
    private transient ChangeForwarder rendererForwarder = null;

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.rendererForwarder == null) {
            this.rendererForwarder = new SequenceRenderer.RendererForwarder(this, cs);
            Iterator i = this.renderers.iterator();
            while (i.hasNext()) {
                SequenceRenderer sRend = (SequenceRenderer)i.next();
                if (!(sRend instanceof Changeable)) continue;
                Changeable c = (Changeable)((Object)sRend);
                c.addChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderer(SequenceRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERERS, renderer, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERERS);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._addRenderer(renderer);
                if (renderer instanceof Changeable) {
                    Changeable c = (Changeable)((Object)renderer);
                    c.addChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._addRenderer(renderer);
        }
    }

    protected void _addRenderer(SequenceRenderer renderer) {
        this.renderers.add(renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderer(SequenceRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERERS, null, renderer);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERERS);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._removeRenderer(renderer);
                if (renderer instanceof Changeable) {
                    Changeable c = (Changeable)((Object)renderer);
                    c.removeChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._removeRenderer(renderer);
        }
    }

    protected void _removeRenderer(SequenceRenderer renderer) {
        this.renderers.remove(renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRenderers() throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERERS);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERERS);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                Iterator i = this.renderers.iterator();
                while (i.hasNext()) {
                    Object r = i.next();
                    if (!(r instanceof Changeable)) continue;
                    Changeable c = (Changeable)r;
                    c.removeChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                this.renderers.clear();
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.renderers.clear();
        }
    }

    public double getDepth(SequenceRenderContext src) {
        return LayeredRenderer.INSTANCE.getDepth(Collections.nCopies(this.renderers.size(), src), this.renderers);
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return LayeredRenderer.INSTANCE.getMinimumLeader(Collections.nCopies(this.renderers.size(), src), this.renderers);
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return LayeredRenderer.INSTANCE.getMinimumTrailer(Collections.nCopies(this.renderers.size(), src), this.renderers);
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        LayeredRenderer.INSTANCE.paint(g, Collections.nCopies(this.renderers.size(), src), this.renderers);
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        SequenceViewerEvent sve = LayeredRenderer.INSTANCE.processMouseEvent(Collections.nCopies(this.renderers.size(), src), me, path, this.renderers);
        if (sve == null) {
            sve = new SequenceViewerEvent(this, null, src.graphicsToSequence(me.getPoint()), me, path);
        }
        return sve;
    }
}

