#!/usr/bin/perl -w
################################################################################
#
#  embl2chart.pl <embl-file>
# 
#  Prints a chart of colombos output

use strict;
use Bio::SeqIO;

my $WIDTH=70;


if (@ARGV != 1) {
    die "USAGE: perl embl2chart.pl <embl-file>\n";
}
my $file_no=0;
my $gene_no=0;

my $input_file = shift;
my %mapping = ("NORMAL" => '_',
	       "HIEXP" => '.',
	       "HIEXPI" => '-',
	       "INCON" => '-',
	       "PUTAL" => '*',
	       "OUTNORMAL" => 'o',
	       "OUTPUTAL" => '*' );
my %count;

    
my $seq=Bio::SeqIO->new(-format => 'embl',
			    -file => $input_file) -> next_seq();

my $seqid="$file_no:".$seq->display_id();
my @topfeatures = $seq->get_SeqFeatures();
my $start_pos=0;
   
foreach my $feat (@topfeatures)
{
    if ($feat->primary_tag =~ /(.*PUTAL|HIEXP|INCON.?|.*NORMAL)/)
    {
	my $affil = $1;
	if ($gene_no % $WIDTH == 0) {
	    printf("\n%5d%10s ", $gene_no, "[$start_pos]");
	}
 	$start_pos = $feat->start;
	print $mapping{$affil};
	$count{$affil}++;
	$gene_no++;
    }
}

print "\n";

print "\n\nLegend:\n ".$mapping{"NORMAL"}." normal\n ";
print $mapping{"HIEXP"}." putatively highly expressed\n ".$mapping{"PUTAL"}." putatively alien\n ";
print $mapping{"INCON"}." inconspicuous/phx, but located in Genomic Island\n\n";

foreach my $key (keys(%count))
{
    printf("%6s:%s\n", $key, &show_ratio($count{$key}, $gene_no));
}
print "\n";

sub show_ratio()
{
    my ($share, $total) = @_;

    return sprintf("%5d of%5d%8s",$share, $total, sprintf("(%.1f%%)", $share*100/$total));
}
