/*
 * Decompiled with CFR 0.152.
 */
package mpimp.hashgenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hashgenerator {
    public static String sha1(String input, String securitySalt) throws NoSuchAlgorithmException {
        input = String.valueOf(securitySalt) + input;
        MessageDigest mDigest = MessageDigest.getInstance("SHA-1");
        byte[] result = mDigest.digest(input.getBytes());
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < result.length) {
            String part = Integer.toString((result[i] & 0xFF) + 256, 16).substring(1);
            sb.append(part);
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            try {
                String hashedString = Hashgenerator.sha1(args[0], args[1]);
                System.out.println("Clear text: " + args[0] + "\nKey: " + args[1] + "\nHashed text: " + hashedString);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        } else if (args.length == 3) {
            try {
                String hashedString = Hashgenerator.sha1(args[0], args[1]);
                File output = new File(args[2]);
                BufferedWriter bw = new BufferedWriter(new FileWriter(output));
                bw.write(hashedString);
                bw.close();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage:\n Hashgenerator <clear text string> <key> [<output file>]");
        }
    }
}

