<?php

##################################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - Kenny Billiau
# - jgremmels(at)bioinformatics.org - initial API and implementation
################################################################################

/**
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake.libs.view.templates.layouts
 * @since         CakePHP(tm) v 0.10.0.1076
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
 
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<?php echo $this->Html->charset(); ?>
	<title>
		<?php __('Phenotyper'); ?>
		<?php echo $title_for_layout; ?>
	</title>
	<?php
		echo $this->Html->meta('icon');

		echo $this->Html->css('cake.generic');
        echo $this->Javascript->link('jquery-1.5.1.min', true);

		echo $scripts_for_layout;

        $bo_started = $this->Session->read('BO.started') ? 1 : 0;
        echo $this->Javascript->codeBlock("
            $(document).ready(function() {
                if ($bo_started) {
                    $('#backoffice_menu').show();
                    $('#normal_menu').hide();
                    $('#backoffice_link').text('NormalMenu');
                }
                else {
                    $('#backoffice_menu').hide();
                    $('#normal_menu').show();
                }
                $('#backoffice_link').click(function() {
                    $('#backoffice_menu').slideToggle('fast');
                    $('#normal_menu').slideToggle('fast', function () {
                        if ($('#backoffice_menu').is(':visible')) {
                            $('#backoffice_link').text('NormalMenu');
                        }
                        else {
                            $('#backoffice_link').text('BackOffice');
                        }
                    });
                });
            });
            ");
	?>
</head>
<body>
	<div id="container">
		<div id="header">
        <?php echo $this->Html->link($this->Html->image('home_image.jpg'), '/', array('escape' => false) ); ?>
            <span>
            <?php
            $person = $this->Session->read('Auth.Person');
            if ( ! empty($person)) {
                echo __('Welcome');
                echo '&nbsp;';
                echo $person['name'];
                echo '&nbsp;';
            }
            
            $default_url = $this->passedArgs;
            $de_url = $en_url = $default_url;
            $de_url['lang'] = 'de-de';
            $en_url['lang'] = 'en-us';
            echo $html->link('EN', $en_url);
            echo '|';
            echo $html->link('DE', $de_url);
            ?>
            <br />
            <ul>
				<?php if ( ! empty($person)): ?>
					<li><?php echo $this->Html->link(__('Change password', true), array('controller' => 'people', 'action' => 'edit', $person['id'])); ?></li>
					<li><?php echo $this->Html->link(__('Logout', true), array('controller' => 'people', 'action' => 'logout')); ?></li>
				<?php else: ?>
					<li><?php echo $this->Html->link(__('Login', true), array('controller' => 'people', 'action' => 'login')); ?></li>
				<?php endif ?>
			</ul>
            </span>
		</div>
		<div id="content">

			<?php echo $this->Session->flash(); ?>
			<?php echo $this->Session->flash('edit'); ?>

			<?php echo $content_for_layout; ?>
            <div class="actions">
                <h3><?php __('Menu'); ?></h3>
                <ul id="normal_menu">
                <li><?php echo $html->link(__('Home', true), '/'); ?></li>
                <li><hr style="margin: 20px;" /></li>
		<li><?php echo $html->link(__('Upload scanner file', true), '/testobjects/upload'); ?></li>
                <li><?php echo $html->link(__('Upload file', true), '/ufiles/upload'); ?></li>
				<!-- <li><?php echo $html->link(__('List scanner files', true), '/raws/index'); ?></li> -->
                <li><?php echo $html->link(__('List files', true), '/ufiles/index'); ?></li>
                <li><?php echo $html->link(__('Search files', true), '/ufiles/search'); ?></li>
  		<li><?php echo $html->link(__('List results', true), '/testobjects/index'); ?></li>
		<li><?php echo $html->link(__('Query results', true), '/testobjects/search'); ?></li>
                <li><hr style="margin: 20px;" /></li>
                <li><?php echo $html->link(__('Blog', true), '/posts/index'); ?></li>
                <li><hr style="margin: 20px;" /></li>
                <li><?php echo $html->link(__('Create phenotyping schemes', true), 'http://trost.mpimp-golm.mpg.de/TestProgramComposer', array('target' => '_blank')); ?></li>
                <?php if ($admin): ?>
                <li><hr style="margin: 20px;" /></li>
                </ul>
                <ul><li><?php echo $this->Ajax->link(__('BackOffice', true), '/bos/toggle', array('id' => 'backoffice_link')); ?></li></ul>
                <ul id="backoffice_menu"> 
                <li><?php echo $html->link(__('Home', true), '/'); ?></li>
				<!-- <li><?php echo $html->link(__('Upload entities file', true), '/entities/upload'); ?></li> -->
				<!-- <li><?php echo $html->link(__('Upload values file', true), '/values/upload'); ?></li> -->
				<!-- <li><?php echo $html->link(__('Upload BBCH file', true), '/bbches/upload'); ?></li> -->
                <!-- <li><hr style="margin: 20px;" /></li> -->
                <!--<li><?php echo $html->link(__('Download XML', true), '/phenotypes/download'); ?></li>--> 
                <li><hr style="margin: 20px;" /></li>
                <li><?php echo $html->link(__('Add user', true), '/people/add'); ?></li>
                <li><?php echo $html->link(__('List users', true), '/people/index'); ?></li>
				<li><?php echo $html->link(__('Add project', true), '/projects/add'); ?></li>
				<li><?php echo $html->link(__('List projects', true), '/projects/index'); ?></li>
                <?php endif; ?>
                </ul>
            </div>

		</div>
		<div id="footer">
			<?php echo $this->Html->link('imprint', 'http://mpimp.iwww.mpg.de/2278/impress', array('target' => '_blank')); ?>
			<?php echo $this->Html->link($this->Html->image('logo_1.jpg', array('alt' => 'Max Planck Society')), 'http://www.mpg.de', array('target' => '_blank', 'escape' => false)); ?>
			<?php echo $this->Html->link($this->Html->image('logo_2.jpg', array('alt' => 'Max Plank Institute for Molekular Plant Physiology')), 'http://www.mpimp-golm.mpg.de', array('target' => '_blank', 'escape' => false)); ?>
		</div>
	</div>
	</div>
</body>
</html>
