
<!--
Phenotyper - a tool for collecting phenotyping data using mobile terminals
Copyright (C) 2015,  jgremmels(at)bioinformatics.org

Phenotyper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>

Contributors:
 - jgremmels(at)bioinformatics.org - initial API and implementation
-->

<?php echo $javascript->link('jquery-1.5.1.min', false); ?>
<div class="ufiles index">
<?php $person = $this->Session->read('Auth.Person');?>
<h2><?php __('Projects')?></h2>
<p><?php echo $this->Html->link(__('Add Project', true), array('action' => 'add')); ?></p>
<p>
<table>
	<tr>
			<th><?php echo $this->Paginator->sort(__('Id', true), 'Project.id');?></th>
            <th><?php echo $this->Paginator->sort(__('Name', true), 'Project.name') ?></th>
			<th class="actions"><?php __('Action')?></th>
			<th><?php echo $this->Paginator->sort(__('Start', true), 'Project.start_date');?></th>
			<th><?php echo $this->Paginator->sort(__('End', true), 'Project.end_date');?></th>
	</tr>
<!-- Here's where we loop through our $posts array, printing out Project info -->

<?php foreach ($projects as $Project): ?>
    <tr>
        <td><?php echo $Project['Project']['id']; ?></td>
        <td>
            <?php echo $this->Html->link($Project['Project']['name'], array('action' => 'view', $Project['Project']['id'])); ?>
        </td>
        <td class="actions">
		<?php 
			if ($Project['Project']['name'] != 'no project') : echo $this->Html->link(__('Edit', true), array('action' => 'edit', $Project['Project']['id'])); endif; 
		?>
        </td>
        <td>
            <?php echo $Project['Project']['start_date']; ?>
        </td>
        <td>
            <?php echo $Project['Project']['end_date']; ?>
        </td>
    </tr>
<?php endforeach; ?>
</table>


	<?php
	echo $this->Paginator->counter(array(
	'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
	));
	?>	</p>

	<div class="paging">
		<?php echo $this->Paginator->prev('<< ' . __('previous', true), array(), null, array('class'=>'disabled'));?>
	 | 	<?php echo $this->Paginator->numbers();?>
 |
		<?php echo $this->Paginator->next(__('next', true) . ' >>', array(), null, array('class' => 'disabled'));?>
	</div>
</div>
