<!--
Phenotyper - a tool for collecting phenotyping data using mobile terminals
Copyright (C) 2015,  jgremmels(at)bioinformatics.org

Phenotyper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>

Contributors:
 - jgremmels(at)bioinformatics.org - initial API and implementation
-->
<?php echo $javascript->link('jquery-1.5.1.min', false); ?>
<?php echo $javascript->codeBlock('
    $(document).ready(function() {
        $("#FileManual").change(function() {
            if ($(this).is(":checked")) {
                $("#FileRaw").attr("disabled", "disabled");
                if ($("#PhenotypeProgramId").val()==0) {
                    $("#PhenotypeProgramId").val(1);
                }
            }
            else {
                $("#FileRaw").attr("disabled", "");
            }
        });
    });
'); ?>
<div class="phenotypes form">
<?php echo $this->Form->create('Testobject', array('type' => 'file'));?>
	<fieldset>
 		<legend><?php __('Upload scanner file'); ?></legend>
	<?php
		echo $this->Form->label('Testobjects.dateFormat', __("Please choose the date format used in the result file (preferred is the format according to ISO 8601 'yyyy-MM-ddThh:mm:ss'): ", true));
	?>
	<?php
		echo $this->Form->select('Testobjects.dateFormat', $dateFormatOptions, $selected='yyyy-mm-dd', array('empty' => false));
	?>
    <br />
    <br />
	<?php
		echo $this->Form->label('Testobjects.project_id', __("Project", true));
	?>
	<?php
		echo $this->Form->select('Testobjects.project_id', $project_list, null, array('empty' => false));
	?>
    <br />
    <br />
	<?php
		echo $this->Form->label('File.corrected', __("Edited data file (data from this file will be inserted in the database): ", true));
        echo $this->Form->file('File.corrected', array('label' => 'File upload', 'accept' => 'text/xml'));
    ?>
	<?php
		echo $this->Form->label('File.raw', __("Raw data file: ", true));
        echo $this->Form->file('File.raw', array('label' => 'File upload', 'accept' => 'text/xml'));
    ?>
    <br />
	<br />
	<?php
		echo $this->Form->checkbox('File.validate', array('checked' => true));
		echo $this->Form->label('File.validate', __("Validate. If checked, uploaded result files will be validated against an xsd schema. Choosing validation may cause rejection of some result files produced by old Phenotyper versions. On the other hand, you ensure that the format is absolutely correct.", true));
	?>
    <br />
    <br />
	</fieldset>
<?php echo $this->Form->end(__('Submit', true));?>
</div>
