<?php
/**
 * Routes configuration
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different urls to chosen controllers and their actions (functions).
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.app.config
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
/**
 * Here, we are connecting '/' (base path) to controller called 'Pages',
 * its action called 'display', and we pass a param to select the view file
 * to use (in this case, /app/views/pages/home.ctp)...
 */

    
    /*
    http://www.studiocanaria.com/articles/quicktips_finding_all_the_controllers_in_your_cakephp_application
    */
    function listControllers() {
        return array_unique(
            array_map('__plunderscore', Configure::listObjects('controller'))
        );
    }

    function __plunderscore($name) {
        return Inflector::pluralize(Inflector::underscore($name));
    }

    # connect the from page
	Router::connect('/', array('controller' => 'pages', 'action' => 'display', 'home'));
	Router::connect('/:lang', array('controller' => 'pages', 'action' => 'display', 'home'));
/**
 * ...and connect the rest of 'Pages' controller's urls.
 */
	Router::connect('/pages/*', array('controller' => 'pages', 'action' => 'display'));
	
    #Router::connect('/de-de/:controller/:action/*', array('lang' => 'de-de'));
    #Router::connect('/en-us/:controller/:action/*', array('lang' => 'en-us'));
    # explicitly attach all the indexes
    $controllers = listControllers();
    foreach ($controllers as $controller) {
        Router::connect("/:lang/$controller", array('controller' => $controller, 'action' => 'index'));
    #    Router::connect("/:lang/$controller/edit/*", array('controller' => $controller, 'action' => 'edit'));
    }

    Router::connectNamed(array('p', 'c', 'e', 'id', 'page', 'sort', 'direction', 'drop', 'name', 'keyword', 'description', 'person_id', 'Testobject.person_id', 'location_id', 'invalid', 'project_id', 'entity_id', 'measuredate', 'measuretime', 'objecttype_id', 'attribute_id', 'wireOption_1', 'wireOption_2', 'wireOption_3', 'wireOption_4', 'testobject_ids', 'entity_ids', 'attribute_ids', 'file_type'));
    Router::connect('/:controller/:action');
    Router::connect('/:lang/:controller', array('action' => 'index'));
    Router::connect('/:lang/:controller/:action/*');
	
	// Make sure CakePHP parses CSV and Excel file requests correctly J.G. 2014-09-08
    Router::parseExtensions('csv');
