<?php

#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - jgremmels(at)bioinformatics.org
#############################################################################

class ProjectsController extends AppController {

	var $helpers = array ('Html','Form');
	var $name = 'Projects';
	var $uses = array('Project', 'Projectperson');

	function index() {
		$this->set('projects', $this->paginate('Project'));
	}

	function view($id = null) {
		$this->Project->id = $id;
		$this->set('project', $this->Project->read());
	}
	
	function add() {
		if (!empty($this->data)) {
			$this->Project->create();
			foreach ($this->data['Project']['person_id'] as $person) {
				$this->data['Person'][] = $person;
			}
			if ($this->Project->save($this->data)) {
				$this->Session->setFlash('Your project has been saved.');
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash('Unable to add your project.');
			}
		} else {
			$people = $this->Project->Person->find('list');
			$this->set(compact('people'));
		}
	}
	
	function delete($id) {
		if ($this->Project->delete($id)) {
			$this->Session->setFlash('The project with id: ' . $id . ' has been deleted.');
			$this->redirect(array('action' => 'index'));
		}
	}
	
	function edit($id = null) {
		$this->Project->id = $id;
		# prepare option lists one with people already associated with the current project and
		# one with all other people
		$people = $this->Project->query("SELECT DISTINCT CONCAT_WS(' ', p.name, p.lastname) as entire_name, p.id FROM people p");
		$people_list = Set::combine($people, '{n}.p.id', '{n}.0.entire_name');
		$people_in_project = $this->Project->query("SELECT DISTINCT CONCAT_WS(' ', p.name, p.lastname) as entire_name, p.id FROM people p
			INNER JOIN projectpeople prp ON prp.person_id = p.id
			WHERE prp.project_id = " . $id);
		$people_in_project_list = Set::combine($people_in_project, '{n}.p.id', '{n}.0.entire_name');
		$other_people = array();
		foreach ($people_list as $key => $value) {
			if (!in_array($value, $people_in_project_list)) {
				$other_people[$key] = $value;
			}
		}
		if (empty($this->data)) {
		# populate data fields and option lists
			$this->data = $this->Project->read();
			$this->set(compact('other_people', 'people_in_project_list'));
		} else {
			$persons_to_delete = $this->data['Projects']['persons_to_delete'];
			# remove persons to delete from the list of persons already in project
			if (!empty($persons_to_delete )) {
				foreach ($persons_to_delete  as $key => $value) {
					unset($people_in_project_list[$value]);
					#unset($people_in_project_list[$key]);
					$this->log($people_in_project_list, 'debug');
				}	
			}
			
			$persons_to_add = $this->data['Projects']['persons_to_add'];
			
			# remove all persons from current project (to add the new list later)
			unset($this->data['Person']);
			# add the remaining persons to the project data
			if (!empty($people_in_project_list)) {
				foreach ($people_in_project_list as $key => $value) {
					$this->data['Person'][] = $key;
				}
			}
			
			# add additional persons to the project data
			if (!empty($persons_to_add)) {
				foreach ($persons_to_add as $key => $value) {
					$this->data['Person'][] = $value;
				}
			}
			# save project with updated data
			if ($this->Project->save($this->data)) {
				$this->Session->setFlash('Your project has been updated.');
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash('Unable to update your project.');
			}
		}
	}

}