<?php
#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - jgremmels(at)bioinformatics.org
#############################################################################
class TestobjectsController extends AppController {

    var $name = 'Testobjects';
    var $helpers = array('Html', 'Form', 'FileUpload.FileUpload', 'Csv', 'Excel');
    var $components = array('RequestHandler');
    var $uses = array('Testobject','Testobjectparameter','Testobjectresult','Entity','Attribute','Ufile', 'Person', 'Project');
    var $error_msg = false;

	function search() {
			$person = $this->Session->read('Auth.Person');
			$wire_options = array('AND' => 'AND', 'OR' => 'OR');
        	if ($this->data) {
            	# do some whitelisting
            		$whitelist = array('testobject_id', 'multiplication', 'project_id', 'objecttype_id', 'entity_id', 'measuredate', 'measuretime','filename', 'invalid', 'attribute_id', 'Testobject.person_id', 'wireOption_1', 'wireOption_2', 'wireOption_3', 'wireOption_4', 'wireOption_entity', 'wireOption_attribute', 'wireOption_objecttype');
            		$passed_values = array();
            		foreach ($this->data['Testobject'] as $key => $values) {
                		if (in_array($key, $whitelist)) {
								if (is_array($values)) {
									$value_array = array();
									foreach ($values as $value) {
										$value_array[] = $value;
									}
									$passed_values[$key] = implode(',', $value_array);
								} else {
									$passed_values[$key] = $values;
								}
                		}
            		}
					$passed_values['Testobject.person_id'] = $person['id'];
            		if (!empty($passed_values)) {
            	    	$this->redirect(array_merge(array('action' => 'results'), $passed_values));
            		}
        	}
        	else {
				# offer options for project - we also need the project list for 
				# deciding which other options will be offered
				$project_result = $this->Testobject->Project->query("SELECT DISTINCT p.name, p.id FROM projects p INNER JOIN projectpeople prp ON prp.project_id = p.id WHERE prp.person_id = " . $person['id']. 
				" OR DATE_ADD(p.end_date, INTERVAL p.waiting_period YEAR) < NOW()");
				$projects = Set::combine($project_result, '{n}.p.id', '{n}.p.name');
				# this is for further queries
				$project_ids = Set::extract('/p/id', $project_result);
				$project_id_list = implode(',', $project_ids);
				
				$entity = $this->Testobject->query("SELECT DISTINCT E.name, E.id
				FROM testobjects TOBJ
				INNER JOIN testobjectparameters TOP on TOBJ.id = TOP.testobject_id
				INNER JOIN entities E ON E.id = TOP.entity_id
				WHERE TOBJ.person_id = " . $person['id'] . " 
				OR TOBJ.project_id IN (" . $project_id_list . ")
				ORDER BY E.name");
				$entities = Set::combine($entity, '{n}.E.id', '{n}.E.name');
				
				$objecttype = $this->Testobject->query("SELECT DISTINCT O.name, O.id
				FROM testobjects TOBJ
				INNER JOIN objecttypes O on TOBJ.objecttype_id = O.id
				WHERE TOBJ.person_id = " . $person['id'] . " 
				OR TOBJ.project_id IN (" . $project_id_list . ")
				ORDER BY O.name");
				$objecttypes = Set::combine($objecttype, '{n}.O.id', '{n}.O.name');
				
				$attribute = $this->Testobject->query("SELECT DISTINCT CONCAT_WS(' ', A.attribute, A.value) as attribute_value, A.id
				FROM testobjects TOBJ
				INNER JOIN testobjectparameters TOP on TOBJ.id = TOP.testobject_id
				INNER JOIN testobjectresults TOR on TOP.id = TOR.testobjectparameter_id
				INNER JOIN attributes A on A.id = TOR.attribute_id
				WHERE TOBJ.person_id = " . $person['id'] . " 
				OR TOBJ.project_id IN (" . $project_id_list . ")
				ORDER BY attribute_value");
				$attributes = Set::combine($attribute, '{n}.A.id', '{n}.0.attribute_value');
				
				$this->set(compact('entities', 'projects', 'person', 'objecttypes', 'attributes', 'wire_options'));	
        	}	
	}

	function index() {                
		$person = $this->Session->read('Auth.Person');
		$projects = $this->Testobject->query("SELECT DISTINCT tob.project_id FROM testobjects tob INNER JOIN projectpeople prp ON tob.project_id = prp.project_id INNER JOIN projects p ON p.id = prp.project_id WHERE prp.person_id = " . $person['id'] . 
				" OR DATE_ADD(p.end_date, INTERVAL p.waiting_period YEAR) < NOW()");
		
		$project_ids = Set::extract('/tob/project_id', $projects);
		
		$data = $this->paginate('Testobject', 
					array('OR' => array('Testobject.project_id' => $project_ids,
							'Testobject.person_id' => $person['id'])));
		
		$this->set('testobjects', $data);
        }

	function results() {
	
			$query_string = "SELECT `Testobject`.`id`, `Testobject`.`object_id`, `Testobject`.`multiplication`, `Testobject`.`objecttype_id`, `Testobject`.`measuredate`, 
			`Testobject`.`measuretime`, `Testobject`.`uploaddate`, `Testobject`.`uploadtime`, `Testobject`.`person_id`, `Testobject`.`invalid`, `Testobject`.`project_id`,
			`Testobject`.`ufile_id`, `Testobjectparameter`.`entity_id`
			FROM `testobjects` AS `Testobject` 
			INNER JOIN testobjectparameters AS `Testobjectparameter` 
			ON (`Testobject`.`id` = `Testobjectparameter`.`testobject_id`) 
			INNER JOIN testobjectresults AS `Testobjectresult` 
			ON (`Testobjectresult`.`testobjectparameter_id` = `Testobjectparameter`.`id`) 
			INNER JOIN objecttypes AS `Objecttype` 
			ON (`Objecttype`.`id` = `Testobject`.`objecttype_id`) 
			INNER JOIN ufiles AS `Ufile` 
			ON (`Ufile`.`id` = `Testobject`.`ufile_id`) 
			INNER JOIN projects AS `Project` 
			ON (`Project`.`id` = `Testobject`.`project_id`) 
			INNER JOIN people AS `Person` 
			ON (`Person`.`id` = `Testobject`.`person_id`)";

			$condition_string = "WHERE ";
			
			$variable_condition_count = 0;
			
			if (!empty ($this->params['named']['project_id'])) {
				$condition_string = $condition_string . ' project_id IN (' . $this->params['named']['project_id'] . ')';
				$variable_condition_count++;
			}
			if (!empty ($this->params['named']['entity_id'])) {
				if ($variable_condition_count > 0) {
					$condition_string = $condition_string . ' ' . $this->params['named']['wireOption_1'] . ' entity_id IN (' . $this->params['named']['entity_id'] . ')';
				} else {
					$condition_string = $condition_string . ' entity_id IN (' . $this->params['named']['entity_id'] . ')';
				}
				$variable_condition_count++;
				#these parameters will be needed later during export
				$this->set('entity_ids', $this->params['named']['entity_id']);
			}
			if (!empty ($this->params['named']['attribute_id'])) {
				if ($variable_condition_count > 0) {
					$condition_string = $condition_string . ' ' . $this->params['named']['wireOption_2'] . ' attribute_id IN (' . $this->params['named']['attribute_id'] . ')';
				} else {
					$condition_string = $condition_string . ' attribute_id IN (' . $this->params['named']['attribute_id'] . ')';
				}
				$variable_condition_count++;
				#these parameters will be needed later during export
				$this->set('attribute_ids', $this->params['named']['attribute_id']);
			}
			if (!empty ($this->params['named']['objecttype_id'])) {
				if ($variable_condition_count > 0) {
					$condition_string = $condition_string . ' ' . $this->params['named']['wireOption_3'] . ' objecttype_id IN (' . $this->params['named']['objecttype_id'] . ')';
				} else {
					$condition_string = $condition_string . ' objecttype_id IN (' . $this->params['named']['objecttype_id'] . ')';
				}
				$variable_condition_count++;
			}
			if ($variable_condition_count > 0) {
				$condition_string = $condition_string . ' ' . $this->params['named']['wireOption_4'] . ' Testobject.invalid = ' . $this->params['named']['invalid'];
			} else {
				$condition_string = $condition_string . ' Testobject.invalid = ' . $this->params['named']['invalid'];
			}
			if (!empty ($this->params['named']['Testobject.person_id'])) {
				$projects = $this->Testobject->query("SELECT DISTINCT tob.project_id FROM testobjects tob INNER JOIN projectpeople prp ON tob.project_id = prp.project_id INNER JOIN projects p ON p.id = prp.project_id WHERE prp.person_id = " . $this->params['named']['Testobject.person_id'] . 
				" OR DATE_ADD(p.end_date, INTERVAL p.waiting_period YEAR) < NOW()");
				$project_ids = Set::extract('/tob/project_id', $projects);
				if (!empty($project_ids)) {
					$project_id_list = implode(',', $project_ids);
					$condition_string = $condition_string . " AND (`Testobject`.`project_id` in (" . $project_id_list . ")" . " OR `Testobject` . `person_id` = " . $this->params['named']['Testobject.person_id'] .")";
				} else {
					$condition_string = $condition_string . " AND `Testobject` . `person_id` = " . $this->params['named']['Testobject.person_id'];
				}
			}	
			
			$condition_string = $condition_string . " GROUP BY `Testobject`.`id`";
			
			$testobjects = $this->Testobject->query($query_string . $condition_string);
			
			$testobject_ids = Set::extract('/Testobject/id', $testobjects);
			
			$this->paginate['Testobject'] = array('conditions' => array('Testobject.id' => array_unique($testobject_ids)));
			$this->set('testobject_ids', $testobject_ids);
			
			$this->set('testobjects', $this->paginate('Testobject'));
    }
	
	function view($id = null) {                
		if (!$id) {
        		$this->Session->setFlash(__('Invalid testobject', true));                        
			$this->redirect(array('action' => 'index'));
		}

        	$testobject = $this->Testobject->find('first', array('conditions' => array('Testobject.id' => $id)));                
		if ($testobject['Testobject']['invalid'] == 1) {                        
		$this->Session->setFlash(__('This entry has been marked as invalid!', true));
		}
        $this->set('testobject', $testobject);
		$testobjectresults = $this->Testobject->query("SELECT E.name, V.attribute, V.value,
								TOR.result
								FROM testobjectparameters TOP
								INNER JOIN entities E ON E.id = TOP.entity_id
								INNER JOIN testobjectresults TOR ON TOP.id = TOR.testobjectparameter_id
								INNER JOIN `attributes` V ON TOR.attribute_id = V.id
								WHERE TOP.testobject_id =".$id);
		$this->set('testobjectresults', $testobjectresults);
	}

	function export() {
		$conditions = array('Testobject.id' => explode(';', $this->params['named']['testobject_ids']));
		if (!empty($this->params['named']['entity_id'])) {
			$conditions['Testobjectparameter.entity_id'] = explode(',', $this->params['named']['entity_id']);
		}
		if (!empty($this->params['named']['attribute_id'])) {
			$conditions['Testobjectresult.attribute_id'] = explode(',', $this->params['named']['attribute_id']);
		}
			$this->Testobject->recursive = -1;
			
			$options['joins'] = array(
				 array(
						'table' => 'testobjectparameters',
						'alias' => 'Testobjectparameter',
						'type' => 'INNER',
						'conditions' => array(
						'Testobject.id = Testobjectparameter.testobject_id',
						),
					),
				array(
						'table' => 'testobjectresults',
						'alias' => 'Testobjectresult',
						'type' => 'INNER',
						'conditions' => array(
						'Testobjectresult.testobjectparameter_id = Testobjectparameter.id',
						),
					),
				array(
						'table' => 'entities',
						'alias' => 'Entity',
						'type' => 'INNER',
						'conditions' => array(
						'Testobjectparameter.entity_id = Entity.id',
						),
					),
				array(
						'table' => 'attributes',
						'alias' => 'Attribute',
						'type' => 'INNER',
						'conditions' => array(
						'Testobjectresult.attribute_id = Attribute.id'
						),
					),
				array(
						'table' => 'objecttypes',
						'alias' => 'Objecttype',
						'type' => 'INNER',
						'conditions' => array(
						'Objecttype.id = Testobject.objecttype_id',
						),
					),
				array(
						'table' => 'ufiles',
						'alias' => 'Ufile',
						'type' => 'INNER',
						'conditions' => array(
						'Ufile.id = Testobject.ufile_id',
						),
					),
				array(
						'table' => 'projects',
						'alias' => 'Project',
						'type' => 'INNER',
						'conditions' => array(
						'Project.id = Testobject.project_id',
						),
					),
				array(
						'table' => 'people',
						'alias' => 'Person',
						'type' => 'INNER',
						'conditions' => array(
						'Person.id = Testobject.person_id',
						),
					),
			);
			
		$options['conditions'] = $conditions;
		$options['order'] = array('Testobject.id');
		$options['fields'] = array('object_id', 'multiplication', 'measuredate', 'measuretime', 'Entity.name', 'Attribute.attribute', 'Attribute.value', 'Testobjectresult.result');
		
		$header_row = array("Object", "Multiplication", "Measuredate", "Measuretime", "Entity", "Attribute", "Value", "Result");
		$this->set('header_row', $header_row);
		$results = $this->Testobject->find('all', $options);
		$result_rows = array();
		
		foreach ($results as $result) {
			$row = array(
				$result['Testobject']['object_id'],
				$result['Testobject']['multiplication'],
				$result['Testobject']['measuredate'],
				$result['Testobject']['measuretime'],
				$result['Entity']['name'],
				$result['Attribute']['attribute'],
				$result['Attribute']['value'],
				$result['Testobjectresult']['result']
			);
			$result_rows[] = $row;
		}
	
		$this->set('result_rows', $result_rows);
		$this->layout = null;
		$this->autoLayout = false;
	}
	
	function upload() {
		$person = $this->Session->read('Auth.Person');
		$person_id = $person['id'];
		# offer options for date format
		$dateFormatOptions = array('yyyy-mm-dd' => 'yyyy-mm-dd', 'dd.mm.yyyy' => 'dd.mm.yyyy', 'dd.mm.yy' => 'dd.mm.yy', 'dd/mm/yyyy' => 'dd/mm/yyyy', 'mm/dd/yyyy' => 'mm/dd/yyyy');
		# offer options for project 
		$projects = $this->Testobject->Project->query("SELECT DISTINCT p.name, p.id FROM projects p LEFT JOIN projectpeople prp ON prp.project_id = p.id WHERE p.id = 1 OR prp.person_id = " . $person_id);
		$project_list = Set::combine($projects, '{n}.p.id', '{n}.p.name');
		$this->set(compact('dateFormatOptions', 'project_list'));
		
		if (!empty($this->data)) {
			$saved_testobject_ids = array();//collect testobjects already saved - mabe we have to delete them later in case of errors
			$saved_parameter_ids = array();//collect parameters already saved - mabe we have to delete them later in case of errors
			$saved_result_ids = array();//collect attributes already saved - mabe we have to delete them later in case of errors
				
			if (empty($this->data['File']['corrected'])) { # as we cannot validate this field, give an error when it's non-existing
                    $this->Session->setFlash(__('Please select an edited file to upload!', true));
					$this->log('No edited file selected.', 'protocol');
					return;
			}
			
			if (empty($this->data['File']['raw'])) { # as we cannot validate this field, give an error when it's non-existing
                    $this->Session->setFlash(__('Please select a raw file to upload!', true));
					$this->log('No raw file selected.', 'protocol');
					return;
			}
		
			$project_id = $this->data['Testobjects']['project_id'];
			
			# save corrected file to database
			$this->Ufile->create();
			$this->data['Ufile']['name'] = $this->data['File']['corrected']['name'];
			$this->data['Ufile']['file_type'] = 'corrected';
			$this->data['Ufile']['person_id'] = $person_id;
			if (! $this->Ufile->save($this->data)) {
					$this->Session->setFlash(
                     __('One or more files could not be saved.', true)
					);
				$this->log('Edited file could not be saved.', 'protocol');
                return;
            }
			# id will be needed later for relation to testobject table
			$this->data['File']['corrected']['id'] = $this->Ufile->getLastInsertID();
			# save raw file to database
			$this->Ufile->create();
			$this->data['Ufile']['name'] = $this->data['File']['raw']['name'];
			$this->data['Ufile']['file_type'] = 'raw';
			$this->data['Ufile']['person_id'] = $person_id;
			if (! $this->Ufile->save($this->data)) {
				# avoid inconsistent state - second file could not be saved, so we
				# delete also the first one
				$this->Ufile->delete($this->data['File']['corrected']['id']);
				$this->Session->setFlash(
                     __('One or more files could not be saved.', true)
                   );
				$this->log('Raw file could not be saved.', 'protocol');
                return;
            }
			# id will be needed later for relation to testobject table
			$this->data['File']['raw']['id'] = $this->Ufile->getLastInsertID();
		
			# check if a directory for the current user already exists and create it if not
			$filehandling_result = true;
			$user_dir_name = Configure::read('FileUpload.uploadDir') . $person['name'] . $person['id'];
			if (!file_exists($user_dir_name)) {
				$filehandling_result = mkdir($user_dir_name);
			}
			if ($filehandling_result == true) {
				# directory for the user is present or has been created
				# move the raw file to the user directory
				$filename_raw = Configure::read('FileUpload.uploadDir') . $person['name'] . $person['id'] . DS . $this->data['File']['raw']['name'];
				if(!move_uploaded_file($this->data['File']['raw']['tmp_name'], $filename_raw)) {
					$this->_delete_files_from_database();
					$this->_delete_files_from_repository();
					$this->log('Unable to move raw file to repository.', 'protocol');
				}
				# copy the corrected file to the user directory - the tmp file will
				# still be needed for parsing - so we cannot move here
				$filename_corrected = Configure::read('FileUpload.uploadDir') . $person['name'] . $person['id'] . DS . $this->data['File']['corrected']['name'];
				if (!copy($this->data['File']['corrected']['tmp_name'], $filename_corrected)) {
					$this->_delete_files_from_database();
					$this->_delete_files_from_repository();
					$this->log('Unable to move edited file to repository.', 'protocol');
				}
			} else {
				# User directory is not present and could not be created - so we cannot
				# proceed. We delete the database entries which have already been created
				# and return with an error message.
				$this->_delete_files_from_database();
				$this->Session->setFlash(
                     __('One or more files could not be saved.', true));
				$this->log('Error during saving of files.', 'protocol');
				return;
			}
		
			libxml_use_internal_errors(true); //for xml error reporting
			
			$xmlDoc = new DOMDocument();
			if (!$xmlDoc->load($this->data['File']['corrected']['tmp_name'])) {
				$this->Session->setFlash(__('Could not load XML document! - Please check if it is readable and contains correct XML!', true));
				$this->_delete_files_from_database();
				$this->_delete_files_from_repository();
				$this->log('Unable to load xml document.', 'protocol');
				return;
			}
			if ($this->data['File']['validate']) {
				if (!$xmlDoc->schemaValidate('xml/ResultFile.xsd')) {
					$xmlErrors = libxml_get_errors();
					$xmlErrorMessage = $xmlErrors[0]->message;
					$this->Session->setFlash(__("Document not valid: '$xmlErrorMessage'!", true));
					$this->_delete_files_from_database();
					$this->_delete_files_from_repository();
					$this->log('XML document not valid according to xml schema definition for result file.', 'protocol');
					return;
				}
			}
			$testPrograms = $xmlDoc->getElementsByTagName('TESTPROGRAM');
			if ($testPrograms->length == 0) {
				$this->Session->setFlash(__('Result file does not contain any TESTPROGRAM tag!', true));
				$this->_delete_files_from_database();
				$this->_delete_files_from_repository();
				$this->log('Document does not contain any TESTPROGRAM tag.', 'protocol');
				return;
			}
			if ($testPrograms->length > 1) { //MobilePhenotyper does not produce files with more than one TESTPROGRAM tag, but maybe we should allow it anyway?
				$this->Session->setFlash(__('More than one TESTPROGRAM tag in result file!', true));
				$this->_delete_files_from_database();
				$this->_delete_files_from_repository();
				$this->log('Document contains more than one TESTPROGRAM tag.', 'protocol');
				return;
			}

			$testprogram_id = 0;
			$objecttype_id = 7; //default type 'undefined'
			foreach ($testPrograms as $testProgram) {
				$testprogram_id = $testProgram->getAttribute('ID');
				$objecttype_id = $testProgram->getAttribute('OBJECT_TYPE');
				if ($objecttype_id == NULL || $objecttype_id == 0) { // we are reading an old result file
					$objecttype_id = 7;
				}
			}
			$testObjects = $xmlDoc->getElementsByTagName('TEST_OBJECT');
			if ($testObjects->length == 0) { // we are reading an old result file
				$testObjects = $xmlDoc->getElementsByTagName('SAMPLE');
			}
			if ($testObjects->length == 0) {
				$this->Session->setFlash(__('File does not contain any test object!', true));
				$this->_delete_files_from_database();
				$this->_delete_files_from_repository(n);
				$this->log('Result file does not contain any test object.', 'protocol');
				return;
			}
			$resultDatasetCount = 0;
			$successCount = 0;
			$errorCount = 0;
			
			
			foreach ($testObjects as $testObject) {
				$object_id = $testObject->getAttribute('ID');
				$multiplication = $testObject->getAttribute('MULTIPLICATION');
				$testObjectTimeStamp = $testObject->getAttribute('TIMESTAMP');
				$testObjectTimeAndDate = explode(" ", $testObjectTimeStamp);
				if (count($testObjectTimeAndDate) == 2) {
					$date = $testObjectTimeAndDate[0];
					$measuretime = $testObjectTimeAndDate[1];
				} else {
					$testObjectTimeAndDate = explode("T", $testObjectTimeStamp); //time and date according to ISO 8601
					$date = $testObjectTimeAndDate[0];
					$measuretime = $testObjectTimeAndDate[1];
				}
				$measuredate = $this->_convert_date($date);
				//$time = $this->_convert_time($time); // has to be implemented, but that seems not to be very urgent - MySQL can handle several time formats
				date_default_timezone_set('Europe/Berlin');
				$uploaddate = date('Y-m-d');
				$uploadtime = date('H:i:s');
				$ufile_id = $this->data['File']['corrected']['id'];
				$ufile_raw_id = $this->data['File']['raw']['id'];
				$testobject = $this->_save_testobject(compact('object_id', 'multiplication', 'objecttype_id', 'measuredate', 'measuretime', 'uploaddate', 'uploadtime', 'person_id', 'ufile_id', 'ufile_raw_id','project_id'));
				if ($testobject == false) {
					$this->_clean_up_saved_data($saved_testobject_ids);
					return;
				}
				$saved_testobject_ids[] = $testobject['Testobject']['id'];
				
				$parameters = $testObject->getElementsByTagName('PARAMETER');
				foreach ($parameters as $parameter) {
					$entity_id = $parameter->getAttribute('ID');
					$parameterChildren = $parameter->childNodes;  
					$testobject_id = $testobject['Testobject']['id'];                                                                                                             
					$testobjectparameter = $this->_save_testobject_parameter(compact('entity_id','testobject_id'));
					$testobjectParameterID = $testobjectparameter['Testobjectparameter']['id'];
					
					if ($testobjectParameterID == false) {
						$this->_look_up_parameter($parameter);// this function checks if a parameter is present in the database and writes a log message if not
						$this->_clean_up_saved_data($saved_testobject_ids);
						return;
					}
					$saved_parameter_ids[] = $testobjectParameterID;//collect parameters already saved - mabe we have to delete them later in case of errors
					
					foreach ($parameterChildren as $parameterChild) {
						if ($parameterChild->nodeType != 3 && $parameterChild->nodeName == 'ATTRIBUTE') {
							$result = $this->parseAttribute($parameterChild, $testobjectParameterID);
							$resultDatasetCount += $result["dataSetCount"];
							$successCount += $result["successCount"];
							$errorCount += $result["errorCount"];
							$saved_result_ids[] = $result["resultID"];
							if ($result["resultID"] == false) {
								$this->_look_up_attribute($parameterChild);
								$this->_clean_up_saved_data($saved_testobject_ids);
								return;
							}
						} else if ($parameterChild->nodeType != 3 && $parameterChild->nodeName == 'VALUE_GROUP') {
							$attributes = $parameterChild->getElementsByTagName('ATTRIBUTE');
							foreach ($attributes as $attribute) {
								$result = $this->parseAttribute($attribute, $testobjectParameterID);
								$resultDatasetCount += $result["dataSetCount"];
								$successCount += $result["successCount"];
								$errorCount += $result["errorCount"];
								$saved_result_ids[] = $result["resultID"];
								if ($result["resultID"] == false) {
									$this->_look_up_attribute($attribute);
									$this->_clean_up_saved_data($saved_testobject_ids);
									return;
								}
							}
						}
					}
				}
			}
			
			unlink($this->data['File']['corrected']['tmp_name']);
			
			$this->Session->setFlash("Parsed '$resultDatasetCount' data sets; success: $successCount (saved), errors: $errorCount");
		}
	}
	
	function parseAttribute($attribute,$testobjectparameter_id) {
		$attribute_id = $attribute->getAttribute('ID');
		$attributeChildren = $attribute->childNodes;
		$summary = array("dataSetCount" => 0, "successCount" => 0, "errorCount" => 0, "resultID" => 0);
		foreach ($attributeChildren as $attributeChild) {
			if ($attributeChild->nodeType != 3 && $attributeChild->nodeName == 'VALUE') {
				$summary["dataSetCount"] ++;
				$result = $attributeChild->nodeValue;
				$this->Testobjectresult->begin();
				$resultID = $this->_save_testobject_result(compact('testobjectparameter_id','attribute_id','result'));
				if($resultID) {
					$this->Testobjectresult->commit();
					$summary["successCount"] ++;
					$summary["resultID"] = $resultID;
				} else {
					$this->Testobjectresult->rollback();
					$summary["errorCount"] ++;
				}
			}
		}
		return $summary;
	}
	
	function invalidate($id = null) {
        if (!$this->RequestHandler->isAjax()) { # if no AJAX, it might be just a crawler
            $this->redirect('/', 500);
        }
        if (!$id) {
            $this->Session->setFlash(__('Invalid testobject', true));
            $this->redirect(array('action' => 'index'));
        }
        $testobject = $this->Testobject->read(null, $id);
        $testobject['Testobject']['invalid'] = $testobject['Testobject']['invalid'] == 1 ? 0 : 1;
        if ($this->Testobject->save($testobject)) {
        } else {
            $this->redirect('/', 500);
        }
    }
	
	function _look_up_parameter($parameter) {
		$parameterID = $parameter->getAttribute('ID');
		$parameterName = $parameter->getAttribute('NAME_E');
		$entities = $this->Entity->find('all', array('conditions' => array('id' => $parameterID)));
		if (empty($entities)) {
			$this->log("Entity with name '$parameterName' not in database!", 'protocol');
		}
	}
	
	function _look_up_attribute($attribute) {
		$attributeID = $attribute->getAttribute('ID');
		$attributeName = $attribute->getAttribute('NAME_E');
		$attributes = $this->Attribute->find('all', array('conditions' => array('id' => $attributeID)));
		if (empty($attributes)) {
			$this->log("Attribute with name '$attributeName' not in database!", 'protocol');
		}
	}
	
	function _delete_files_from_database() {
		$this->Ufile->delete($this->data['File']['corrected']['id']);
		$this->Ufile->delete($this->data['File']['raw']['id']);
		$pureNameRaw = $this->data['File']['raw']['name'];
		$pureNameCorrected = $this->data['File']['corrected']['name'];
		$this->log("Deleted raw file '$pureNameRaw' and edited file '$pureNameCorrected' from database.", 'protocol');
	}
	
	function _delete_files_from_repository() {
		$person = $this->Session->read('Auth.Person');
		$filename_raw = Configure::read('FileUpload.uploadDir') . $person['name'] . $person['id'] . DS . $this->data['File']['raw']['name'];
		$filename_corrected = Configure::read('FileUpload.uploadDir') . $person['name'] . $person['id'] . DS . $this->data['File']['corrected']['name'];
		unlink($filename_raw);
		unlink($filename_corrected);
		$pureNameRaw = $this->data['File']['raw']['name'];
		$pureNameCorrected = $this->data['File']['corrected']['name'];
		$this->log("Deleted raw file '$pureNameRaw' and edited file '$pureNameCorrected' from repository.", 'protocol');
	}
	
	function _clean_up_saved_data($testobjectIDs) {
		foreach ($testobjectIDs as $testobjectID) {
			$this->Testobject->delete($testobjectID);
			$this->log("Deleted testobject id '$testobjectID' - due to inconsistency error.", 'protocol');
		}
		$this->_delete_files_from_database();
		$this->_delete_files_from_repository();
	}
	
	function _save_testobject($tuples) {
		$this->Testobject->create();
		$testobject = $this->Testobject->save(array(
						'Testobject' => $tuples));# 'object_id', 'multiplication', 'objecttype_id', 'measuredate', 'measuretime', 'uploaddate', 'uploadtime', 'person_id', 'ufile_id', 'ufile_raw_id','project_id'

		if (empty($testobject)) {
			$this->Session->setFlash('Could not save test object data!');
			$this->Testobject->rollback();
			$this->error_msg = 'Failed to create testobject!';
			return false;
		} else {
			$testobject['Testobject']['id'] = $this->Testobject->getLastInsertID();
		}
		return $testobject;
	}	

	function _save_testobject_parameter($tuples) {
		$this->Testobjectparameter->create();
		$testobjectparameter = $this->Testobjectparameter->save(array(
						'Testobjectparameter' => $tuples));# 'entity_id', 'testobject_id'
		if (empty($testobjectparameter)) {
			$this->Session->setFlash('Could not save test object parameter data!');
			$this->Testobjectparameter->rollback();
			$this->error_msg = 'Failed to create testobject parameter!';
			return false;
		} else {
			$testobjectparameter['Testobjectparameter']['id'] = $this->Testobjectparameter->getLastInsertID();
		}
		return $testobjectparameter;
	}

	function _save_testobject_result($tuples) {
		$this->Testobjectresult->create();
		$testobjectresult = $this->Testobjectresult->save(array(
						'Testobjectresult' => $tuples));#('testobjectparameter_id','attribute_id','result')
		if (empty($testobjectresult)) {
			$this->Session->setFlash('Could not save test object result!');
			$this->Testobjectresult->rollback();
			$this->error_msg = 'Failed to create testobject result!';
			return false;
		} else {
			$testobjectresult['Testobjectresult']['id'] = $this->Testobjectresult->getLastInsertID();
		}
		return $testobjectresult;
	}	

    /**
     * Converts date according to the chosen date format to yyyy-mm-dd format.
     */
    function _convert_date($date) {
		if ($this->data['Testobjects']['dateFormat'] == 'dd/mm/yyyy') {
			list($day, $month, $year) = preg_split('/[^0-9]/', $date);
		} else if ($this->data['Testobjects']['dateFormat'] == 'mm/dd/yyyy') {
			list($month, $day, $year) = preg_split('/[^0-9]/', $date);
		} else if ($this->data['Testobjects']['dateFormat'] == 'dd.mm.yyyy') {
			list($day, $month, $year) = preg_split('.[^0-9].', $date);
		} else if ($this->data['Testobjects']['dateFormat'] == 'yyyy-mm-dd') {
			list($year, $month, $day) = preg_split('.[^0-9].', $date);
		} else {
			// maybe implement an automated parsing here
			return $date;
		}
		
        return "$year-$month-$day";
    }
	
	function _convert_time($time) {
		//TODO: implement
	}
}
?>
