<?php
#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - Kenny Billiau
# - jgremmels(at)bioinformatics.org
#############################################################################
class UfilekeywordsController extends AppController {

	var $name = 'Ufilekeywords';

	function index() {
		$this->Ufilekeyword->recursive = 0;
		$this->set('ufilekeywords', $this->paginate());
	}

	function view($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid ufilekeyword', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('ufilekeyword', $this->Ufilekeyword->read(null, $id));
	}

	function add() {
		if (!empty($this->data)) {
			$this->Ufilekeyword->create();
			if ($this->Ufilekeyword->save($this->data)) {
				$this->Session->setFlash(__('The ufilekeyword has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The ufilekeyword could not be saved. Please, try again.', true));
			}
		}
		$ufiles = $this->Ufilekeyword->Ufile->find('list');
		$keywords = $this->Ufilekeyword->Keyword->find('list');
		$this->set(compact('ufiles', 'keywords'));
	}

	function edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid ufilekeyword', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Ufilekeyword->save($this->data)) {
				$this->Session->setFlash(__('The ufilekeyword has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The ufilekeyword could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Ufilekeyword->read(null, $id);
		}
		$ufiles = $this->Ufilekeyword->Ufile->find('list');
		$keywords = $this->Ufilekeyword->Keyword->find('list');
		$this->set(compact('ufiles', 'keywords'));
	}

	function delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for ufilekeyword', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->Ufilekeyword->delete($id)) {
			$this->Session->setFlash(__('Ufilekeyword deleted', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(__('Ufilekeyword was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}
?>