<?php

#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - Kenny Billiau
# - jgremmels(at)bioinformatics.org
#############################################################################

class Attribute extends AppModel {
	var $name = 'Attribute';
	
	var $displayField = 'attribute_value';
	
	/*
	MultipleDisplayFields found at http://bakery.cakephp.org/articles/resshin/2008/11/15/multiple-display-field-3
	*/
	var $actsAs = array('MultipleDisplayFields' => array(
        'fields' => array('attribute', 'value'),
        'pattern' => '%s %s'
    )); 
	
	var $hasMany = array(
		'Testobjectresult' => array(
			'className' => 'Testobjectresult',
			'foreignKey' => 'attribute_id' 
		)
	);
	
	var $hasAndBelongsToMany = array(
		'Testobjectparameter' => array(
			'className' => 'Testobjectparameter',
			'associationForeignKey' => 'testobjectparameter_id',
			'foreign_key' => 'attribute_id',
			'joinTable' => 'Testobjectresults',
			'with' => 'Testobjectresult'
		)
	);
	
	
	/*var $validate = array(
		'attribute' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'value' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);*/

}
?>
