<?php

#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - Kenny Billiau
# - jgremmels(at)bioinformatics.org
#############################################################################

class Person extends AppModel {
	var $name = 'Person';
	
	var $displayField = 'entire_name';
	
	/*
	MultipleDisplayFields found at http://bakery.cakephp.org/articles/resshin/2008/11/15/multiple-display-field-3
	*/
	var $actsAs = array('MultipleDisplayFields' => array(
		'fields' => array('name', 'lastname'),
		'pattern' => '%s %s'
	));
	
	var $validate = array(
		'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
        'name' => array(
            'Please enter your name' => array(
                'rule' => 'notEmpty',
                'message' => 'Please enter your name',
            ),
        ),
		'lastname' => array(
			'Please enter your family name' => array(
				'rule' => 'notEmpty',
				'message' => 'Please enter your family name',
			),
		),
		'allowlogin' => array(
			'numeric' => array(
				'rule' => array('numeric'),
			),
		),
        'username' => array(
            'Please enter a username' => array(
                'rule' => 'notEmpty',
                'message' => 'Please enter a username',
            ),
            'The username has already been taken' => array(
                'rule' => 'isUnique',
                'message' => 'That username has already been taken',
            ),
        ),
        'password' => array(
            'The password must be between 5 and 15 characters' => array(
                'rule' => array('between', 5, 15),
                'message' => 'The password must be between 5 and 15 cahracters'
            ),
            'The passwords do not match' => array(
                'rule' => 'matchPasswords',
                'message' => 'Passwords do not match!',
            ),
        ),
	);
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	var $hasMany = array(
		'Ufile' => array(
			'className' => 'Ufile',
			'foreignKey' => 'person_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);
	
	var $hasAndBelongsToMany = array(
		'Project' => array(
			'className' => 'Project',
			'joinTable' => 'projectpeople',
			'foreignKey' => 'person_id',
			'associationForeignKey' => 'project_id'
		)
	);	

    function matchPasswords($data) {
        if ($data['password'] == $this->data['Person']['password_confirm']) {
            return true;
        }

        $this->invalidate('password_confirm','Passwords do not match!');
        return false;
    }

    function hashPasswords($data) {
        if (isset($this->data['Person']['password'])) {
            $this->data['Person']['password'] = Security::hash($this->data['Person']['password'], null, true);
            return $data;
        }

        return $data;
    }

    function beforeSave() {
        $this->hashPasswords(null);
        return true;
    }

}
?>
