<?php

#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - jgremmels(at)bioinformatics.org
#############################################################################

class Project extends AppModel {
	var $name = 'Project';
	#var $validate = array(
	#	'name' => array(
	#		'notempty' => array(
	#			'rule' => array('notempty'),
	#			//'message' => 'Your custom message here',
	#			//'allowEmpty' => false,
	#			//'required' => false,
	#			//'last' => false, // Stop validation after this rule
	#			//'on' => 'create', // Limit validation to 'create' or 'update' operations
	#		),
	#	),
	#);
	
	var $validate = array(
		'name' => array(
			'rule' => 'notEmpty',
			'message' => 'Please enter a name for the project'
		),
		'waiting_period' => array(
			'rule' => 'numeric',
			'message' => 'Please supply the waiting period in years'
		),
		'start_date' => array(
			'rule' => 'notEmpty',
			'message' => 'Please supply the start date'
		),
		'end_date' => array(
			'rule' => 'notEmpty',
			'message' => 'Please supply the end date'
		)
	);
	
	var $hasAndBelongsToMany = array(
		'Person' => array(
			'className' => 'Person',
			'joinTable' => 'projectpeople',
			'foreignKey' => 'project_id',
			'associationForeignKey' => 'person_id'
		)
	);
}
?>
