<?php

#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - jgremmels(at)bioinformatics.org
#############################################################################

class Testobject extends AppModel {
	var $name = 'testobject';
	#var $actsAs = array('Containable');
	var $belongsTo = array(
		'Person' => array(
			'className' => 'Person',
			'foreignKey' => 'person_id'
		),
		'Objecttype' => array(
			'className' => 'Objecttype',
			'foreignKey' => 'objecttype_id'
		),
		'Ufile' => array(
			'className' => 'Ufile',
			'foreignKey' => 'ufile_id'
		),
		'Ufile_Raw' => array(
			'className' => 'Ufile',
			'foreignKey' => 'ufile_raw_id'
		),
		'Project' => array(
			'className' => 'Project',
			'foreignKey' => 'project_id'
		),
	);
	var $hasMany = array(
		'Testobjectparameter' => array(
			'className' => 'Testobjectparameter',
			'foreignKey' => 'testobject_id'
		)
	);
	
	var $hasAndBelongsToMany = array(
		'Entity' => array(
			'className' => 'Entity',
			'joinTable' => 'Testobjectparameters',
			'foreignKey' => 'testobject_id',
			'associationForeignKey' => 'entity_id',
			'with' => 'Testobjectparameter'
		)
	);
}
?>
