<?php 

#############################################################################
#Phenotyper - a tool for collecting phenotyping data using mobile terminals
#Copyright (C) 2015,  jgremmels(at)bioinformatics.org
#
#Phenotyper is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
#Contributors:
# - jgremmels(at)bioinformatics.org
#############################################################################

/*
Source: http://bakery.cakephp.org/articles/thiagosf/2011/05/27/excelhelper
*/
class ExcelHelper extends AppHelper 
{
    var $filename = 'arquive';
    
    var $rows = array();
    
    var $header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?\>
<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"
 xmlns:x=\"urn:schemas-microsoft-com:office:excel\"
 xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"
 xmlns:html=\"http://www.w3.org/TR/REC-html40\">";
 
    var $footer = "</Workbook>";
    
    var $worksheet_title = "Table";
    
    function getHeaders () {
        header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
        header("Content-Disposition: inline; filename=\"" . $this->filename . ".xls\"");
    }
    
    function addRow ($data = array()) {
        foreach($data as $key => $value) {
            $data[$key] = "<Cell><Data ss:Type=\"String\"><![CDATA[" . $value . "]]></Data></Cell>\n";
        }
        
        $this->rows[] = $data;
    }
    
    function setTitle ($title) {
        $title = preg_replace ("/[\\\|:|\/|\?|\*|\[|\]]/", "", $title);
        $title = substr ($title, 0, 31);
        $this->worksheet_title = $title;
    }
    
    function render ($file = null) {
        $this->filename = ($file) ? $file : $this->filename;
        $this->getHeaders();
        
        $out = array();
        foreach($this->rows as $row) {
            $out[] = "<Row>\n" . implode('', $row) . "</Row>\n";
        }
        
        $data = implode("\n", $out);
        
        echo stripslashes ($this->header);
        echo "\n<Worksheet ss:Name=\"" . $this->worksheet_title . "\">\n<Table>\n";
        echo "<Column ss:Index=\"1\" ss:AutoFitWidth=\"0\" ss:Width=\"110\"/>\n";
        echo $data;
        echo "</Table>\n</Worksheet>\n";
        echo $this->footer;
    }
}
