<!--
Phenotyper - a tool for collecting phenotyping data using mobile terminals
Copyright (C) 2015,  jgremmels(at)bioinformatics.org

Phenotyper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>

Contributors:
 - Kenny Billiau
 - jgremmels(at)bioinformatics.org - initial API and implementation
-->
<?php echo $javascript->link('jquery-1.5.1.min', false); ?>
<?php echo $javascript->codeBlock('
    function strike(id) {
        $(".row"+id).toggleClass("invalid");
    }
'); ?>
<div class="people index">
<?php $currentUser = $this->Session->read('Auth.Person');?>
	<h2><?php __('People');?></h2>
	<table cellpadding="0" cellspacing="0">
	<tr>
			<th><?php echo $this->Paginator->sort(__('id', true), 'id');?></th>
			<th><?php echo $this->Paginator->sort(__('login', true),'username');?></th>
			<th><?php echo $this->Paginator->sort(__('first name', true), 'name');?></th>
			<th><?php echo $this->Paginator->sort(__('last name', true), 'lastname');?></th>
			<!--<th><?php echo $this->Paginator->sort('location_id');?></th>-->
			<th class="actions"><?php __('Actions');?></th>
	</tr>
	<?php
	$i = 0;
	foreach ($people as $person):
		$class = array('row'.$person['Person']['id']);
		$enable = 'Invalidate';
        if ($i++ % 2 == 0) {
            $class[] = 'altrow';
        }
        if ($person['Person']['allowlogin'] == 0) {
            $class[] = 'invalid';
			$enable = 'Validate';
        }
        $class = implode(' ', $class);
        $class = " class='$class'";
	?>
	<tr<?php echo $class;?>>
		<td><?php echo $person['Person']['id']; ?>&nbsp;</td>
		<td><?php echo $person['Person']['username']; ?>&nbsp;</td>
		<td><?php echo $person['Person']['name']; ?>&nbsp;</td>
		<td><?php echo $person['Person']['lastname']; ?>&nbsp;</td>
		<td class="actions">
			<?php echo $this->Html->link(__('View', true), array('action' => 'view', $person['Person']['id'])); ?>
			<?php echo $this->Html->link(__('Edit', true), array('action' => 'edit', $person['Person']['id'])); ?>
			<?php if ($person['Person']['id'] != $currentUser['id']) : echo $this->Ajax->link(
                __($enable, true),
                array('controller' => 'people', 'action' => 'invalidate', $person['Person']['id']),
                array('complete' => 'strike('.$person['Person']['id'].')'),
                sprintf(__('Are you sure you want to change validity of # %s?', true), $person['Person']['id'])
            ); endif;?>
		</td>
	</tr>
<?php endforeach; ?>
	</table>
	<p>
	<?php
	echo $this->Paginator->counter(array(
	'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
	));
	?>	</p>

	<div class="paging">
		<?php echo $this->Paginator->prev('<< ' . __('previous', true), array(), null, array('class'=>'disabled'));?>
	 | 	<?php echo $this->Paginator->numbers();?>
 |
		<?php echo $this->Paginator->next(__('next', true) . ' >>', array(), null, array('class' => 'disabled'));?>
	</div>
</div>
