
<!--
Phenotyper - a tool for collecting phenotyping data using mobile terminals
Copyright (C) 2015,  jgremmels(at)bioinformatics.org

Phenotyper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>

Contributors:
 - jgremmels(at)bioinformatics.org - initial API and implementation
-->

<?php echo $javascript->link('jquery-1.5.1.min', false); ?>
<?php echo $javascript->codeBlock('
    function strike(id) {
        $(".row"+id).toggleClass("invalid");
    }
'); ?>
<div class="phenotypes index">
	<h2><?php __('Test objects');?></h2>
	<table cellpadding="0" cellspacing="0">
	<tr>
			<th><?php echo $this->Paginator->sort('id');?></th>
                        <th><?php echo $this->Paginator->sort('object_id');?></th>
			<th><?php echo $this->Paginator->sort('multiplication');?></th> 
			<th><?php echo $this->Paginator->sort('project');?></th> 
			<th><?php echo $this->Paginator->sort('measuredate');?></th>
			<th><?php echo $this->Paginator->sort('measuretime');?></th>
	    <th class="actions"><?php __('Actions');?></th>
	</tr>
	<?php
	$i = 0;
	foreach ($testobjects as $testobject):
        $class = array('row'.$testobject['Testobject']['id']);
        if ($i++ % 2 == 0) {
            $class[] = 'altrow';
        }
        if ($testobject['Testobject']['invalid'] == 1) {
            $class[] = 'invalid';
        }
        $class = implode(' ', $class);
        $class = " class='$class'";
	?>
	<tr<?php echo $class;?>>
		<td><?php echo $testobject['Testobject']['id']; ?>&nbsp;</td>
		<td><?php echo $testobject['Testobject']['object_id'];?></td>
 		<td><?php echo $testobject['Testobject']['multiplication'];?></td>
		<td><?php echo $testobject['Project']['name']?></td>
		<td><?php echo $testobject['Testobject']['measuredate']; ?>&nbsp;</td>
		<td><?php echo $testobject['Testobject']['measuretime']; ?>&nbsp;</td>
		<td class="actions">
            <?php echo $this->Ajax->link(
                __('Invalidate', true),
                array('controller' => 'testobjects', 'action' => 'invalidate', $testobject['Testobject']['id']),
                array('complete' => 'strike('.$testobject['Testobject']['id'].')'),
                sprintf(__('Are you sure you want to invalidate # %s?', true), $testobject['Testobject']['id'])
            ); ?>
			<?php echo $this->Html->link(__('View', true), array('action' => 'view', $testobject['Testobject']['id'])); ?>
            <?php if ($this->Session->check('user')): ?>
			<?php echo $this->Html->link(__('Edit', true), array('action' => 'edit', $testobject['Testobject']['id'])); ?>
			<?php echo $this->Html->link(__('Delete', true), array('action' => 'delete', $testobject['Testobject']['id']), null, sprintf(__('Are you sure you want to delete # %s?', true), $testobject['Testobject']['id'])); ?>
            <?php endif; ?>
		</td>
	</tr>
<?php endforeach; ?>
	</table>
	<p>
	<?php
	echo $this->Paginator->counter(array(
	'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
	));
	?>	</p>

	<div class="paging">
		<?php echo $this->Paginator->prev('<< ' . __('previous', true), array(), null, array('class'=>'disabled'));?>
	 | 	<?php echo $this->Paginator->numbers();?>
 |
		<?php echo $this->Paginator->next(__('next', true) . ' >>', array(), null, array('class' => 'disabled'));?>
	</div>
</div>
