/*
 * Decompiled with CFR 0.152.
 */
package mpimp.encrypter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class Encrypter {
    public static void main(String[] args) {
        if (args.length == 3) {
            if (args[2].equalsIgnoreCase("encrypt")) {
                try {
                    String encryptedString = Encrypter.encrypt(args[0], args[1]);
                    System.out.println("Clear text string: " + args[0] + "\nEncrypted string: " + encryptedString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (args[2].equalsIgnoreCase("decrypt")) {
                try {
                    String decryptedString = Encrypter.decrypt(args[0], args[1]);
                    System.out.println("Encrypted string: " + args[0] + "\nClear text string: " + decryptedString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Usage:\nEncrypter.jar <clear text string|encrypted string> <key file path> <encrypt|decrypt>");
            }
        } else if (args.length == 1) {
            Encrypter.generateKey(args[0]);
        } else {
            System.out.println("Usage:\nEncrypter.jar <clear text string|encrypted string> <key file path> <encrypt|decrypt>");
        }
    }

    public static String encrypt(String clearTextString, String keyFilePath) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, Encrypter.loadKeyFromFile(keyFilePath));
        String encryptedString = "";
        byte[] utf8 = clearTextString.getBytes("UTF8");
        byte[] enc = cipher.doFinal(utf8);
        encryptedString = Base64.encodeBase64String((byte[])enc);
        return encryptedString;
    }

    public static String decrypt(String encryptedString, String keyFilePath) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, Encrypter.loadKeyFromFile(keyFilePath));
        String decryptedString = "";
        byte[] dec = Base64.decodeBase64((String)encryptedString);
        byte[] utf8 = cipher.doFinal(dec);
        decryptedString = new String(utf8, "UTF8");
        return decryptedString;
    }

    public static void generateKey(String keyFilePath) {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom random = new SecureRandom();
            keygen.init(random);
            SecretKey key = keygen.generateKey();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(keyFilePath));
            out.writeObject(key);
            out.close();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static SecretKey loadKeyFromFile(String keyfileName) throws Exception {
        SecretKey key = null;
        ObjectInputStream keyIn = new ObjectInputStream(new FileInputStream(keyfileName));
        key = (SecretKey)keyIn.readObject();
        keyIn.close();
        return key;
    }
}

