%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_f2plot(DSNL,cxyFILE,Cnd,CndWidth,CndRGB,tTestWidth,tTestRGB) plots
%: two average ERPs and Student's t-test of the difference ERP.
%:
%: The job constants are loaded from './_A_const.mat' <tcwt_help prm2mat>.
%: Then, the function iterates over DSNL reading data from the INPUT FILES,
%: computing ERP averages corresponding to two different experimental
%: conditions and Student's t-test of the difference ERP, plotting the
%: results, and saving the plots to the corresponding OUTPUT PDF FILES.
%:
%: FUNCTION ARGUMENTS
%:
%:   DSNL        DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%:
%:   cxyFILE     The basename (without the path and the '.m' extension)
%:               of the file, containing the X-Y-coordinates of
%:               the channels in the subplot array <tcwt_help cxy>.
%:
%:   Cnd      =  [cnd1; cnd2]   Experimental conditions <tcwt_help t2f>
%:
%:   CndWidth =  [width1; width2]   Line widths of the average ERP curves
%:               corresponding to cnd1 and cnd2 respectively
%:
%:   CndRGB   =  [R1 G1 B1; R2 G2 B2]  Line colors (defined as RGB vectors) of
%:               the average ERPs corresponding to cnd1 and cnd2 respectively
%:
%:   tTestWidth  Line width of the t-test curve
%:
%:   tTestRGB    Line color (defined as an RGB vector) of the t-test curve
%:
%: INPUT FILES               INPUT VARIABLES
%:
%:   ./DSN.f.mat               Verp,CIerp <tcwt_help t2f>
%:   ./DSN.pc.mat              pcTerp <tcwt_help f2pc>
%:   ./DSN.ri2.mat             RIerp <tcwt_help t2f>
%:
%: OUTPUT FILES              OUTPUT VARIABLES
%:
%:   ./DSN.plot.avg.jpg        average ERP plot as JPG
%:   ./DSN.plot.ttest.jpg      Student's t-test plot as JPG
%:
%: Note that ERP averaging is done after PCA filtering and double outlier
%: rejection: first, regardless of experimental conditions, and second,
%: performed on each condition separately. The t-test is also done with
%: the corresponding ERP subsamples, which means that it is biased and
%: should be used only for visualization purposes.

%       10        20        30        40        50        60        70        80

function tcwt_f2plot(dsnl,cxyFILE,Cnd,CndWidth,CndRGB,tTestWidth,tTestRGB);

rin='2';
gExt='.jpg';

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_f2plot: Plot Average ERPs and t-Test\n')];
O=[O,tcwt_txt('-----------------------------------------------------\n')];

load('_A_const.mat');
SSmaxN = NcwMax;
eval(cxyFILE);
for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 load([dsn '.f.mat']);
 load([dsn '.pc.mat']);
 load([dsn '.ri' rin '.mat']);

 Sout=logical(RIerp(:,1));
 Verp=Verp(~Sout,:);
 RIerp=RIerp(~Sout,:);
 Scnd1 = RIerp(:,2)==Cnd(1);
 Scnd2 = RIerp(:,2)==Cnd(2);
 N=[sum(Scnd1); sum(Scnd2)];

 Verp = Verp*(pcTerp*pcTerp');
 avgVerp = [ mean(Verp(Scnd1,:)) ; mean(Verp(Scnd2,:)) ];

 [avgVerp,avgCIerp] = tcwt_timedomain(avgVerp,CIerp,Time,tTerp);

 Ntr = size(Verp,1);
 VerpSS = 0;
 for nn=1:ceil(Ntr/SSmaxN)
  nnVerp = Verp( (nn-1)*SSmaxN+1 : min(nn*SSmaxN, Ntr), : );
  nnVerp = tcwt_timedomain(nnVerp,CIerp,Time,tTerp);
  nnVerp = nnVerp.*nnVerp;
  if (size(nnVerp,1)>1) nnVerp = sum(nnVerp); end
 VerpSS = VerpSS + nnVerp;
 end
 ttestVerp = tcwt_student2(avgVerp,N,VerpSS);

 fh = tcwt_ploterp(avgVerp,avgCIerp,ChannelList,ChannelXY,CndWidth,CndRGB);

 set(gcf,'PaperUnits','centimeters');
 set(gcf,'PaperSize',[29.7 21]);
 set(gcf,'PaperPosition',[0 0 29.7 21]);

 saveas(fh,[dsn '.plot.avg.' num2str(Cnd(1),'%u') '.' num2str(Cnd(2),'%u') gExt]);
 close
 O=[O,tcwt_txt([dsn '.plot.avg.' num2str(Cnd(1),'%u') '.' num2str(Cnd(2),'%u') gExt '\n'])];

 fh = tcwt_ploterp(ttestVerp,avgCIerp,ChannelList,ChannelXY,tTestWidth,tTestRGB);

 set(gcf,'PaperUnits','centimeters');
 set(gcf,'PaperSize',[29.7 21]);
 set(gcf,'PaperPosition',[0 0 29.7 21]);

 saveas(fh,[dsn '.plot.ttest.' num2str(Cnd(1),'%u') '.' num2str(Cnd(2),'%u') gExt]);
 close
 O=[O,tcwt_txt([dsn '.plot.ttest.' num2str(Cnd(1),'%u') '.' num2str(Cnd(2),'%u') gExt '\n'])];
end
O=[O,tcwt_txt('_____________________________________________________\n')];


