%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_ld2plot(DSNL,cxyFILE,normC,LineWidth,ColorRGB) plots the normalized
%: Linear Discriminant Function (LDF).
%:
%: The job constants are loaded from './_A_const.mat' <tcwt_help prm2mat>.
%: Then, the function iterates over DSNL plotting the Linear Discriminant
%: Functions (LDFs) <tcwt_help x2ld> stored in the INPUT FILES and saving
%: the plots to the corresponding OUTPUT PDF FILES.
%:
%: FUNCTION ARGUMENTS
%:
%:   DSNL        DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%:
%:   cxyFILE     The basename (without the path and the '.m' extension)
%:               of the file, containing the X-Y-coordinates of
%:               the channels in the subplot array <tcwt_help cxy>.
%:
%:   normC       A coefficient with which the LDF is multiplied
%:               for better visualization (can be negative).
%:
%:   LineWidth   The line width
%:
%:   ColorRGB  = [R, G, B]   The line color defined as an RGB vector
%:
%: INPUT FILES          INPUT VARIABLES
%:
%:   ./DSN.ld.mat         Nxtr,sdTerp,ldTerp,ldMean,CIerp <tcwt_help x2ld>
%:
%: OUTPUT FILES         OUTPUT VARIABLES
%:
%:   ./DSN.plot.ld.jpg   ldTerp plot as JPG

%       10        20        30        40        50        60        70        80

function tcwt_ld2plot(dsnl,cxyFILE,normC,LineWidth,ColorRGB);

gExt='.jpg';

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_ld2plot: Plot Linear Discriminant Function (LDF)\n')];
O=[O,tcwt_txt('-----------------------------------------------------\n')];

load('_A_const.mat');
eval(cxyFILE);
for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 load([dsn '.ld.mat']);

 [ldTerp,CIerp] = tcwt_timedomain(ldTerp',CIerp,Time,tTerp);
 ldTerp = normC*ldTerp/norm(ldTerp,Inf);

 fh = tcwt_ploterp(ldTerp,CIerp,ChannelList,ChannelXY,LineWidth,ColorRGB);

 set(gcf,'PaperUnits','centimeters');
 set(gcf,'PaperSize',[29.7 21]);
 set(gcf,'PaperPosition',[0 0 29.7 21]);

 saveas(fh,[dsn '.plot.ld' gExt]);
 close
 O=[O,tcwt_txt(['%s.plot.ld' gExt '\n'] ,dsn)];
end
O=[O,tcwt_txt('_____________________________________________________\n')];
