%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_x2ld(is1out,DSNL,Cnd,Npc,sdAlpha) Principal Component Analysis
%: (PCA), from the t-CWT features, Step-Down Selection of components, and
%: computation of the Linear Discriminant Function (LDF) <tcwt_help math>
%:
%: The function iterates over DSNL reading and processing data from
%: the INPUT FILES and saving results to the corresponding OUTPUT FILES.
%: If is1out = 1, a second DSNLpool of 1out index names <tcwt_help ri2ri1out>
%: is created at each step, and the function iterates throuh DSNLpool.
%:
%: FUNCTION ARGUMENTS
%:
%:   is1out = 0 or 1; defines whether 1out indexes are used (see below)
%:
%:   DSNL     DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%:
%:   Cnd      List of exactly 2 experimental conditions <tcwt_help t2f>
%:
%:   Npc      PCA criterion for the step-down test <tcwt_help f2pc>
%:
%:   sdAlpha  Overall alpha level for the step-down test <tcwt_help math>
%:
%: INPUT FILES               INPUT VARIABLES
%:
%:   ./DSN.f.mat              Verp,CIerp <tcwt_help t2f>
%:   ./DSN.x.mat              xCIerp,xTerp <tcwt_help f2x>
%:   ./DSN.ri1.mat            RIerp, DSNLpool <tcwt_help f2pool>
%:   ./DSN.ri2.mat            RIerp, DSNLpool
%:
%:  If is1out == 1
%:
%:   ./DSNp.out.DSN.x.mat     xCIerp,xTerp
%:   ./DSNp.out.DSN.ri2.mat   RIerp
%:
%: DSNp is taken from DSNLpool.
%:
%: OUTPUT FILES              OUTPUT VARIABLES
%:
%:   ./DSN.ld.mat             Nxtr,sdTerp,ldTerp,ldMean,CIerp
%:
%:   If is1out == 1
%:
%:   ./DSNp.out.DSN.ld.mat    Nxtr,sdTerp,ldTerp,ldMean,CIerp
%:
%: OUTPUT VARIABLES
%:
%:   Nxtr     The number of t-CWT extrema (features)
%:
%:   sdTerp   Transformation matrix from the frequency domain ERP Verp
%:            to the principal components obtained from the t-CWT features
%:            and reduced by step-down selection sdVerp = Verp * sdTerp
%:
%:   ldTerp   Frequency domain LDF obtained from sdVerp. The scalar product
%:            with the frequency domain ERP Verp is simply: Verp * ldTerp
%:
%:   ldMean = (1/2) * ( mean(Verp1) + mean(Verp2) ) * ldTerp
%:            Verp1 and Verp2 are the ERP samples corresponding to the
%:            experimental conditions Cnd(1) and Cnd(2), respectively.
%:
%:   CIerp    ERP column index in the frequency domain <tcwt_help t2f>

%       10        20        30        40        50        60        70        80

function tcwt_x2ld(is1out,dsnl,Cnd,Npc,sdAlpha);

rin1='1';
rin2='2';

if (Npc==round(Npc)) NpcStr = sprintf('%u',Npc); else NpcStr = sprintf('%f',Npc); end

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_x2ld: PCA-Step-Down Selection and Linear Discriminant Analysis (LDA)\n')];
O=[O,tcwt_txt('-------------------------------------------------------------------------\n')];
O=[O,tcwt_txt('PCA criterion = %s, Step-Down Alpha = %f\n', NpcStr,sdAlpha)];
O=[O,tcwt_txt('-------------------------------------------------------------------------\n')];

for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 load([dsn '.f.mat']);
 load([dsn '.ri' rin1 '.mat']);

 if is1out
  dsnl_ri = tcwt_dsnl2xdsnl('',DSNLpool,['.out.' dsn]);
 else
  dsnl_ri = dsn;
 end

 for n_ri=1:size(dsnl_ri,1)
  dsn_ri=dsnl_ri(n_ri,:);
  load([dsn_ri '.x.mat']);
  load([dsn_ri '.ri' rin2 '.mat']);

  Sout = logical(RIerp(:,1));
  Scnd1 = RIerp(~Sout,2)==Cnd(1); Scnd2 = RIerp(~Sout,2)==Cnd(2);
  xVerp = Verp(~Sout,:)*xTerp;
  Nxtr = size(xTerp,2);

  [xVerp,pcTerp] = tcwt_stepdown(xVerp,Scnd1,Scnd2,Npc,sdAlpha);
  [ldTerp,ldMean] = tcwt_ldt(xVerp,Scnd1,Scnd2);
  sdTerp = xTerp*pcTerp;
  ldTerp = sdTerp*ldTerp;

  save([dsn_ri '.ld.mat'],'Nxtr','sdTerp','ldTerp','ldMean','CIerp');
  O=[O,tcwt_txt('%s: extrema: %6u,  selected components: %3u\n',dsn,Nxtr,size(sdTerp,2))];
 end
end
O=[O,tcwt_txt('_________________________________________________________________________\n')];


