%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Computes some job constants

function [Time,fullTime,NtimePt,a2dR] = tcwt_erptime(NtimePt,a2dR,Epoch,Window,BaseLine);

if ( ~isscalar(NtimePt) || ~isnumeric(NtimePt) || ~isreal(NtimePt) || NtimePt~=round(NtimePt))
 error('Job input parameter NtimePt must be a single real integer number.');
end

if ( ~isscalar(a2dR) || ~isnumeric(a2dR) || ~isreal(a2dR) || a2dR~=round(a2dR))
 error('Job input parameter a2dR must be a single real integer number.');
end

if (~isrow(Epoch) || length(Epoch)~=2 || ~isnumeric(Epoch) || ~isreal(Epoch) || ...
   Epoch(1)>=Epoch(2))
 error('Job input parameter Epoch must be a row of 2 real numbers: [t1 t2], t1 < t2.');
end

if ( ~isrow(Window) || length(Window)~=2 || ~isnumeric(Window) || ~isreal(Window) || ...
   Window(1)>=Window(2))
 error('Job input parameter Window must be a row of 2 real numbers: [t1 t2], t1 < t2.');
end

if ( ~isrow(BaseLine) || length(BaseLine)~=2 || ~isnumeric(BaseLine) || ~isreal(BaseLine) || ...
   BaseLine(1)>=BaseLine(2))
 error('Job input parameter BaseLine must be a row of 2 real numbers: [t1 t2], t1 < t2.');
end

if ( Window(1)<Epoch(1) || Window(2)>Epoch(2) || BaseLine(1)<Epoch(1) || BaseLine(2)>Epoch(2) )
 error('All values of job input parameters Window and BaseLine must be within the Epoch.');
end

if ( a2dR > 0 )
 NtimePt0 = floor(a2dR*(Epoch(2)-Epoch(1)));
 if ( NtimePt > 0 && NtimePt ~= NtimePt0)
  error('Job input parameters a2dR, NtimePt and Epoch do not fit together.');
 end
 NtimePt = NtimePt0;
elseif ( NtimePt > 0 )
 a2dR = ceil(NtimePt/(Epoch(2)-Epoch(1)));
else
  error('At least one of the job input parameters a2dR, NtimePt must be positive.');
end

fullTime = Epoch(1):1/a2dR:Epoch(2);
fullTime = fullTime(1:NtimePt);
Time = fullTime( fullTime>=Window(1) & fullTime<Window(2) );


