%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Continuous Wavelet Transform (CWT) from the frequency domain

function [cwTerp,logGrid] = tcwt_cwtdft(N,Nfreq,logGridR,tTerp,Ti,Tf);

minScale=N/ceil(Nfreq); maxScale=4*N;
logGrid = tcwt_loggrid(N+1,minScale,maxScale,logGridR);
cwTerp = tcwt_loggridcwt(tTerp,logGrid);
logGrid = (Tf-Ti)*logGrid/N;
logGrid(2,:) = Ti + logGrid(2,:);


