%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Continuous Wavelet Transform of X on the log grid logGrid

function cwtX = tcwt_loggridcwt(X,logGrid);

[Nv,Nt]=size(X);
t=0:(Nt-1);
cwtX=[];
for n=1:Nv
 tcwt_txt('tcwt_loggridcwt: Computing CWT for DFT component %3u of %3u\n', n, Nv);
 x=X(n,:);
 C=[];
 for sl=unique(logGrid(1,:)),
   tl=logGrid(2,logGrid(1,:)==sl);
   mh=tcwt_mexhat(sl);
%  eval(['mh=' wvlname '(sl);']);
   Nmh=(length(mh)-1)/2;
   dC=conv(mh,x);
   dC=dC(Nmh+1:Nmh+Nt)/sqrt(sl/4);
   dC=interp1(t,dC,tl,'spline');
   C=[C,dC];
 end
 cwtX=[cwtX;C];
end


