%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_help        invoked with no arguments displays this text;
%: tcwt_help main   also displays this text;
%: tcwt_help help   does the same.
%: tcwt_help NAME   displays help text for the script or function tcwt_NAME.
%:
%: t-CWT version 2.01
%:
%: Copyright (C) 2003-2015 Vladimir Bostanov <http://tcwt.de/>
%:
%: t-CWT comes with ABSOLUTELY NO WARRANTY. This is free software, and you
%: are welcome to redistribute it under certain conditions. See the file
%: tcwt_use.m <tcwt_help use>. For more details, see the file COPYING or
%: tcwt_gpl.m <tcwt_help gpl>. If not, see <http://www.gnu.org/licenses/>.
%:
%: t-CWT is a method for multivariate statistical assessment of event-related
%: brain potentials (ERP). The help texts describe the t-CWT software. The
%: underlying mathematical algorithm is described elsewhere <tcwt_help math>.
%:
%: DOWNLOAD, INSTALLATION AND CONFIGURATION: <tcwt_help install>
%:
%: GETTING STARTED: <tcwt_help intro>

%       10        20        30        40        50        60        70        80

function tcwt_help(tcwtNAME);

if (nargin==0)
 tcwtNAME = 'tcwt_help';
elseif ( nargin==1 && ischar(tcwtNAME) && isrow(tcwtNAME) )
 if ( strcmp(tcwtNAME,'main') )
  tcwtNAME = 'tcwt_help';
 elseif (length(tcwtNAME)<5 || ~strcmp(tcwtNAME(1:5),'tcwt_') )
  tcwtNAME = ['tcwt_' tcwtNAME];
 end
else
 error('tcwt_help must be invoked either with no arguments or with a single argument.');
end

tCWTfile = which(tcwtNAME);

if isempty(tCWTfile)
 disp([tcwtNAME '.m not found.']);
 return
end

disp(' ');

mfid = fopen(tCWTfile,'r');
cLine = fgetl(mfid);
while ischar(cLine)
 if ( length(cLine)>2 && strcmp(cLine(1:2),'%:') )
  disp(cLine(3:length(cLine)));
 elseif ( length(cLine)==2 && strcmp(cLine(1:2),'%:') )
  disp(' ');
 end
 cLine = fgetl(mfid);
end
fclose(mfid);

if ( ~strcmp(tcwtNAME,'tcwt_use') &&  ~strcmp(tcwtNAME,'tcwt_gpl')) 
 disp(' ');
 disp(' EXAMPLE: <tcwt_help example>');
 disp(' ');
 disp(' t-CWT Copyright (C) 2003-2015 Vladimir Bostanov ');
 disp(' ');
end