%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_latex generates a LaTeX table from the results
%: produced by tcwt_f2stats and tcwt_f2holdout through
%: the assessment of the example data <tcwt_help example>.

LaTeXalpha = 0.05;
statSig = ' *';

if LaTeXaPriori statsExt = 'A'; else statsExt = '0'; end

O='';
O=[O,sprintf('%s\n', '\documentclass[10pt]{article}')];
O=[O,sprintf('%s\n', '\usepackage{amsmath}')];
O=[O,sprintf('%s\n', '\setlength{\oddsidemargin}{0cm}')];

O=[O,sprintf('%s\n', '\newcommand{\xmbi}[3]')];
O=[O,sprintf('%s\n', '{\textrm{\textbf{\emph{#1}}}${}_{')];
O=[O,sprintf('%s\n', '\text{\!\textrm{\textbf{\emph{#2}}}}}^{')];
O=[O,sprintf('%s\n', '\text{\textrm{\textbf{#3}}}}$}')];

O=[O,sprintf('%s\n', '\pagestyle{empty}')];
O=[O,sprintf('%s\n', '\begin{document}')];
O=[O,sprintf('%s\n', '\begin{sffamily}\small')];

O=[O,sprintf('%s\n', '\begin{tabular}{@{\extracolsep{-2.5mm}}rlr')];
O=[O,sprintf('%s\n', '@{\hspace{3.5mm}}rrrr@{\hspace{2.5mm}}lr')];
O=[O,sprintf('%s\n', '@{\hspace{3.5mm}}rrrr@{\hspace{2.5mm}}lr')];
O=[O,sprintf('%s\n', '@{\hspace{3.5mm}}rrrr@{\hspace{2.5mm}}lrrr')];
O=[O,sprintf('%s\n', '@{\hspace{2.5mm}}l@{\hspace{1mm}}r@{\hspace{2.5mm}}l}')];
O=[O,sprintf('%s\n', '\hline')];

O=[O,sprintf('%s\n', '&&\multicolumn{5}{c}{\textbf{Group Hold-Out}}')];
O=[O,sprintf('%s\n', '&&\multicolumn{5}{c}{\textbf{Individual Biased}}')];
O=[O,sprintf('%s\n', '&&\multicolumn{5}{c}{\textbf{Individual Split-Half}}')];
O=[O,sprintf('%s\n', '&&\multicolumn{3}{c}{\textbf{Ind.\,Hold-Out}}')];
O=[O,sprintf('%s\n', '&\multicolumn{2}{r}{\textbf{\footnotesize\hspace{-0.3em}Hotelling}}\\')];

O=[O,sprintf('%s\n', '\footnotesize\textbf{No.}&\footnotesize\textbf{ID}')];
O=[O,sprintf('%s\n', '&\footnotesize\xmbi{N}{\!X}{}&\footnotesize\xmbi{N}{\!P}{}\!\!')];
O=[O,sprintf('%s\n', '&\textbf{std}&\textbf{dev\,}&\textbf{tot~}&')];
O=[O,sprintf('%s\n', '&\footnotesize\xmbi{N}{\!X}{}&\footnotesize\xmbi{N}{\!P}{}\!\!')];
O=[O,sprintf('%s\n', '&\textbf{std}&\textbf{dev\,}&\textbf{tot~}&')];
O=[O,sprintf('%s\n', '&\footnotesize\xmbi{N}{\!X}{}&\footnotesize\xmbi{N}{\!P}{}\!\!')];
O=[O,sprintf('%s\n', '&\textbf{std}&\textbf{dev\,}&\textbf{tot~}&')];
O=[O,sprintf('%s\n', '&\textbf{std}&\textbf{dev\,}&\textbf{tot~}&')];
O=[O,sprintf('%s\n', '\multicolumn{2}{r}{\xmbi{p}{}{}-\textbf{value}}\\')];
O=[O,sprintf('%s\n', '\hline')];

load(['_all.1dataset.out.stats' statsExt '.mat']);

DS = dsnl;

NxG = NtCWTextr;
NsG = NsdPC;
EpG = ErrP100;
PbG = Pbinomi;
PbG = PbG<LaTeXalpha;
SbG = statSig(PbG+1);
PbG = sum(PbG);
ApG = ErrP100Sum;

load(['_all.biased.stats' statsExt '.mat']);

NxB = NtCWTextr;
NsB = NsdPC;
EpB = ErrP100;
PbB = Pbinomi;
PbB = PbB<LaTeXalpha;
SbB = statSig(PbB+1);
PbB = sum(PbB);
ApB = ErrP100Sum;

load(['_all.split-half.stats' statsExt '.mat']);

NxS = NtCWTextr;
NsS = NsdPC;
EpS = ErrP100;
PbS = Pbinomi;
PbS = PbS<LaTeXalpha;
SbS = statSig(PbS+1);
PbS = sum(PbS);
ApS = ErrP100Sum;

load(['_all.1trial.out.stats' statsExt '.mat']);

EpH = ErrP100;
PbH = Pbinomi;
PbH = PbH<LaTeXalpha;
SbH = statSig(PbH+1);
PbH = sum(PbH);
ApH = ErrP100Sum;

load(['_all.split-half-57-9.stats' statsExt '.mat']);

Ph = Photelling;
PhN = Ph<LaTeXalpha;
Sh = statSig(PhN+1);
PhN = sum(PhN);

for n=1:size(DS,1)
 O=[O,sprintf('%2u.&\\texttt{%s}\n',n,DS(n,:))];
 O=[O,sprintf('&%3u&%2u&%5.1f&%5.1f&%5.1f&${}^{%s}$\n', ...
   NxG(n),NsG(n),EpG(n,1),EpG(n,2),EpG(n,3), SbG(n) )];
 O=[O,sprintf('&%3u&%2u&%5.1f&%5.1f&%5.1f&${}^{%s}$\n', ...
   NxB(n),NsB(n),EpB(n,1),EpB(n,2),EpB(n,3), SbB(n) )];
 O=[O,sprintf('&%3u&%2u&%5.1f&%5.1f&%5.1f&${}^{%s}$\n', ...
   NxS(n),NsS(n),EpS(n,1),EpS(n,2),EpS(n,3), SbS(n) )];
 O=[O,sprintf('&%5.1f&%5.1f&%5.1f&${}^{%s}$&%6.4f&${}^{%s}$%s\n', ...
   EpH(n,1),EpH(n,2),EpH(n,3),SbH(n),Ph(n),Sh(n) ,'\\')];
end

O=[O,sprintf('%s\n', '\hline')];
O=[O,sprintf('%s\n', '\multicolumn{4}{l}{\textbf{\footnotesize\hspace{-0.6em}Group Averages\,:}}')];
O=[O,sprintf('  &?{%5.1f}&?{%5.1f}&?{%5.1f}&\n', ApG(1),ApG(2),ApG(3))];
O=[O,sprintf('&&&?{%5.1f}&?{%5.1f}&?{%5.1f}&\n', ApB(1),ApB(2),ApB(3))];
O=[O,sprintf('&&&?{%5.1f}&?{%5.1f}&?{%5.1f}&\n', ApS(1),ApS(2),ApS(3))];
O=[O,sprintf('  &?{%5.1f}&?{%5.1f}&?{%5.1f}& %s\n', ApH(1),ApH(2),ApH(3) ,'\\')];
O=[O,sprintf('%s\n', '\hline')];
O=[O,sprintf('%s\n', '\multicolumn{6}{l}{\textbf{\footnotesize')];
O=[O,sprintf('%s\n', '\hspace{-0.6em}\textbf{*}Significant\,at\,level')];
O=[O,sprintf('%s%4.2f%s\n', '$\boldsymbol{\alpha}$\,=\,',LaTeXalpha,'\,:}}')];
O=[O,sprintf('    &?{%u}&\n', PbG)];
O=[O,sprintf('&&&&&?{%u}&\n', PbB)];
O=[O,sprintf('&&&&&?{%u}&\n', PbS)];
O=[O,sprintf('  &&&?{%u}&\n', PbH)];
O=[O,sprintf('    &?{%u}%s\n', PhN ,'\\')];
O=[O,sprintf('%s\n', '\hline')];
O=[O,sprintf('%s\n', '\end{tabular}')];
O=[O,sprintf('%s\n', '\end{sffamily}')];
O=[O,sprintf('%s\n', '\end{document}')];

O = strrep(O,'?','\footnotesize\textbf');

latexFile = ['./_A_stats' statsExt '.tex'];
tcwt_txtsave(latexFile,O);

tcwt_txt('tcwt_stats2latex: Alpha = %f LaTeX table saved to %s\n',LaTeXalpha,latexFile);
