%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Multivariate detection of outliers from
%: previously computed principal components.

function [outlRIerp,outlStr] = tcwt_pcoutlcnd(RIerp,pcVerp,Cnd,Nstd,MinGood);

Nstd=round(100*Nstd)/100;
MinGood=round(100*MinGood)/100;

formatStr = '|%3u: %4u(%4.1f%%)  %3u(%4.1f%%) ';
outlStr='';
for nCnd=Cnd(:)'
 Scnd = RIerp(:,2)==nCnd;
 cndVerp = pcVerp(Scnd,:);
 pSout = logical(RIerp(Scnd,1)); % Previuosly found Outliers
 nSout = pSout;
 Ntr=length(nSout);
 nNout=sum(nSout);
 Sout=~nSout;
 Ncs=NaN; NcsOutl=NaN;
 N=0;
 while ( Nstd~=0 && any(Sout~=nSout) )
  N=N+1;
  Sout=nSout; Nout=nNout;
  cndVerp = cndVerp - repmat( mean(cndVerp(~Sout,:)), size(cndVerp,1), 1 );
  R = sqrt( cndVerp.^2 * (1./var(cndVerp(~Sout,:)))' );
  nSout = R > mean(R(~Sout)) + Nstd*std(R(~Sout)); % Outlier Criterion
  nSout = nSout | pSout;
  nNout=sum(nSout);
  if ( nNout<=Nout && size(RIerp,2)>2 ) % Exclude whole individual datasets
   Ncs=0; NcsOutl=0;
   for nSbj=unique(RIerp(Scnd,3))'
    Ncs=Ncs+1;
    Ssbj = RIerp(Scnd,3)==nSbj;
    if ( sum(~nSout & Ssbj)/sum(Ssbj) < MinGood )
     NcsOutl=NcsOutl+1;
     nSout = nSout | Ssbj; % Exclude individual datasettxt
    end
   end
   nNout=sum(nSout);
  end
  if ( nNout<=Nout )      % Secure convergence by
   nSout = nSout | Sout; % retaining outliers detected at previous iteration
   nNout=sum(nSout);
  end
 end
 RIerp(Scnd,1) = nSout + 0;
 Nout = sum(nSout);
 outlStr=[outlStr,sprintf(formatStr, nCnd, nNout, 100*nNout/Ntr, NcsOutl, 100*NcsOutl/Ncs)];
end
outlRIerp = RIerp;


