%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_f2cwss(DSNL) computes the Sums of Squares (SS) of the Continuous
%: Wavelet Transform (CWT) for subsequent Student's t-tests <tcwt_help math>.
%:
%: The job constants are loaded from './_A_const.mat' <tcwt_help prm2mat>.
%: Then, the function iterates over DSNL reading and processing data from
%: the INPUT FILES and saving results to the corresponding OUTPUT FILES.
%:
%: FUNCTION ARGUMENTS
%:
%:   DSNL   DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%:
%: INPUT FILES         INPUT VARIABLES
%:
%:   ./DSN.f.mat        Verp,CIerp <tcwt_help t2f>
%:   ./DSN.pc.mat       pcTerp <tcwt_help f2pc>
%:   ./DSN.ri1.mat      RIerp <tcwt_help t2f>
%:
%: OUTPUT FILES        OUTPUT VARIABLES
%:
%:   ./DSN.cwss.mat        cwVerpSS

%       10        20        30        40        50        60        70        80

function tcwt_f2cwss(dsnl);

rin='1';
countN=0;

tI = clock();

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_f2cwss: Continuous Wavelet Transform & Sums of Squares (CWT-SS)\n')];
O=[O,tcwt_txt('--------------------------------------------------------------------\n')];

load('_A_const.mat');
for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 load([dsn '.f.mat']);
 load([dsn '.ri' rin '.mat']);
 load([dsn '.pc.mat']);

 Sout=logical(RIerp(:,1));

 cwVerpSS = tcwt_cwtss(Verp(~Sout,:),CIerp,pcTerp,cwTerp,NcwMax,countN);

 save([dsn '.cwss.mat'],'cwVerpSS');
 O=[O,tcwt_txt('%s\n',dsn)];
end

tE = etime(clock(),tI);
O=[O,tcwt_txt('--------------------------------------------------------------------\n')];
O=[O,tcwt_txt('tcwt_f2cwss: Elapsed time: %s   =   %f seconds\n', tcwt_hms(tE), tE )];
O=[O,tcwt_txt('____________________________________________________________________\n')];
