%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: tcwt_f2pool(DSNL,poolNAME) pools two or more individual ERP datasets
%:                            together into one large group dataset.
%:
%: The job constants are loaded from './_A_const.mat' <tcwt_help prm2mat>.
%: Then, the function iterates over DSNL reading data from the INPUT FILES
%: and saving the pooled data to the corresponding OUTPUT FILES.
%:
%: FUNCTION ARGUMENTS
%:
%:   DSNL      DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%:
%:   poolNAME  The Name of the pooled dataset
%:
%: INPUT FILES       INPUT VARIABLES <tcwt_help t2f>
%:
%:   ./DSN1.f.mat     Verp1,CIerp1
%:   ./DSN2.f.mat     Verp2,CIerp2
%:   ...                 ...
%:
%:   ./DSN1.ri0.mat   RIerp1,DSNLpool
%:   ./DSN2.ri0.mat   RIerp2
%:   ...                 ...
%:
%: OUTPUT FILES          OUTPUT VARIABLES
%:
%:   ./poolNAME.f.mat     Verp = [Verp1; Verp2; ... ]
%:                        CIerp = CIerp1
%:
%:   ./poolNAME.ri0.mat   RIerp = [RIerp1; RIerp2; ... ]
%:                        DSNLpool = DSNL

%       10        20        30        40        50        60        70        80

function tcwt_f2pool(dsnl,poolName);

rin='0';

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_f2pool: Creating a Pooled Dataset\n')];
O=[O,tcwt_txt('--------------------------------------\n')];

pVerp=[];
pRIerp=[];

for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 load([dsn '.f.mat']);
 load([dsn '.ri' rin '.mat']);

 pVerp=[pVerp;Verp];
 if size(RIerp,2)==2
  RIerp=[RIerp, repmat(n,size(RIerp,1),1)];
 end
 pRIerp=[pRIerp;RIerp];

 O=[O,tcwt_txt('%s\n',dsn)];
end

Verp=pVerp;
RIerp=pRIerp;

DSNLpool=dsnl;

save([poolName '.f.mat'],'Verp','CIerp');
save([poolName '.ri' rin '.mat'],'RIerp','DSNLpool');

O=[O,tcwt_txt(' >> %s\n',poolName)];
O=[O,tcwt_txt('______________________________________\n')];


