%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Plots average ERPs and other related curves

function fh = tcwt_ploterp(Verp,CIerp,channelName,channelXY,lineWidth,colorRGB);

Time=CIerp(2, CIerp(1,:)==CIerp(1,1));
ch=unique(CIerp(1,:));
ch=ch(channelXY(ch,3)==1);
C=[];Cch=[];
for n=1:length(ch),
 C=[C, Verp(:, CIerp(1,:)==ch(n) )];
 Cch=[Cch, ch(n)*ones(1,length(Time))];
end

Tmin=min(Time);
Tmax=max(Time);
Vmin=min(min(C'));
Vmax=max(max(C'));

chxy=channelXY(ch,1:2);
chp(:,1)=chxy(:,1)-min(chxy(:,1));
chp(:,2)=chxy(:,2)-min(chxy(:,2));
N=max(chp(:,1));
M=max(chp(:,2));
xoffset = 0.03;
yoffset = 0.03;
xwidth=(1-xoffset)/(N+1);
ywidth=(1-yoffset)/(M+1);

fh=figure();
set(gcf,'PaperUnits','centimeters');
set(gcf,'PaperSize',[29.7 21]);
set(gcf,'PaperPosition',[0 0 29.7 21]);
for n=1:length(ch),
  x0=chp(n,1)*xwidth+xoffset;
  y0=chp(n,2)*ywidth+yoffset;
  xw=xwidth-xoffset;
  yw=ywidth-yoffset;
  subplot('Position',[x0,y0,xw,yw]);
  hold on
  for nn=1:size(C,1)
   plot(Time,C( nn, Cch(1,:)==ch(n) ),'LineWidth',lineWidth(nn),'Color',colorRGB(nn,:));
  end
  plot([Tmin,Tmax],[0,0],':k',[0,0],[Vmin,Vmax],':k');
  axis('ij');
  axis([Tmin Tmax Vmin Vmax]);
  box('off');
  set(gca,'FontSize',12);
  text(Tmin+0.05*(Tmax-Tmin), Vmin+0.05*(Vmax-Vmin), channelName(ch(n),:),'FontSize',14);
%    if (chxy(n,1)~=0 || chxy(n,2)~=0)
%      set(gca,'XTickLabel',' ');
%      set(gca,'YTickLabel',' ');
%    end
end

