%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: Change of format: 1 line = 1 single trial

function [vVerp,vRIerp,vCIerp] = tcwt_vectorerp(Verp,RIerp,CIerp);

ch=double(unique(RIerp(:,3))); % channels
Nch=length(ch);
Nt=size(Verp,2);
Ns=size(Verp,1)/Nch;
if nargin<3 CIerp=1:Nt; end
vVerp=reshape(Verp',Nt*Nch,Ns)';
vRIerp=RIerp( RIerp(:,3)==RIerp(1,3) , 1:2 );
vCIerp=[];
for n=1:Nch,
  vCIerp=[vCIerp, [ch(n)*ones(1,Nt); CIerp] ];
end


