%
% t-CWT Copyright (C) 2003-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%: A t-CWT job input parameter file prjNAME_prmNAME is called from
%: the main job script prjNAME_scrNAME_prmNAME_varNAME <tcwt_help main>.
%: The job input parameters are job constants <tcwt_help prm2mat>.
%:
%: The main script saves a copy of the job input parameter
%: file tcwtROOT/jobs/prjNAME_prmNAME.m in './_A_prm_prmNAME.m'
%: (i.e. in tcwtWORK/prjNAME/prmNAME_varNAME/_A_prm_prmNAME.m).
%:
%: Create a new input parameter file prjNAME_prmNAME by copying
%: the demo input parameter file tcwtROOT/demo/tcwt_prm.m
%: to tcwtROOT/jobs/prjNAME_prmNAME.m and editing the copy.
%:
%: JOB INPUT PARAMETERS

%:
%: Window = [time1 time2];
%: Beginning and end (in seconds) of the time window
%: in which ERP assessment should be performed.
%: Window must be within the range defined by Epoch (see below).
Window   = [0 600] / 1000;

%:
%: cutoffScale = time;
%: Cutoff scale in seconds.
cutoffScale = 100 / 1000;

%:
%: logGridR = number;
%: Log-grid sampling rate in points per scale (pps).
logGridR = 15;

%:
%: BaseLine = [time1 time2];
%: Beginning and end (in seconds) of the baseline job constants
%: to which the EEG in Window will be referenced.
BaseLine = [-100 0] / 1000;

%:
%: fadeInOut = [time1 time2];
%: Fadein and Fadeout time for the Tukey window function.
fadeInOut = [20, 200] / 1000;

%:
%: NcwMax = number;
%: Maximum number ot trials processed by CWT in one step.
%: If there are many trials to be processed and NcwMax is too big
%: t-CWT may run out of memory.
NcwMax = 1000;

%:
%: Epoch = [time1 time2];
%: Beginning and end (in seconds) of EEG epoch, defined by the input data.
Epoch = [-100 900] / 1000;

%:
%: NtimePt = number;
%: Number of time sampling points in the Epoch.
%: For an ERP ASCII file 'dataset.dat' exported from Brain Broducts EEG
%: format, the value of NtimePt can be obtained from 'dataset.vhdr'.
%: If NtimePt <= 0, its value is ignored. If both a2dR > 0 and NtimePt > 0,
%: their values must be in the right relationship with each other and
%: with the length of the EEG epoch.
NtimePt = 0;

%:
%: a2dR = number;
%: Analog-to-digital time-sampling rate in Hz, defined by the input data.
%: For an ASCII ERP file 'dataset.dat' exported from Brain Broducts EEG
%: format, the value of a2dR can be obtained from 'dataset.vhdr'.
%: If a2dR <= 0, its value is ignored. If both a2dR > 0 and NtimePt > 0,
%: their values must be in the right relationship with each other and
%: with the length of the EEG epoch.
a2dR = 500;

%:
%: ASCIIext = string;
%: File extension (without the leading '.')
%: of the ASCII ERP datasets that will be imported into t-CWT.
ASCIIext = 'ascii';

%:
%: isMultiplex = 0 or 1;
%: isMultiplex tells t-CWT whether the imported ASCII data are in vectorized
%: (isMultiplex = 0) or in multiplexed format <tcwt_help ascii2tmat>. For an
%: ASCII ERP file 'dataset.dat' exported from Brain Broducts EEG format,
%: this information can be obtained from 'dataset.vhdr'.
isMultiplex = 1;

%:
%: ChannelList = ['ChannelName1 '; 'ChannelName2 ';... 'ChannelNameN~';... ];
%: A character array whose rows are the names of the EEG channels. Both
%: the names and the order of the channels are defined by the input data.
%: For an ERP ASCII file 'dataset.dat' exported from Brain Broducts EEG
%: format, the channels can be obtained from 'dataset.vhdr'. Only channels
%: whose names end with a blank are processed; the rest is discarded.
%: Change channel names to tell t-CWT which channels should be processed,
%: but don't change the order defined by the imported ERP data!
ChannelList = [ ...
'VEOG'; ... % discarded
'HEOG'; ... % discarded
'FZ  '; ...
'CZ  '; ...
'PZ  '; ...
'P3  '; ...
'P4  '; ...
'C3  '; ...
'C4  '; ...
'F3  '; ...
'F4  '; ...
[]];

%       10        20        30        40        50        60        70        80
