﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace yinteraction
{
    public partial class MainForm : Form
    {
        public string[] database_Biogrid;                //Biogrid database filtered with selector ("inviable")
        public string[] database_SGD;                    //orf database; only gene description

        public int partner_1_order = 7;                  //position of gene name A in database_Biogrid 
        public int partner_2_order = 8;                  //position of gene name B in database_Biogrid 

        public string[] gene_list;                       //genes with interactions, that can be analysed 

        string outfile_sec_partner;
        string outfile_10_sec_fas;
        string outfile_10_sec_tab;
        string outfile_count_match;
        string outfile_match_matrix_sec;
        string outfile_10_pri_fas;
        string outfile_10_pri_tab;
        string outfile_match_matrix_pri;
        string outfile_dataset;


        public MainForm()
        {
            InitializeComponent();
            LoadDatabase1.PerformClick();
            LoadDatabase2.PerformClick();
        }

        private void Analyse_button_Click(object sender, EventArgs e)
        {
            string query_gene = Choose_Gene_Box.SelectedItem.ToString();
            Analysis(query_gene);
        }

        private void Geneinfo_button_Click(object sender, EventArgs e)
        {
            string gene_info = gene_info_search.Text;
            string outfile = "";
            string[] line_split;
            foreach (string line in database_SGD)
            {
                line_split = line.Split(' ');
                if (System.Text.RegularExpressions.Regex.IsMatch(line_split[1], gene_info, System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                {
                    if (line_split[1].Length == gene_info.Length)
                    {
                        outfile = line;
                    }
                }
            }
            Windowmanager.Message_Win_long.Close();
            Gene_Info_Box.Text = outfile;
        }

        private void Result_button_Click(object sender, EventArgs e)
        {
            if (Choose_Format_Box.GetItemCheckState(0) == CheckState.Checked)             //results in Windows
            {

                if (Choose_Result_Box.GetItemCheckState(0) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(1, outfile_sec_partner);
                }

                if (Choose_Result_Box.GetItemCheckState(1) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(2, outfile_10_sec_fas);
                }

                if (Choose_Result_Box.GetItemCheckState(2) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(3, outfile_10_sec_tab);
                }

                if (Choose_Result_Box.GetItemCheckState(3) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(4, outfile_match_matrix_sec);
                }

                if (Choose_Result_Box.GetItemCheckState(4) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(5, outfile_count_match);
                }

                if (Choose_Result_Box.GetItemCheckState(5) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(6, outfile_10_pri_fas);
                }

                if (Choose_Result_Box.GetItemCheckState(6) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(7, outfile_10_pri_tab);
                }

                if (Choose_Result_Box.GetItemCheckState(7) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(8, outfile_match_matrix_pri);
                }

                if (Choose_Result_Box.GetItemCheckState(8) == CheckState.Checked)
                {
                    Windowmanager.HandleWindow(9, outfile_dataset);
                }
            }


            if (Choose_Format_Box.GetItemCheckState(1) == CheckState.Checked)           //results to outfile
            {
                string outfile = "";
                if (Choose_Result_Box.GetItemCheckState(0) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "list of primary and secondary partner in fasta format:" + "\r\n" + "\r\n" + outfile_sec_partner;
                }

                if (Choose_Result_Box.GetItemCheckState(1) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "1/0 list of secondary partner in fasta format:" + "\r\n" + "\r\n" + outfile_10_sec_fas;
                }

                if (Choose_Result_Box.GetItemCheckState(2) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "1/0 list of secondary partner tab separated:" + "\r\n" + "\r\n" + outfile_10_sec_tab;
                }

                if (Choose_Result_Box.GetItemCheckState(3) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "match matrix of secondary partner:" + "\r\n" + "\r\n" + outfile_match_matrix_sec;
                }

                if (Choose_Result_Box.GetItemCheckState(4) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "count matches of partner:" + "\r\n" + "\r\n" + outfile_count_match;
                }

                if (Choose_Result_Box.GetItemCheckState(5) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "1/0 list of primary partner in fasta format:" + "\r\n" + "\r\n" + outfile_10_pri_fas;
                }

                if (Choose_Result_Box.GetItemCheckState(6) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "1/0 list of primary partner tab separated:" + "\r\n" + "\r\n" + outfile_10_pri_tab;
                }

                if (Choose_Result_Box.GetItemCheckState(7) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "match matrix of primary partner:" + "\r\n" + "\r\n" + outfile_match_matrix_pri;
                }

                if (Choose_Result_Box.GetItemCheckState(8) == CheckState.Checked)
                {
                    outfile = outfile + "\r\n" + "\r\n" + "datasets of primary interaction partner:" + "\r\n" + "\r\n" + outfile_dataset;
                }
                System.IO.File.WriteAllText("outfile.txt", outfile);
            }
        }

        private void Close_Windows_Click(object sender, EventArgs e)
        {
            Windowmanager.HandleWindow(0, "");                             //close all result windows
        }

        private void CreateDatabase1_Click(object sender, EventArgs e)
        {
            string selector = "Inviable";
            OpenFileDialog FileDialog = new OpenFileDialog();
            FileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            FileDialog.Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*";
            FileDialog.FilterIndex = 2;
            FileDialog.RestoreDirectory = true;
            FileDialog.ShowDialog();
            string filename = FileDialog.FileName;
            if (!File.Exists(filename))
            {
                Interaction_Box.Text = "Error, creating database_1 failed";
            }

            if (File.Exists(filename))
            {
                string[] infile = File.ReadAllLines(filename);
                string[] outfile;
                int i = 0;
                foreach (string line in infile)
                {
                    if (System.Text.RegularExpressions.Regex.IsMatch(line, selector, System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                    {
                        i++;
                    }
                }
                outfile = new string[i];
                i = 0;
                foreach (string line in infile)
                {
                    if (System.Text.RegularExpressions.Regex.IsMatch(line, selector, System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                    {
                        outfile[i] = line;
                        i++;
                    }
                }
                System.IO.File.WriteAllLines("database1.txt", outfile);
            }
        }

        private void CreateDatabase2_Click(object sender, EventArgs e)
        {
            OpenFileDialog FileDialog = new OpenFileDialog();
            FileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            FileDialog.Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*";
            FileDialog.FilterIndex = 2;
            FileDialog.RestoreDirectory = true;
            FileDialog.ShowDialog();
            string filename = FileDialog.FileName;
            if (!File.Exists(filename))
            {
                Interaction_Box.Text = "Error, creating database_2 failed";
            }
            if (File.Exists(filename))
            {
                string[] infile = File.ReadAllLines(filename);
                string[] outfile;
                int i = 0;
                foreach (string line in infile)
                {
                    if (line.StartsWith(">"))
                    {
                        i++;
                    }
                }
                outfile = new string[i];
                i = 0;
                foreach (string line in infile)
                {
                    if (line.StartsWith(">"))
                    {
                        outfile[i] = line;
                        i++;
                    }
                }
                System.IO.File.WriteAllLines("database2.txt", outfile);
            }
        }

        private void LoadDatabase1_Click(object sender, EventArgs e)
        {
            if (!File.Exists("database1.txt"))                 //modified Biogrid database 
            {
                Interaction_Box.Text = "Error, database could not be found";
            }
            if (File.Exists("database1.txt"))
            {
                string[] infile = File.ReadAllLines("database1.txt");
                string[] database_1;
                int i = 0;
                foreach (string line in infile)
                {
                    i++;
                }
                database_1 = new string[i];
                i = 0;
                foreach (string line in infile)
                {
                    database_1[i] = line;
                    i++;
                }
                database_Biogrid = database_1;

                string gene_list_tmp = "";
                int gene_list_amount = 0;
                string[] line_splitted;
                foreach (string line in database_Biogrid)
                {
                    line_splitted = line.Split('\t');
                    if (!System.Text.RegularExpressions.Regex.IsMatch(gene_list_tmp, line_splitted[partner_1_order], System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                    {
                        if (System.Text.RegularExpressions.Regex.IsMatch(line_splitted[partner_1_order], @"^[a-zA-Z0-9,-]+$"))
                        {
                            gene_list_tmp = gene_list_tmp + line_splitted[partner_1_order] + " ";
                            gene_list_amount++;
                        }
                    }
                    if (!System.Text.RegularExpressions.Regex.IsMatch(gene_list_tmp, line_splitted[partner_2_order], System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                    {
                        if (System.Text.RegularExpressions.Regex.IsMatch(line_splitted[partner_2_order], @"^[a-zA-Z0-9,-]+$"))
                        {
                            gene_list_tmp = gene_list_tmp + line_splitted[partner_2_order] + " ";
                            gene_list_amount++;
                        }
                    }
                }
                gene_list_tmp = gene_list_tmp.TrimEnd(' ');

                gene_list = gene_list_tmp.Split(' ');
                Array.Sort(gene_list);                                      //gene_list created
                Choose_Gene_Box.BeginUpdate();
                for (int i1 = 0; i1 < gene_list_amount; i1++)
                {
                    Choose_Gene_Box.Items.Add(gene_list[i1]);
                }
                Choose_Gene_Box.EndUpdate();
                Choose_Gene_Box.SetSelected(1, true);                      //Choose_gene_box filled with gene_list
            }
        }

        private void LoadDatabase2_Click(object sender, EventArgs e)
        {
            if (!File.Exists("database2.txt"))                        //modified SGD database
            {
                Interaction_Box.Text = "Error, database could not be found";
            }

            if (File.Exists("database2.txt"))
            {
                string[] infile = File.ReadAllLines("database2.txt");
                string[] database_2;
                int i = 0;
                foreach (string line in infile)
                {
                    i++;
                }
                database_2 = new string[i];
                i = 0;
                foreach (string line in infile)
                {
                    database_2[i] = line;
                    i++;
                }
                database_SGD = database_2;
            }
        }

        private void Quit_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Help_Click(object sender, EventArgs e)
        {
            string Copyright_text = File.ReadAllText("Help");
            Form MenuWin = new Form();
            TextBox Menuoutbox = new TextBox();
            MenuWin.Width = 400;
            MenuWin.Height = 400;
            MenuWin.Controls.Add(Menuoutbox);
            Menuoutbox.Multiline = true;
            Menuoutbox.Width = 380;
            Menuoutbox.Height = 360;
            Menuoutbox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
            Menuoutbox.ScrollBars = ScrollBars.Vertical;
            Menuoutbox.Text = Copyright_text;
            MenuWin.Text = "Help";
            MenuWin.Show();
            MenuWin.Font = new Font("Microsoft Sans Serif", 9);
            Menuoutbox.DeselectAll();
            Menuoutbox.Refresh();
        }

        private void About_Click(object sender, EventArgs e)
        {
            string Copyright_text = "Yinteraction  Version 1.0.0\r\nSoftware to analysis genetic protein interactions in bakery yeast Saccharomyces cerevisiae\r\nCopyright 2015\r\nOliver Blechert";
            Form MenuWin = new Form();
            TextBox Menuoutbox = new TextBox();
            MenuWin.Width = 400;
            MenuWin.Height = 400;
            MenuWin.Controls.Add(Menuoutbox);
            Menuoutbox.Multiline = true;
            Menuoutbox.Width = 380;
            Menuoutbox.Height = 360;
            Menuoutbox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
            Menuoutbox.ScrollBars = ScrollBars.Vertical;
            Menuoutbox.Text = Copyright_text;
            MenuWin.Text = "About";
            MenuWin.Show();
            MenuWin.Font = new Font("Microsoft Sans Serif", 9);
            Menuoutbox.DeselectAll();
            Menuoutbox.Refresh();
        }

        private void Copyright_Click(object sender, EventArgs e)
        {
            string Copyright_text = File.ReadAllText("Copyright");
            Form MenuWin = new Form();
            TextBox Menuoutbox = new TextBox();
            MenuWin.Width = 400;
            MenuWin.Height = 400;
            Menuoutbox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
            MenuWin.Controls.Add(Menuoutbox);
            Menuoutbox.Multiline = true;
            Menuoutbox.Width = 380;
            Menuoutbox.Height = 360;
            Menuoutbox.ScrollBars = ScrollBars.Vertical;
            Menuoutbox.Text = Copyright_text;
            MenuWin.Text = "Copyright";
            MenuWin.Show();
            MenuWin.Font = new Font("Microsoft Sans Serif", 9);
            Menuoutbox.DeselectAll();
            Menuoutbox.Refresh();
        }

        private void Analysis(string query_gene)
        {
            string[] dataset_prim_partner;                        //list of query gene + primary interaction partner 
            string[] gene_interacting_pairs;                      //list of all interaction partner pairs
            primary_partner(query_gene, out dataset_prim_partner, out gene_interacting_pairs);
            string[] all_partner;
            list_secondary_partner(dataset_prim_partner, gene_interacting_pairs, out all_partner);
            out_1_0_sec(all_partner);
            out_1_0_pri(all_partner, dataset_prim_partner);
            match_matrix_sec(dataset_prim_partner);
            match_matrix_pri(dataset_prim_partner);
        }

        private void primary_partner(string query_gene, out string[] dataset_prim_partner, out string[] gene_interacting_pairs)
        {
            const int max_primary_partner = 10000;
            const int max_interaction_pairs = 10000000;
            int count_outfile_dataset = 0;
            int count_subdataset = 0;
            outfile_dataset = "";                                  //public string; used in result section
            dataset_prim_partner = new string[max_primary_partner];
            dataset_prim_partner[0] = query_gene;
            int dataset_prim_partner_counter = 0;
            gene_interacting_pairs = new string[max_interaction_pairs];
            int gene_interacting_pairs_counter = 0;
            foreach (string line in database_Biogrid)
            {
                count_subdataset++;
                string[] line_splitted = line.Split('\t');
                if (System.Text.RegularExpressions.Regex.IsMatch(line_splitted[partner_1_order], @"^[a-zA-Z0-9,-]+$") && System.Text.RegularExpressions.Regex.IsMatch(line_splitted[partner_2_order], @"^[a-zA-Z0-9,-]+$"))
                {
                    gene_interacting_pairs[gene_interacting_pairs_counter] = line_splitted[partner_1_order];
                    gene_interacting_pairs_counter++;
                    gene_interacting_pairs[gene_interacting_pairs_counter] = line_splitted[partner_2_order];
                    gene_interacting_pairs_counter++;
                    if (System.Text.RegularExpressions.Regex.IsMatch(line_splitted[partner_1_order], query_gene, System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                    {
                        if (line_splitted[partner_1_order].Length == query_gene.Length)
                        {
                            outfile_dataset = outfile_dataset + line + "\r\n";
                            count_outfile_dataset++;
                            if (!System.Text.RegularExpressions.Regex.IsMatch(String.Join(" ", dataset_prim_partner), line_splitted[partner_2_order] + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                            {
                                dataset_prim_partner_counter++;
                                dataset_prim_partner[dataset_prim_partner_counter] = line_splitted[partner_2_order];
                            }
                        }
                    }
                    if (System.Text.RegularExpressions.Regex.IsMatch(line_splitted[partner_2_order], query_gene, System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                    {
                        if (line_splitted[partner_2_order].Length == query_gene.Length)
                        {
                            outfile_dataset = outfile_dataset + line + "\r\n";
                            count_outfile_dataset++;
                            if (!System.Text.RegularExpressions.Regex.IsMatch(String.Join(" ", dataset_prim_partner), line_splitted[partner_1_order] + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                            {
                                dataset_prim_partner_counter++;
                                dataset_prim_partner[dataset_prim_partner_counter] = line_splitted[partner_1_order];
                            }
                        }
                    }
                }
            }
            outfile_dataset = outfile_dataset.TrimEnd('\n');
            outfile_dataset = outfile_dataset.TrimEnd('\r');
            Array.Resize(ref dataset_prim_partner, dataset_prim_partner_counter + 1);
            Array.Resize(ref gene_interacting_pairs, gene_interacting_pairs_counter+1);
            if (dataset_prim_partner_counter > 100)                          //open message window, when analysis takes long
            {
                Windowmanager.Message_Win(query_gene);
            }
        }

        private void list_secondary_partner(string[] dataset_prim_partner, string[] gene_interacting_pairs, out string[] all_partner)
        {
            int i = 0;
            int i1 = 0;
            int dataset_prim_partner_count;
            dataset_prim_partner_count = dataset_prim_partner.GetLength(0);
            int gene_interacting_pairs_counter;
            gene_interacting_pairs_counter = gene_interacting_pairs.GetLength(0);
            outfile_sec_partner = ">" + dataset_prim_partner[0] + "\r\n";
            for (i = 1; i < dataset_prim_partner_count; i++)
            {
                outfile_sec_partner = outfile_sec_partner + dataset_prim_partner[i] + " ";
            }
            string list_sec_partner = String.Join(" ", dataset_prim_partner) + " ";
            for (i = 1; i < dataset_prim_partner_count; i++)
            {
                string second_partner_tmp = "";
                outfile_sec_partner = outfile_sec_partner + "\r\n" + ">" + dataset_prim_partner[i] + "\r\n";
                for (i1 = 0; i1 < gene_interacting_pairs_counter - 1; i1++)
                {
                    if (System.Text.RegularExpressions.Regex.IsMatch(gene_interacting_pairs[i1], dataset_prim_partner[i], System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                    {
                        if (gene_interacting_pairs[i1].Length == dataset_prim_partner[i].Length)
                        {
                            if (i1 % 2 == 0)
                            {
                                if (!System.Text.RegularExpressions.Regex.IsMatch(second_partner_tmp, gene_interacting_pairs[i1 + 1] + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                                {
                                    second_partner_tmp = second_partner_tmp + gene_interacting_pairs[i1 + 1] + " ";
                                }
                                if (!System.Text.RegularExpressions.Regex.IsMatch(list_sec_partner, gene_interacting_pairs[i1 + 1] + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                                {
                                    list_sec_partner = list_sec_partner + gene_interacting_pairs[i1 + 1] + " ";
                                }
                            }
                            if (i1 % 2 != 0)
                            {
                                if (!System.Text.RegularExpressions.Regex.IsMatch(second_partner_tmp, gene_interacting_pairs[i1 - 1] + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                                {
                                    second_partner_tmp = second_partner_tmp + gene_interacting_pairs[i1 - 1] + " ";
                                }
                                if (!System.Text.RegularExpressions.Regex.IsMatch(list_sec_partner, gene_interacting_pairs[i1 - 1] + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                                {
                                    list_sec_partner = list_sec_partner + gene_interacting_pairs[i1 - 1] + " ";
                                }
                            }
                        }
                    }
                }
                string[] second_partner_tmp_split;
                second_partner_tmp = second_partner_tmp.TrimEnd(' ');
                second_partner_tmp_split = second_partner_tmp.Split(' ');
                Array.Sort(second_partner_tmp_split);
                outfile_sec_partner = outfile_sec_partner + String.Join(" ", second_partner_tmp_split) + " ";
            }
            list_sec_partner = list_sec_partner.TrimEnd(' ');
            string[] secondary_partner = list_sec_partner.Split(' ');
            Array.Sort(secondary_partner);
            all_partner = secondary_partner;
            list_sec_partner = String.Join(" ", secondary_partner);
            Interaction_Box.Text = outfile_sec_partner;
            Windowmanager.Message_Win_long.Close();
        }

        private void out_1_0_sec(string[] all_partner)
        {
            char[] outfile_10_sec_fas_array = new char[10000000];                                     // create out 1/0 match list of secondary partner 
            char[] outfile_10_sec_tab_array = new char[10000000];
            int i1 = 0;
            int i2 = 0;
            string list_sec_partner;
            list_sec_partner = String.Join(" ", all_partner);
            list_sec_partner = list_sec_partner.TrimEnd(' ');
            string[] secondary_partner = list_sec_partner.Split(' ');
            Array.Sort(secondary_partner);
            list_sec_partner = String.Join(" ", secondary_partner);                                // list of query gene, primary partner, secondary partner
            string list_sec_partner_tab = String.Join("\t", secondary_partner);
            int amount_match_partner_counter;
            int[] amount_match_partner = new int[6000];
            for (amount_match_partner_counter = 0; amount_match_partner_counter < 1000; amount_match_partner_counter++)
            {
                amount_match_partner[amount_match_partner_counter] = 0;
            }
            foreach (char letter in list_sec_partner)
            {
                outfile_10_sec_fas_array[i1] = letter;
                i1++;
            }
            outfile_10_sec_fas_array[i1] = '\r';
            i1++;
            outfile_10_sec_fas_array[i1] = '\n';
            i1++;
            outfile_10_sec_tab_array[i2] = '\t';
            i2++;
            foreach (char letter in list_sec_partner_tab)
            {
                outfile_10_sec_tab_array[i2] = letter;
                i2++;
            }
            outfile_10_sec_tab_array[i2] = '\r';
            i2++;
            outfile_10_sec_tab_array[i2] = '\n';
            i2++;
            string[] list_sec_partner_split;
            string line_sec_partner_split;
            list_sec_partner_split = outfile_sec_partner.Split('\n');
            foreach (string line in list_sec_partner_split)
            {
                line_sec_partner_split = line.TrimStart('\r');
                if (line_sec_partner_split[0] == '>')
                {
                    foreach (char letter in line_sec_partner_split)
                    {
                        outfile_10_sec_fas_array[i1] = letter;
                        i1++;
                        if (letter != '>' && letter != '\r')
                        {
                            outfile_10_sec_tab_array[i2] = letter;
                            i2++;
                        }
                    }
                    outfile_10_sec_fas_array[i1] = '\n';
                    i1++;
                    outfile_10_sec_tab_array[i2] = '\t';
                    i2++;
                }
                else
                {
                    string[] gene_sec_partner_list = list_sec_partner.Split(' ');
                    amount_match_partner_counter = 0;
                    foreach (string gene_name in gene_sec_partner_list)
                    {
                        if (System.Text.RegularExpressions.Regex.IsMatch(line_sec_partner_split + " ", gene_name + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                        {
                            outfile_10_sec_fas_array[i1] = '1';
                            i1++;
                            outfile_10_sec_tab_array[i2] = '1';
                            i2++;
                            outfile_10_sec_tab_array[i2] = '\t';
                            i2++;
                            amount_match_partner[amount_match_partner_counter]++;
                            amount_match_partner_counter++;
                        }
                        else
                        {
                            outfile_10_sec_fas_array[i1] = '0';
                            i1++;
                            outfile_10_sec_tab_array[i2] = '0';
                            i2++;
                            outfile_10_sec_tab_array[i2] = '\t';
                            i2++;
                            amount_match_partner_counter++;
                        }
                    }
                    outfile_10_sec_fas_array[i1] = '\r';
                    i1++;
                    outfile_10_sec_fas_array[i1] = '\n';
                    i1++;
                    outfile_10_sec_tab_array[i2] = '\r';
                    i2++;
                    outfile_10_sec_tab_array[i2] = '\n';
                    i2++;
                }
            }
            outfile_count_match = "";
            Array.Resize(ref amount_match_partner, amount_match_partner_counter);
            Array.Sort(amount_match_partner, secondary_partner);
            int i;
            for (i = 0; i < amount_match_partner_counter; i++)
            {
                outfile_count_match = outfile_count_match + secondary_partner[(amount_match_partner_counter - 1) - i] + "\t" + amount_match_partner[(amount_match_partner_counter - 1) - i] + "\r\n";
            }
            Array.Resize(ref outfile_10_sec_fas_array, i1);
            Array.Resize(ref outfile_10_sec_tab_array, i2);
            outfile_10_sec_fas = new string(outfile_10_sec_fas_array);
            outfile_10_sec_tab = new string(outfile_10_sec_tab_array);
        }

        private void out_1_0_pri(string[] all_partner, string[] dataset_prim_partner)
        {
            int i1 = 0;
            int i2 = 0;
            string query_gene = dataset_prim_partner[0];
            string list_sec_partner;
            list_sec_partner = String.Join(" ", all_partner);
            list_sec_partner = list_sec_partner.TrimEnd(' ');
            string[] secondary_partner = list_sec_partner.Split(' ');
            Array.Sort(secondary_partner);
            list_sec_partner = String.Join(" ", secondary_partner);
            string[] list_sec_partner_split;
            string line_sec_partner_split;
            list_sec_partner_split = outfile_sec_partner.Split('\n');
            char[] outfile_10_pri_fas_array = new char[10000000];                                     // create out 1/0 match list of primary partner 
            char[] outfile_10_pri_tab_array = new char[10000000];
            string dataset_prim_partner_query_gene = String.Join(" ", dataset_prim_partner);
            string[] dataset_prim_partner_split = dataset_prim_partner_query_gene.Split(' ');
            Array.Sort(dataset_prim_partner_split);
            string dataset_prim_partner_space = String.Join(" ", dataset_prim_partner_split);
            string dataset_prim_partner_tab = String.Join("\t", dataset_prim_partner_split);
            foreach (char letter in dataset_prim_partner_space)
            {
                outfile_10_pri_fas_array[i1] = letter;
                i1++;
            }
            outfile_10_pri_fas_array[i1] = '\r';
            i1++;
            outfile_10_pri_fas_array[i1] = '\n';
            i1++;
            outfile_10_pri_tab_array[i2] = '\t';
            i2++;
            foreach (char letter in dataset_prim_partner_tab)
            {
                outfile_10_pri_tab_array[i2] = letter;
                i2++;
            }
            outfile_10_pri_tab_array[i2] = '\r';
            i2++;
            outfile_10_pri_tab_array[i2] = '\n';
            i2++;
            foreach (string line in list_sec_partner_split)
            {
                line_sec_partner_split = line.TrimStart('\r');
                if (line_sec_partner_split[0] == '>')
                {
                    foreach (char letter in line_sec_partner_split)
                    {
                        outfile_10_pri_fas_array[i1] = letter;
                        i1++;

                        if (letter != '>' && letter != '\r')
                        {
                            outfile_10_pri_tab_array[i2] = letter;
                            i2++;
                        }
                    }
                    outfile_10_pri_fas_array[i1] = '\n';
                    i1++;
                    outfile_10_pri_tab_array[i2] = '\t';
                    i2++;
                }
                else
                {
                    string[] gene_sec_partner_list = list_sec_partner.Split(' ');
                    foreach (string gene_name in dataset_prim_partner_split)
                    {
                        if (System.Text.RegularExpressions.Regex.IsMatch(line_sec_partner_split, gene_name, System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                        {
                            outfile_10_pri_fas_array[i1] = '1';
                            i1++;
                            outfile_10_pri_tab_array[i2] = '1';
                            i2++;
                            outfile_10_pri_tab_array[i2] = '\t';
                            i2++;
                        }
                        else
                        {
                            outfile_10_pri_fas_array[i1] = '0';
                            i1++;
                            outfile_10_pri_tab_array[i2] = '0';
                            i2++;
                            outfile_10_pri_tab_array[i2] = '\t';
                            i2++;
                        }
                    }
                    outfile_10_pri_fas_array[i1] = '\r';
                    i1++;
                    outfile_10_pri_fas_array[i1] = '\n';
                    i1++;
                    outfile_10_pri_tab_array[i2] = '\r';
                    i2++;
                    outfile_10_pri_tab_array[i2] = '\n';
                    i2++;
                }
            }
            Array.Resize(ref outfile_10_pri_fas_array, i1);
            Array.Resize(ref outfile_10_pri_tab_array, i2);
            outfile_10_pri_fas = new string(outfile_10_pri_fas_array);
            outfile_10_pri_tab = new string(outfile_10_pri_tab_array);
        }

        private void match_matrix_sec(string[] gene_identifier_split)
        {
            outfile_match_matrix_sec = "";
            int i = 0;
            int i1 = 0;
            int i2 = 0;
            int i3 = 0;
            int i4 = 0;
            char[] outfile_match_matrix_sec_array = new char[10000000];
            int startpoint = 0;
            int count_genes = 0;
            startpoint = outfile_10_sec_fas.IndexOf(">");
            string outfile_10_sec_data = outfile_10_sec_fas.Substring(startpoint, outfile_10_sec_fas.Length - (startpoint + 2));
            string[] outfile_10_sec_data_split = outfile_10_sec_data.Split('\n');
            string[] line_1_0_char;
            outfile_match_matrix_sec_array[i3] = '\t';
            i3++;
            foreach (string line in outfile_10_sec_data_split)
            {
                if (line[0] == '>')
                {
                    for (i = 1; i < line.Length - 1; i++)
                    {
                        outfile_match_matrix_sec_array[i3] = line[i];
                        i3++;
                    }
                    outfile_match_matrix_sec_array[i3] = '\t';
                    i3++;
                    count_genes++;
                }
            }
            outfile_match_matrix_sec_array[i3] = '\r';
            i3++;
            outfile_match_matrix_sec_array[i3] = '\n';
            i3++;
            line_1_0_char = new string[count_genes];
            int line_1_0_char_length = 0;
            i = 0;
            foreach (string line in outfile_10_sec_data_split)
            {
                if (line[0] != '>')
                {
                    if (i < count_genes)
                    {
                        line_1_0_char[i] = line;
                        i++;
                    }
                }
            }
            line_1_0_char_length = line_1_0_char[0].Length;
            char[,] char_1_0 = new char[count_genes, line_1_0_char_length];
            for (i1 = 0; i1 < count_genes; i1++)
            {
                i2 = 0;
                foreach (char character in line_1_0_char[i1])
                {
                    char_1_0[i1, i2] = character;
                    i2++;
                }
            }
            i = 0;
            i4 = 0;
            string match;
            int count_match = 0;
            for (i = 0; i < count_genes; i++)
            {
                foreach (char letter in gene_identifier_split[i])
                {
                    outfile_match_matrix_sec_array[i3] = letter;
                    i3++;
                }
                outfile_match_matrix_sec_array[i3] = '\t';
                i3++;
                for (i1 = 0; i1 < count_genes; i1++)
                {
                    for (i2 = 0; i2 < line_1_0_char_length; i2++)
                    {
                        if (char_1_0[i, i2] == '1' && char_1_0[i1, i2] == '1')
                        {
                            count_match++;
                        }
                    }
                    match = Convert.ToString(count_match);
                    for (i4 = 0; i4 < match.Length; i4++)
                    {
                        outfile_match_matrix_sec_array[i3] = match[i4];
                        i3++;
                    }
                    count_match = 0;
                    outfile_match_matrix_sec_array[i3] = '\t';
                    i3++;
                }
                outfile_match_matrix_sec_array[i3] = '\r';
                i3++;
                outfile_match_matrix_sec_array[i3] = '\n';
                i3++;
            }
            Array.Resize(ref outfile_match_matrix_sec_array, i3);
            outfile_match_matrix_sec = new string(outfile_match_matrix_sec_array);
        }

        private void match_matrix_pri(string[] gene_identifier_split)
        {
            int i = 0;
            int i1 = 0;
            int i2 = 0;
            int i3 = 0;
            int i4 = 0;
            char[] outfile_match_matrix_pri_array = new char[10000000];
            int startpoint = 0;
            int count_genes = 0;
            startpoint = outfile_10_pri_fas.IndexOf(">");
            string outfile_10_pri_data = outfile_10_pri_fas.Substring(startpoint, outfile_10_pri_fas.Length - (startpoint + 2));
            string[] outfile_10_pri_data_split = outfile_10_pri_data.Split('\n');
            outfile_match_matrix_pri_array[i3] = '\t';
            i3++;
            foreach (string line in outfile_10_pri_data_split)
            {
                if (line[0] == '>')
                {
                    for (i = 1; i < line.Length - 1; i++)
                    {
                        outfile_match_matrix_pri_array[i3] = line[i];
                        i3++;
                    }
                    outfile_match_matrix_pri_array[i3] = '\t';
                    i3++;
                    count_genes++;
                }
            }
            outfile_match_matrix_pri_array[i3] = '\r';
            i3++;
            outfile_match_matrix_pri_array[i3] = '\n';
            i3++;
            string[] line_1_0_char = new string[count_genes];
            int line_1_0_char_length = 0;
            i = 0;
            foreach (string line in outfile_10_pri_data_split)
            {
                if (line[0] != '>')
                {
                    if (i < count_genes)
                    {
                        line_1_0_char[i] = line;
                        i++;
                    }
                }
            }
            line_1_0_char_length = line_1_0_char[0].Length;
            char[,] char_1_0 = new char[count_genes, line_1_0_char_length];
            for (i1 = 0; i1 < count_genes; i1++)
            {
                i2 = 0;
                foreach (char character in line_1_0_char[i1])
                {
                    char_1_0[i1, i2] = character;
                    i2++;
                }
            }
            i = 0;
            i4 = 0;
            int count_match = 0;
            for (i = 0; i < count_genes; i++)
            {
                outfile_match_matrix_pri = outfile_match_matrix_pri + "\r\n";
                foreach (char letter in gene_identifier_split[i])
                {
                    outfile_match_matrix_pri_array[i3] = letter;
                    i3++;
                }
                outfile_match_matrix_pri_array[i3] = '\t';
                i3++;
                for (i1 = 0; i1 < count_genes; i1++)
                {
                    for (i2 = 0; i2 < line_1_0_char_length; i2++)
                    {
                        if (char_1_0[i, i2] == '1' && char_1_0[i1, i2] == '1')
                        {
                            count_match++;
                        }
                    }
                    string match = Convert.ToString(count_match);
                    for (i4 = 0; i4 < match.Length; i4++)
                    {
                        outfile_match_matrix_pri_array[i3] = match[i4];
                        i3++;
                    }
                    count_match = 0;
                    outfile_match_matrix_pri_array[i3] = '\t';
                    i3++;
                }
                outfile_match_matrix_pri_array[i3] = '\r';
                i3++;
                outfile_match_matrix_pri_array[i3] = '\n';
                i3++;
            }
            Array.Resize(ref outfile_match_matrix_pri_array, i3);
            outfile_match_matrix_pri = new string(outfile_match_matrix_pri_array);
        }

         private void Mega_Analysis()
         {
            System.IO.File.WriteAllText("outfile.txt", "");
            int amount_displayed_set;
            amount_displayed_set = 10;
            int threshold_partners_set;
            threshold_partners_set = 10;
            string gene_selection = "";
            bool analysis_form = true;
            bool write_line = true;
            amount_displayed_set = Convert.ToInt32(Windowmanager.Mega_Analysis_Text01.Text);
            threshold_partners_set = Convert.ToInt32(Windowmanager.Mega_Analysis_Text02.Text);
            CheckState state = Windowmanager.Mega_Analysis_Check_selection.CheckState;
            if (state == CheckState.Checked)
            {
                analysis_form = true;
                gene_selection = Convert.ToString(Windowmanager.Mega_Analysis_Text03.Text);
            }
            Windowmanager.Mega_Analysis_Win.Close();
            Windowmanager.Mega_Analysis_Form_Status();
            foreach (string gene_name_list in gene_list)
            {
                Analysis(gene_name_list);
                string write = "";
                string[] write_select;
                outfile_count_match = outfile_count_match.TrimEnd('\n');
                outfile_count_match = outfile_count_match.TrimEnd('\r');
                write_select = outfile_count_match.Split('\n');
                int i = 0;
                int i1 = 0;
                int threshold_partners_read;
                if (analysis_form ==false)
                {
                    foreach (string write_select_line in write_select)
                    {
                        string[] write_select_line_split;
                        write_select_line_split = write_select_line.Split('\t');
                        threshold_partners_read = Convert.ToInt32(write_select_line_split[1]);
                        if (i < amount_displayed_set)
                        {
                            if (threshold_partners_read > threshold_partners_set)
                            {
                                write = write + write_select_line + "\n";
                                i1++;
                            }
                        }
                    i++;
                    }
                }
                if (analysis_form == true)
                {
                    write_line = false;
                    foreach (string write_select_line in write_select)
                    {
                        string[] write_select_line_split;
                        write_select_line_split = write_select_line.Split('\t');
                        threshold_partners_read = Convert.ToInt32(write_select_line_split[1]);
                        if (i < amount_displayed_set)
                        {
                            if (threshold_partners_read > threshold_partners_set)
                            {
                                write = write + write_select_line + "\n";
                                i1++;
                                if (System.Text.RegularExpressions.Regex.IsMatch(write_select_line_split[0] + " ", gene_selection + " ", System.Text.RegularExpressions.RegexOptions.IgnoreCase))
                                {
                                    write_line = true;
                                }
                            }
                        }
                        i++;
                    }
                }
                if (write != "")
                {
                    if (i1 > 1)
                    {
                        if (write_line == true)
                        {
                            write = write + "\n\n";
                            System.IO.File.AppendAllText("outfile.txt", write);
                        }
                    }
                }
            }
            Windowmanager.Mega_Analysis_Win_Status.Close();
        }     
             
        private void MegaAnalysis_Click(object sender, EventArgs e)
        {
            Windowmanager.Mega_Analysis_Form();

            Windowmanager.Mega_Analysis_Run.Click += (Mega_Analysis_Run_sender, args) =>
                {
                    Mega_Analysis();
                };
            Windowmanager.Mega_Analysis_Close.Click += (Mega_Analysis_Close_sender, args) => Windowmanager.Mega_Analysis_Win.Close();
        }
    }

    class Windowmanager
        {
            public static Form Win01 = new Form();
            public static Form Win02 = new Form();
            public static Form Win03 = new Form();
            public static Form Win04 = new Form();
            public static Form Win05 = new Form();
            public static Form Win06 = new Form();
            public static Form Win07 = new Form();
            public static Form Win08 = new Form();
            public static Form Win09 = new Form();

            public static TextBox outbox1 = new TextBox();
            public static TextBox outbox2 = new TextBox();
            public static TextBox outbox3 = new TextBox();
            public static TextBox outbox4 = new TextBox();
            public static TextBox outbox5 = new TextBox();
            public static TextBox outbox6 = new TextBox();
            public static TextBox outbox7 = new TextBox();
            public static TextBox outbox8 = new TextBox();
            public static TextBox outbox9 = new TextBox();

            public static void HandleWindow(int choice, string input)
            {
                switch (choice) 
                {
                    case 0: Win01.Hide();
                        Win02.Hide();
                        Win03.Hide();
                        Win04.Hide();
                        Win05.Hide();
                        Win06.Hide();
                        Win07.Hide();
                        Win08.Hide();
                        Win09.Hide();
                        break;
                    case 1:
                        if (Win01.IsDisposed)
                        {
                            Win01 = new Form();
                            outbox1 = new TextBox();
                        }
                        Win01.Width = 400;
                        Win01.Height = 400;
                        Win01.Controls.Add(outbox1);
                        outbox1.Multiline = true;
                        outbox1.Width = 380;
                        outbox1.Height = 360;
                        outbox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox1.ScrollBars = ScrollBars.Vertical;
                        outbox1.Text = input;
                        Win01.Text = "Secondary Partner";
                        Win01.Show();
                        outbox1.Font = new Font("Microsoft Sans Serif", 9);
                        outbox1.DeselectAll();
                        outbox1.Refresh();    
                        break;
                    case 2:
                        if (Win02.IsDisposed)
                        {
                            Win02 = new Form();
                            outbox2 = new TextBox();
                        }
                        Win02.Width = 400;
                        Win02.Height = 400;
                        Win02.Controls.Add(outbox2);
                        outbox2.Multiline = true;
                        outbox2.Width = 380;
                        outbox2.Height = 360;
                        outbox2.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox2.ScrollBars = ScrollBars.Vertical;
                        outbox2.Text = input;
                        Win02.Text = "1/0 secondary, fasta format";
                        Win02.Show();
                        outbox2.Font = new Font("Microsoft Sans Serif", 9);
                        outbox2.DeselectAll();
                        outbox2.Refresh();   
                        break;
                    case 3:
                        if (Win03.IsDisposed)
                        {
                            Win03 = new Form();
                            outbox3 = new TextBox();
                        }
                        Win03.Width = 400;
                        Win03.Height = 400;
                        Win03.Controls.Add(outbox3);
                        outbox3.Multiline = true;
                        outbox3.Width = 380;
                        outbox3.Height = 360;
                        outbox3.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox3.ScrollBars = ScrollBars.Vertical;
                        outbox3.Text = input;
                        Win03.Text = "1/0 secondary; tab separated";
                        Win03.Show();
                        outbox3.Font = new Font("Microsoft Sans Serif", 9);
                        outbox3.DeselectAll();
                        outbox3.Refresh();    
                        break;
                    case 4: 
                        if (Win04.IsDisposed)
                        {
                            Win04 = new Form();
                            outbox4 = new TextBox();
                        }
                        Win04.Width = 400;
                        Win04.Height = 400;
                        Win04.Controls.Add(outbox4);
                        outbox4.Multiline = true;
                        outbox4.Width = 380;
                        outbox4.Height = 360;
                        outbox4.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox4.ScrollBars = ScrollBars.Vertical;
                        outbox4.Text = input;
                        Win04.Text = "match matrix secondary";
                        Win04.Show();
                        outbox4.Font = new Font("Microsoft Sans Serif", 9);
                        outbox4.DeselectAll();
                        outbox4.Refresh();    
                        break;
                    case 5: 
                        if (Win05.IsDisposed)
                        {
                            Win05 = new Form();
                            outbox5 = new TextBox();
                        }
                        Win05.Width = 400;
                        Win05.Height = 400;
                        Win05.Controls.Add(outbox5);
                        outbox5.Multiline = true;
                        outbox5.Width = 380;
                        outbox5.Height = 360;
                        outbox5.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox5.ScrollBars = ScrollBars.Vertical;
                        outbox5.Text = input;
                        Win05.Text = "match count partner";
                        Win05.Show();
                        outbox5.Font = new Font("Microsoft Sans Serif", 9);
                        outbox5.DeselectAll();
                        outbox5.Refresh();    
                        break;
                    case 6: 
                        if (Win06.IsDisposed)
                        {
                            Win06 = new Form();
                            outbox6 = new TextBox();
                        }
                        Win06.Width = 400;
                        Win06.Height = 400;
                        Win06.Controls.Add(outbox6);
                        outbox6.Multiline = true;
                        outbox6.Width = 380;
                        outbox6.Height = 360;
                        outbox6.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox6.ScrollBars = ScrollBars.Vertical;
                        outbox6.Text = input;
                        Win06.Text = "1/0 primary; fasta format";
                        Win06.Show();
                        outbox6.Font = new Font("Microsoft Sans Serif", 9);
                        outbox6.DeselectAll();
                        outbox6.Refresh();    
                        break;
                    case 7: 
                        if (Win07.IsDisposed)
                        {
                            Win07 = new Form();
                            outbox7 = new TextBox();
                        }
                        Win07.Width = 400;
                        Win07.Height = 400;
                        Win07.Controls.Add(outbox7);
                        outbox7.Multiline = true;
                        outbox7.Width = 380;
                        outbox7.Height = 360;
                        outbox7.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox7.ScrollBars = ScrollBars.Vertical;
                        outbox7.Text = input;
                        Win07.Text = "1/0 primary; tab separated";
                        Win07.Show();
                        outbox7.Font = new Font("Microsoft Sans Serif", 9);
                        outbox7.DeselectAll();
                        outbox7.Refresh();    
                        break;
                    case 8: 
                        if (Win08.IsDisposed)
                        {
                            Win08 = new Form();
                            outbox8 = new TextBox();
                        }
                        Win08.Width = 400;
                        Win08.Height = 400;
                        Win08.Controls.Add(outbox8);
                        outbox8.Multiline = true;
                        outbox8.Width = 380;
                        outbox8.Height = 360;
                        outbox8.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox8.ScrollBars = ScrollBars.Vertical;
                        outbox8.Text = input;
                        Win08.Text = "match matrix primary";
                        Win08.Show();
                        outbox8.Font = new Font("Microsoft Sans Serif", 9);
                        outbox8.DeselectAll();
                        outbox8.Refresh();    
                        break;
                    case 9:
                        if (Win09.IsDisposed)
                        {
                            Win09 = new Form();
                            outbox9 = new TextBox();
                        }
                        Win09.Width = 400;
                        Win09.Height = 400;
                        Win09.Controls.Add(outbox9);
                        outbox9.Multiline = true;
                        outbox9.Width = 380;
                        outbox9.Height = 360;
                        outbox9.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) | System.Windows.Forms.AnchorStyles.Left) | System.Windows.Forms.AnchorStyles.Right)));
                        outbox9.ScrollBars = ScrollBars.Vertical;
                        outbox9.Text = input;
                        Win09.Text = "dataset";
                        Win09.Show();
                        outbox9.Font = new Font("Microsoft Sans Serif", 9);
                        outbox9.DeselectAll();
                        outbox9.Refresh();
                        break;
                    default:
                        break;
              }       
         }

            public static Form Message_Win_long = new Form();                           //message window for long analysis
            public static TextBox Message_long_analysis = new TextBox();
            public static void Message_Win(string query_gene)
            {
                if (Message_Win_long.IsDisposed)
                {
                    Message_Win_long = new Form();
                    Message_long_analysis = new TextBox();
                }
                Message_Win_long.Width = 400;
                Message_Win_long.Height = 400;
                Message_Win_long.Controls.Add(Message_long_analysis);
                Message_long_analysis.Multiline = true;
                Message_long_analysis.Width = 380;
                Message_long_analysis.Height = 360;
                Message_long_analysis.Text = "The gene " + query_gene + " has many interaction partner and the analysis can take up to 1 min";
                Message_Win_long.Show();
                Message_long_analysis.Font = new Font("Microsoft Sans Serif", 12);
                Message_long_analysis.DeselectAll();
                Message_long_analysis.Refresh();
            }

            public static Form Mega_Analysis_Win = new Form();   
            public static TextBox Mega_Analysis_Text01 = new TextBox();
            public static TextBox Mega_Analysis_Text02 = new TextBox();
            public static TextBox Mega_Analysis_Text03 = new TextBox();
            public static Label Mega_Analysis_Label01 = new Label();
            public static Label Mega_Analysis_Label02 = new Label();
            public static Label Mega_Analysis_Label03 = new Label();
            public static Label Mega_Analysis_Label04 = new Label();
            public static Label Mega_Analysis_Label05 = new Label();
            public static Label Mega_Analysis_Label06 = new Label();
            public static Button Mega_Analysis_Run = new Button();
            public static Button Mega_Analysis_Close = new Button();
            public static CheckBox Mega_Analysis_Check_selection = new CheckBox();

            public static void Mega_Analysis_Form()
            {
                if (Mega_Analysis_Win.IsDisposed)
                {
                    Mega_Analysis_Win = new Form();
                    Mega_Analysis_Text01 = new TextBox();
                    Mega_Analysis_Text02 = new TextBox();
                    Mega_Analysis_Text03 = new TextBox();
                    Mega_Analysis_Label01 = new Label();
                    Mega_Analysis_Label02 = new Label();
                    Mega_Analysis_Label03 = new Label();
                    Mega_Analysis_Label04 = new Label();
                    Mega_Analysis_Label05 = new Label();
                    Mega_Analysis_Label06 = new Label();
                    Mega_Analysis_Run = new Button();
                    Mega_Analysis_Close = new Button();
                    Mega_Analysis_Check_selection = new CheckBox();
                }
                Mega_Analysis_Win.Width = 400;
                Mega_Analysis_Win.Height = 400;

                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Text02);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Text01);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Text02);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Text03);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Label01);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Label02);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Label03);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Label04);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Label05);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Label06);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Run);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Close);
                Mega_Analysis_Win.Controls.Add(Mega_Analysis_Check_selection);

                Mega_Analysis_Win.Text = "Mega Analysis";
                Mega_Analysis_Text01.Text = "10";
                Mega_Analysis_Text02.Text = "10";
                Mega_Analysis_Text03.Text = "";
                Mega_Analysis_Label01.Text = "List size";
                Mega_Analysis_Label02.Text = "Threshold";
                Mega_Analysis_Label03.Text = "Gene selection";
                Mega_Analysis_Label04.Text = "The analysis can take up to 1 hour";
                Mega_Analysis_Label05.Text = "The analysis need a lot of computer resources";
                Mega_Analysis_Label06.Text = "Do not click anywhere while analysing";


                Mega_Analysis_Run.Text = "Run";
                Mega_Analysis_Close.Text = "Close";

                Mega_Analysis_Text01.Left = 15; Mega_Analysis_Text01.Top = 30;
                Mega_Analysis_Text02.Left = 15; Mega_Analysis_Text02.Top = 80;
                Mega_Analysis_Text03.Left = 15; Mega_Analysis_Text03.Top = 130;
                Mega_Analysis_Label01.Left = 200; Mega_Analysis_Label01.Top = 30;
                Mega_Analysis_Label02.Left = 200; Mega_Analysis_Label02.Top = 80;
                Mega_Analysis_Label03.Left = 200; Mega_Analysis_Label03.Top = 130;
                Mega_Analysis_Run.Left = 15; Mega_Analysis_Run.Top = 200;
                Mega_Analysis_Close.Left = 150; Mega_Analysis_Close.Top = 200;
                Mega_Analysis_Check_selection.Left = 150; Mega_Analysis_Check_selection.Top = 130;
                Mega_Analysis_Label04.Left = 15; Mega_Analysis_Label04.Top = 250; Mega_Analysis_Label04.Width = 350;
                Mega_Analysis_Label05.Left = 15; Mega_Analysis_Label05.Top = 280; Mega_Analysis_Label05.Width = 350;
                Mega_Analysis_Label06.Left = 15; Mega_Analysis_Label06.Top = 310; Mega_Analysis_Label06.Width = 350;

                Mega_Analysis_Win.Show();
                Mega_Analysis_Win.Font = new Font("Microsoft Sans Serif", 10);
                Mega_Analysis_Text01.DeselectAll();
                Mega_Analysis_Text02.DeselectAll();
                Mega_Analysis_Text03.DeselectAll();
                Mega_Analysis_Win.Refresh();
            }

            public static Form Mega_Analysis_Win_Status = new Form();
            public static Label Mega_Analysis_Status_Text01 = new Label();
            public static Label Mega_Analysis_Status_Text02 = new Label();
            public static Label Mega_Analysis_Status_Text03 = new Label();
            public static void Mega_Analysis_Form_Status()
            {
                if (Mega_Analysis_Win_Status.IsDisposed)
                {
                    Mega_Analysis_Win_Status = new Form();
                    Mega_Analysis_Status_Text01 = new Label();
                    Mega_Analysis_Status_Text02 = new Label();
                    Mega_Analysis_Status_Text03 = new Label();
                }
                Mega_Analysis_Win_Status.Width=400;
                Mega_Analysis_Win_Status.Height = 400;
                Mega_Analysis_Win_Status.Controls.Add(Mega_Analysis_Status_Text01);
                Mega_Analysis_Win_Status.Controls.Add(Mega_Analysis_Status_Text02);
                Mega_Analysis_Win_Status.Controls.Add(Mega_Analysis_Status_Text03);
                Mega_Analysis_Status_Text01.Left = 15; Mega_Analysis_Status_Text01.Top = 30; Mega_Analysis_Status_Text01.Width = 300;
                Mega_Analysis_Status_Text02.Left = 15; Mega_Analysis_Status_Text02.Top = 80; Mega_Analysis_Status_Text02.Width = 300;
                Mega_Analysis_Status_Text03.Left = 15; Mega_Analysis_Status_Text03.Top = 130; Mega_Analysis_Status_Text03.Width = 300;
                Mega_Analysis_Status_Text01.Text = "The analysis can take up to 1 hour";
                Mega_Analysis_Status_Text02.Text = "Analysis need a lot of computer resources";
                Mega_Analysis_Status_Text03.Text = "Do not click anywhere while analysing";
                Mega_Analysis_Win_Status.Show();
                Mega_Analysis_Win_Status.Font = new Font("Microsoft Sans Serif", 10);
                Mega_Analysis_Win_Status.Refresh();
            }
    }
}







