//*********************************************************
//
// Copyright (c) Microsoft. All rights reserved.
// This code is licensed under the MIT License (MIT).
// THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
// IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
// PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.
//
//*********************************************************

#include "stdafx.h"
#include "SimpleCamera.h"

float m_upDirection_y_counter = 0.0f;
float m_upDirection_x_counter = 0.0f;
float m_position_x_counter = 0.0f;
float m_position_y_counter = 0.0f;
float m_position_z_counter = 0.0f;
float m_position_x = -150;
float m_position_y = -150;
float m_position_z = -150;

POINT SimpleCamera::point;

XMFLOAT3 SimpleCamera::camera_position(-150, -150, -150);
XMFLOAT3 SimpleCamera::camera_lookDirection(1, 1, 1);
XMFLOAT3 SimpleCamera::camera_upDirection(0, 0, 1);

SimpleCamera::SimpleCamera():
	m_initialPosition(-150, -150, -150),
	m_position(m_initialPosition),
	m_yaw(XM_PI),
	m_pitch(0.0f),
	m_lookDirection(0, 1, 1),
	m_upDirection(0, 0, 1),
	m_moveSpeed(20.0f),
	m_turnSpeed(XM_PIDIV2)
{
	ZeroMemory(&m_keysPressed, sizeof(m_keysPressed));
}

void SimpleCamera::Init(XMFLOAT3 position)
{
	m_initialPosition = position;
	Reset();
}

void SimpleCamera::SetMoveSpeed(float unitsPerSecond)
{
	m_moveSpeed = unitsPerSecond;
}

void SimpleCamera::SetTurnSpeed(float radiansPerSecond)
{
	m_turnSpeed = radiansPerSecond;
}

void SimpleCamera::Reset()
{
//	m_position = m_initialPosition;
	m_yaw = XM_PI;
	m_pitch = 0.0f;
	m_lookDirection = { 1, 1, 1 };
}

void SimpleCamera::Update(float elapsedSeconds)
{
	
	// Calculate the move vector in camera space.
	XMFLOAT3 move(0, 0, 0);
		if (m_keysPressed.q)
		{
			m_upDirection_y_counter += 0.01f;
			m_upDirection.y =  sinf(m_upDirection_y_counter);
		}
		
		if (m_keysPressed.e)
		{
			m_upDirection_y_counter -= 0.01f;
			m_upDirection.y = sinf(m_upDirection_y_counter);
		}

		if (m_keysPressed.a)
		{
			m_position_x_counter += 0.01f;
			m_position_y_counter += 0.01f;
			m_position.x = m_position_x * cosf(m_position_x_counter);
			m_position.y = m_position_y * cosf(m_position_y_counter);
			m_lookDirection.x = 1.0f * cosf(m_position_x_counter);
			m_lookDirection.y = 1.0f * cosf(m_position_y_counter);
		}
		
		if (m_keysPressed.d)
		{
			m_position_x_counter -= 0.01f;
			m_position_y_counter -= 0.01f;
			m_position.x = m_position_x * cosf(m_position_x_counter);
			m_position.y = m_position_y * cosf(m_position_y_counter);
			m_lookDirection.x = 1.0f * cosf(m_position_x_counter);
			m_lookDirection.y = 1.0f * cosf(m_position_y_counter);
		}
		if (m_keysPressed.w)
		{
			m_position_z_counter += 0.01f;
			m_position_y_counter += 0.01f;
			m_position.z = m_position_z * cosf(m_position_z_counter);
			m_position.y = m_position_y * cosf(m_position_y_counter);
			m_lookDirection.z = 1.0f * cosf(m_position_z_counter);
			m_lookDirection.y = 1.0f * cosf(m_position_y_counter);
		}
		if (m_keysPressed.s)
		{
			m_position_z_counter -= 0.01f;
			m_position_y_counter -= 0.01f;
			m_position.z = m_position_z * cosf(m_position_z_counter);
			m_position.y = m_position_y * cosf(m_position_y_counter);
			m_lookDirection.z = 1.0f * cosf(m_position_z_counter);
			m_lookDirection.y = 1.0f * cosf(m_position_y_counter);
		}

		if (m_keysPressed.left)
		{
			m_position.x = m_position.x - 1.0f;
		}
		if (m_keysPressed.right)
		{
			m_position.x = m_position.x + 1.0f;	
		}
		if (m_keysPressed.up)
		{
			m_position.y = m_position.y + 1.0f;
		}
		if (m_keysPressed.down)
		{
			m_position.y = m_position.y - 1.0f;
		}
		SimpleCamera::camera_position = m_position;
		SimpleCamera::camera_lookDirection = m_lookDirection;
		SimpleCamera::camera_upDirection = m_upDirection;
}

XMMATRIX SimpleCamera::GetViewMatrix()
{
	return XMMatrixLookToRH(XMLoadFloat3(&m_position), XMLoadFloat3(&m_lookDirection), XMLoadFloat3(&m_upDirection));
}

XMMATRIX SimpleCamera::GetProjectionMatrix(float fov, float aspectRatio, float nearPlane, float farPlane)
{
	return XMMatrixPerspectiveFovRH(fov, aspectRatio, nearPlane, farPlane);
}

void SimpleCamera::OnKeyDown(WPARAM key)
{
	switch (key)
	{
	case 'W':
		m_keysPressed.w = true;
		break;
	case 'A':
		m_keysPressed.a = true;
		break;
	case 'S':
		m_keysPressed.s = true;
		break;
	case 'D':
		m_keysPressed.d = true;
		break;
	case 'Q':
		m_keysPressed.q = true;
		break;
	case 'E':
		m_keysPressed.e = true;
		break;
	case VK_LEFT:
		m_keysPressed.left = true;
		break;
	case VK_RIGHT:
		m_keysPressed.right = true;
		break;
	case VK_UP:
		m_keysPressed.up = true;
		break;
	case VK_DOWN:
		m_keysPressed.down = true;
		break;
	case VK_ESCAPE:
		Reset();
		break;
	}
}

void SimpleCamera::OnKeyUp(WPARAM key)
{
	switch (key)
	{
	case 'W':
		m_keysPressed.w = false;
		break;
	case 'A':
		m_keysPressed.a = false;
		break;
	case 'S':
		m_keysPressed.s = false;
		break;
	case 'D':
		m_keysPressed.d = false;
		break;
	case 'Q':
		m_keysPressed.q = false;
		break;
	case 'E':
		m_keysPressed.e = false;
	case VK_LEFT:
		m_keysPressed.left = false;
		break;
	case VK_RIGHT:
		m_keysPressed.right = false;
		break;
	case VK_UP:
		m_keysPressed.up = false;
		break;
	case VK_DOWN:
		m_keysPressed.down = false;
		break;
	}
}

